/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.swt.ChoiceComposite;
import org.eclipse.riena.ui.swt.lnf.LnFUpdater;
import org.eclipse.riena.ui.swt.utils.SWTControlFinder;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractChoiceRidget
extends AbstractSWTRidget {
    protected static final String CHOICE_RIDGET_LISTENER = "choiceRidget.listener";
    protected static final LnFUpdater LNF_UPDATER = LnFUpdater.getInstance();
    protected String[] optionLabels;
    protected WritableList optionsObservable = new WritableList();

    protected void layoutNewChildren() {
        ChoiceComposite control = (ChoiceComposite)this.getUIControl();
        if (SwtUtilities.isDisposed((Widget)control)) {
            return;
        }
        Control[] childrenButtonsOld = control.getChildrenButtons();
        int oldCount = childrenButtonsOld.length;
        int newCount = this.optionsObservable.toArray().length;
        this.createChildren(control, true);
        if (oldCount != newCount) {
            control.getParent().layout(true, false);
        }
    }

    protected void createChildren(ChoiceComposite control) {
        this.createChildren(control, false);
    }

    protected void createChildren(ChoiceComposite control, boolean reuseButtons) {
        if (control != null && !control.isDisposed()) {
            Object[] values = this.optionsObservable.toArray();
            Control[] childrenOld = control.getChildrenButtons();
            int i = 0;
            while (i < values.length) {
                Button button;
                String caption;
                Object value = values[i];
                String string = caption = this.optionLabels != null ? this.optionLabels[i] : String.valueOf(value);
                if (reuseButtons && i < childrenOld.length) {
                    button = (Button)childrenOld[i];
                    this.unconfigureOptionButton(button);
                    button.setText(caption);
                } else {
                    button = control.createChild(caption);
                }
                button.setData(value);
                this.configureOptionButton(button);
                ++i;
            }
            if (reuseButtons) {
                while (i < childrenOld.length) {
                    childrenOld[i++].dispose();
                }
            }
            this.updateSelection(control);
            LNF_UPDATER.updateUIControls((Composite)control, true);
        }
    }

    protected abstract void updateSelection(ChoiceComposite var1);

    protected abstract void configureOptionButton(Button var1);

    protected abstract void unconfigureOptionButton(Button var1);

    protected void disposeChildren(ChoiceComposite control) {
        if (control != null && !control.isDisposed()) {
            Control[] controlArray = control.getChildrenButtons();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.dispose();
                ++n2;
            }
        }
    }

    public int getChildrenCount(ChoiceComposite control) {
        if (SwtUtilities.isDisposed((Widget)control)) {
            return 0;
        }
        return control.getChildrenButtons().length;
    }

    @Override
    public boolean hasFocus() {
        if (this.getUIControl() != null) {
            Control control = this.getUIControl();
            if (control.isFocusControl()) {
                return true;
            }
            if (!(control instanceof Composite)) {
                return false;
            }
            ChildFocusChecker checker = new ChildFocusChecker((Composite)control);
            checker.run();
            return checker.childHasFocus;
        }
        return false;
    }

    private static class ChildFocusChecker
    extends SWTControlFinder {
        private boolean childHasFocus = false;

        public ChildFocusChecker(Composite composite) {
            super(composite);
        }

        public void handleBoundControl(Control control, String bindingProperty) {
            super.handleControl(control);
        }

        public void handleControl(Control control) {
            super.handleControl(control);
            if (control.isFocusControl()) {
                this.childHasFocus = true;
            }
        }
    }
}

