/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.riena.internal.ui.ridgets.swt.StructuredViewerFilterHolder;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractListRidget;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;

public class ListRidget
extends AbstractListRidget {
    private ListViewer viewer;
    private StructuredViewerFilterHolder filterHolder;

    public ListRidget() {
        this.selectionTypeEnforcer = new SelectionTypeEnforcer();
    }

    @Override
    protected void checkUIControl(Object uiControl) {
        this.checkType(uiControl, List.class);
    }

    public List getUIControl() {
        return (List)super.getUIControl();
    }

    @Override
    protected int getUIControlSelectionIndex() {
        return this.getUIControl().getSelectionIndex();
    }

    @Override
    protected int[] getUIControlSelectionIndices() {
        return this.getUIControl().getSelectionIndices();
    }

    @Override
    protected int getUIControlItemCount() {
        return this.getUIControl().getItemCount();
    }

    @Override
    protected void bindUIControl() {
        List control = this.getUIControl();
        if (control != null) {
            this.viewer = new ListViewer(control);
            if (this.hasViewerModel()) {
                this.configureViewer((AbstractListViewer)this.viewer);
            }
            this.updateComparator();
            this.updateEnabled(this.isEnabled());
            control.addSelectionListener(this.selectionTypeEnforcer);
            this.getFilterHolder().activate((StructuredViewer)this.viewer);
        }
    }

    @Override
    protected void unbindUIControl() {
        super.unbindUIControl();
        this.getFilterHolder().deactivate((StructuredViewer)this.viewer);
        List control = this.getUIControl();
        if (control != null) {
            control.removeSelectionListener(this.selectionTypeEnforcer);
        }
        this.viewer = null;
    }

    @Override
    protected AbstractListViewer getViewer() {
        return this.viewer;
    }

    @Override
    protected void updateEnabled(boolean isEnabled) {
        List list = this.getUIControl();
        if (list != null && list.getData("oldbg") == null) {
            list.setData("oldbg", (Object)list.getBackground());
        }
        if (isEnabled) {
            if (this.hasViewer()) {
                this.refreshViewer();
                this.disposeSelectionBindings();
                this.createSelectionBindings();
                list.setBackground((Color)list.getData("oldbg"));
            }
        } else {
            this.disposeSelectionBindings();
            if (this.hasViewer()) {
                this.refreshViewer();
                if (MarkerSupport.isHideDisabledRidgetContent()) {
                    list.deselectAll();
                }
            }
        }
        this.updateMarkers();
    }

    protected StructuredViewerFilterHolder getFilterHolder() {
        if (this.filterHolder == null) {
            this.filterHolder = new StructuredViewerFilterHolder();
        }
        return this.filterHolder;
    }

    public void setNativeToolTip(boolean nativeToolTip) {
    }

    private final class SelectionTypeEnforcer
    extends SelectionAdapter {
        private SelectionTypeEnforcer() {
        }

        public void widgetSelected(SelectionEvent e) {
            List control = (List)e.widget;
            if (ListRidget.this.isOutputOnly()) {
                this.revertSelection(control);
            } else if (ISelectableRidget.SelectionType.SINGLE.equals((Object)ListRidget.this.getSelectionType()) && control.getSelectionCount() > 1) {
                e.doit = false;
                this.selectFirstItem(control);
            }
        }

        private void selectFirstItem(List control) {
            control.setSelection(control.getSelectionIndex());
            Event event = new Event();
            event.type = 13;
            event.doit = true;
            control.notifyListeners(13, event);
        }

        private void revertSelection(List control) {
            control.setRedraw(false);
            try {
                ListRidget.this.viewer.setSelection((ISelection)new StructuredSelection(ListRidget.this.getSelection()));
            }
            finally {
                control.setRedraw(true);
            }
        }
    }
}

