/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.RienaStatus;
import org.eclipse.riena.internal.ui.ridgets.Activator;
import org.eclipse.riena.ui.ridgets.AbstractRidget;
import org.eclipse.riena.ui.ridgets.ClassRidgetMapper;
import org.eclipse.riena.ui.ridgets.ComplexRidgetResolver;
import org.eclipse.riena.ui.ridgets.IComplexRidget;
import org.eclipse.riena.ui.ridgets.ILabelRidget;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetResolver;
import org.eclipse.riena.ui.ridgets.IStatusMeterRidget;
import org.eclipse.riena.ui.ridgets.IStatuslineRidget;
import org.eclipse.riena.ui.ridgets.RidgetToStatuslineSubscriber;
import org.eclipse.riena.ui.ridgets.SubModuleUtils;

public abstract class AbstractCompositeRidget
extends AbstractRidget
implements IComplexRidget {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), AbstractCompositeRidget.class);
    private IRidgetResolver ridgetResolver = new ComplexRidgetResolver();
    private final PropertyChangeListener propertyChangeListener;
    private final Map<String, IRidget> ridgets;
    private Object uiControl;
    private boolean markedHidden;
    private boolean enabled = true;
    private boolean configured = false;
    private String toolTip = null;
    private final RidgetToStatuslineSubscriber ridgetToStatuslineSubscriber = new RidgetToStatuslineSubscriber();

    public AbstractCompositeRidget() {
        this.propertyChangeListener = new PropertyChangeHandler();
        this.ridgets = new HashMap<String, IRidget>();
    }

    @Override
    public void addRidget(String id, IRidget ridget) {
        IRidget oldRidget = this.getRidgetResolver().addRidget(id, ridget, this, this.ridgets);
        if (oldRidget == null) {
            ridget.addPropertyChangeListener(this.propertyChangeListener);
        } else {
            this.ridgetToStatuslineSubscriber.removeRidget(oldRidget);
        }
        this.ridgetToStatuslineSubscriber.addRidget(ridget);
    }

    @Override
    public boolean removeRidget(String id) {
        this.ridgetToStatuslineSubscriber.removeRidget((IRidget)this.getRidget(id));
        return this.getRidgetResolver().removeRidget(id, this.ridgets) != null;
    }

    @Override
    public void setStatuslineToShowMarkerMessages(IStatuslineRidget statuslineToShowMarkerMessages) {
        this.ridgetToStatuslineSubscriber.setStatuslineToShowMarkerMessages(statuslineToShowMarkerMessages, this.getRidgets());
    }

    @Override
    public String idOfRidget(IRidget ridget) {
        for (String ridgetId : this.ridgets.keySet()) {
            if (this.ridgets.get(ridgetId) != ridget) continue;
            return ridgetId;
        }
        return null;
    }

    @Override
    public void configureRidgets() {
    }

    @Override
    public String getID() {
        return null;
    }

    @Override
    public <R extends IRidget> R getRidget(String id) {
        return (R)this.getRidgetResolver().getRidget(id, this.ridgets);
    }

    @Override
    public <R extends IRidget> R getRidget(Class<R> ridgetClazz, String id) {
        Object ridget = this.getRidget(id);
        if (ridget != null) {
            if (!ridgetClazz.isInstance(ridget)) {
                LOGGER.log(1, "getRidget(Class, String): Actual ridget is not of desired type: ridget is " + ridget.getClass().getName() + ", desired is " + ridgetClazz.getName());
            }
            return ridget;
        }
        if (this.allowRidgetCreation()) {
            try {
                if (ridgetClazz.isInterface() || Modifier.isAbstract(ridgetClazz.getModifiers())) {
                    Class<? extends IRidget> mappedRidgetClazz = ClassRidgetMapper.getInstance().getRidgetClass(ridgetClazz);
                    if (mappedRidgetClazz != null) {
                        ridget = mappedRidgetClazz.newInstance();
                    }
                    Assert.isNotNull(ridget, (String)("Could not find a corresponding implementation for " + ridgetClazz.getName() + " in " + ClassRidgetMapper.class.getName()));
                } else {
                    ridget = (IRidget)ridgetClazz.newInstance();
                }
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            this.addRidget(id, (IRidget)ridget);
        }
        return ridget;
    }

    protected boolean allowRidgetCreation() {
        return RienaStatus.isTest() || !SubModuleUtils.isPrepareView();
    }

    @Override
    public Collection<? extends IRidget> getRidgets() {
        return new ArrayList<IRidget>(this.ridgets.values());
    }

    @Override
    public String getToolTipText() {
        return this.toolTip;
    }

    @Override
    public Object getUIControl() {
        return this.uiControl;
    }

    @Override
    public boolean hasFocus() {
        Collection<? extends IRidget> myRidgets = this.getRidgets();
        for (IRidget iRidget : myRidgets) {
            if (!iRidget.hasFocus()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isFocusable() {
        return this.getFirstFocusableRidget() != null;
    }

    @Override
    public boolean isVisible() {
        if (this.markedHidden) {
            return false;
        }
        if (this.getUIControl() != null) {
            return this.isUIControlVisible();
        }
        return this.savedVisibleState;
    }

    @Override
    public void requestFocus() {
        IRidget firstFocusableRidget = this.getFirstFocusableRidget();
        if (firstFocusableRidget != null) {
            firstFocusableRidget.requestFocus();
        }
    }

    private IRidget getFirstFocusableRidget() {
        for (IRidget iRidget : this.getRidgets()) {
            if (!iRidget.isFocusable() || !iRidget.isEnabled() || iRidget instanceof IMarkableRidget && ((IMarkableRidget)iRidget).isOutputOnly() || iRidget instanceof ILabelRidget || iRidget instanceof IStatusMeterRidget) continue;
            return iRidget;
        }
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.updateEnabled();
            if (enabled) {
                this.updateMarkersOfChildRidgets();
            }
        }
    }

    private void updateMarkersOfChildRidgets() {
        for (IRidget iRidget : this.getRidgets()) {
            if (!(iRidget instanceof IMarkableRidget)) continue;
            ((IMarkableRidget)iRidget).updateMarkers();
        }
    }

    @Override
    public void setFocusable(boolean focusable) {
        for (IRidget iRidget : this.getRidgets()) {
            iRidget.setFocusable(focusable);
        }
    }

    @Override
    public void setToolTipText(String toolTipText) {
        String oldValue = this.toolTip;
        this.toolTip = toolTipText;
        this.updateToolTipText();
        this.firePropertyChange("tooltip", oldValue, this.toolTip);
    }

    @Override
    public void setUIControl(Object uiControl) {
        this.checkUIControl(uiControl);
        this.unbindUIControl();
        this.savedVisibleState = this.getUIControl() != null ? this.isUIControlVisible() : this.savedVisibleState;
        this.uiControl = uiControl;
        this.updateVisible();
        this.updateEnabled();
        this.updateToolTipText();
        this.bindUIControl();
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.markedHidden == visible) {
            this.markedHidden = !visible;
            this.updateVisible();
        }
    }

    protected void bindUIControl() {
    }

    protected void checkUIControl(Object uiControl) {
    }

    @Override
    public void updateFromModel() {
        super.updateFromModel();
        for (IRidget ridget : this.ridgets.values()) {
            ridget.updateFromModel();
        }
    }

    protected final boolean isMarkedHidden() {
        return this.markedHidden;
    }

    protected boolean isUIControlVisible() {
        return true;
    }

    protected final void removeRidgets() {
        for (IRidget iRidget : this.getRidgets()) {
            this.ridgetToStatuslineSubscriber.removeRidget(iRidget);
        }
        this.ridgets.clear();
    }

    protected void unbindUIControl() {
    }

    protected void updateEnabled() {
    }

    protected void updateToolTipText() {
    }

    protected void updateVisible() {
    }

    @Override
    public void setConfigured(boolean configured) {
        this.configured = configured;
    }

    @Override
    public boolean isConfigured() {
        return this.configured;
    }

    public IRidgetResolver getRidgetResolver() {
        return this.ridgetResolver;
    }

    public void setRidgetResolver(IRidgetResolver ridgetResolver) {
        this.ridgetResolver = ridgetResolver;
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AbstractCompositeRidget.this.propertyChangeSupport.firePropertyChange(evt);
        }
    }
}

