/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.swt;

import org.eclipse.riena.internal.ui.swt.facades.WorkbenchFacade;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class MouseWheelAdapter
implements Listener {
    public static final int SCROLLING_STEP = 20;
    private final Control control;
    private final Scroller scroller;
    private int lastEventTime = 0;

    public MouseWheelAdapter(Control control, Scroller scroller) {
        this.control = control;
        this.scroller = scroller;
        final Display display = control.getDisplay();
        SWTFacade.getDefault().addFilterMouseWheel(display, this);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SWTFacade.getDefault().removeFilterMouseWheel(display, MouseWheelAdapter.this);
            }
        });
    }

    public void handleEvent(Event event) {
        if (this.scroller.mayScroll() && this.acceptEvent(event)) {
            this.lastEventTime = event.time;
            Rectangle navigationComponentBounds = this.control.getBounds();
            Point navigationPtAtDisplay = this.control.toDisplay(0, 0);
            navigationComponentBounds.x = navigationPtAtDisplay.x;
            navigationComponentBounds.y = navigationPtAtDisplay.y;
            if (event.widget instanceof Control) {
                Control widget = (Control)event.widget;
                Point evtPt = widget.toDisplay(event.getBounds().x, event.getBounds().y);
                if (navigationComponentBounds.contains(evtPt.x, evtPt.y)) {
                    if (event.count > 0) {
                        this.scroller.scrollUp(20);
                    } else {
                        this.scroller.scrollDown(20);
                    }
                }
            }
        }
    }

    private boolean acceptEvent(Event event) {
        boolean isCurrent = event.time > this.lastEventTime;
        Control control = (Control)event.widget;
        Shell activeShell = WorkbenchFacade.getInstance().getActiveWindowShell();
        boolean isActive = control.getShell() == activeShell;
        boolean isVisible = this.control.isVisible();
        return isCurrent && isActive && isVisible;
    }

    public static interface Scroller {
        public boolean mayScroll();

        public void scrollUp(int var1);

        public void scrollDown(int var1);
    }
}

