/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.ping;

import org.eclipse.riena.core.ping.IPingable;

public class PingFingerprint {
    private String name;

    private PingFingerprint() {
    }

    public PingFingerprint(IPingable pingable) {
        this(pingable, true);
    }

    public PingFingerprint(IPingable pingable, boolean isSingleton) {
        this(pingable, PingFingerprint.createPostfix(pingable, isSingleton));
    }

    protected static String createPostfix(IPingable pingable, boolean isSingleton) {
        if (!isSingleton) {
            return Integer.toString(System.identityHashCode(pingable));
        }
        return null;
    }

    public PingFingerprint(IPingable pingable, String postfix) {
        StringBuilder bob = new StringBuilder(pingable.getClass().getName());
        if (postfix != null) {
            bob.append("#");
            bob.append(postfix);
        }
        this.name = bob.toString();
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (!(other instanceof PingFingerprint)) {
            return false;
        }
        return this.name.equals(((PingFingerprint)other).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "PingFingerprint[" + this.name + "]";
    }
}

