/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.demo.client.lnf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.riena.internal.demo.client.Activator;
import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.ui.swt.component.SubApplicationItem;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.SubApplicationSwitcherRenderer;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebThemeHeaderRenderer
extends SubApplicationSwitcherRenderer {
    private Browser browser;
    private List<SubApplicationItem> items;
    private String template = this.loadTemplate("/theme/header_template.html");

    public WebThemeHeaderRenderer() {
        String baseURL = this.getBaseURL();
        this.template = this.template.replace("%URL%", baseURL);
    }

    public void paint(GC gc, Object value) {
        if (this.browser == null) {
            Canvas parent = (Canvas)value;
            parent.setLayout((Layout)new FillLayout());
            this.browser = new Browser((Composite)parent, 0);
            new SubApplicationSwitchFunction(this.browser, "activateSubApplication");
            new MenuFunction(this.browser, "menuAction");
            this.browser.setText(this.template);
        }
        if (this.browser.isDisposed()) {
            return;
        }
    }

    private String getBaseURL() {
        ServletContext sc = RWT.getRequest().getSession().getServletContext();
        String realPath = sc.getRealPath("/");
        HttpServletRequest request = RWT.getRequest();
        String ip = request.getLocalAddr();
        int port = request.getLocalPort();
        String URL = "http://" + ip + ":" + port;
        String webAppName = "";
        if (realPath == null) {
            return URL;
        }
        webAppName = sc.getContextPath();
        return String.valueOf(URL) + webAppName;
    }

    public Rectangle getBounds() {
        Rectangle bounds = super.getBounds();
        return new Rectangle(0, 0, bounds.width, bounds.height);
    }

    private List<SubApplicationItem> getVisibleItems() {
        ArrayList<SubApplicationItem> visibleItems = new ArrayList<SubApplicationItem>();
        for (SubApplicationItem item : this.getItems()) {
            if (!item.getMarkersOfType(HiddenMarker.class).isEmpty()) continue;
            visibleItems.add(item);
        }
        return visibleItems;
    }

    public void setItems(List<SubApplicationItem> items) {
        this.items = items;
    }

    private List<SubApplicationItem> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<SubApplicationItem>();
        }
        return this.items;
    }

    private File getTemplate(String templateName) {
        Bundle bundle = null;
        Bundle[] bundleArray = Platform.getFragments((Bundle)Activator.getDefault().getBundle());
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle frag = bundleArray[n2];
            if ("org.eclipse.riena.demo.client.webtheme".equals(frag.getSymbolicName())) {
                bundle = frag;
                break;
            }
            ++n2;
        }
        URL fileURL = bundle.getEntry(templateName);
        try {
            URL realUrl = FileLocator.resolve((URL)fileURL);
            File file = new File(realUrl.toURI());
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String loadTemplate(String templateName) {
        StringBuilder bob;
        block14: {
            FileReader fileReader = null;
            try {
                File template = this.getTemplate(templateName);
                fileReader = new FileReader(template);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            BufferedReader br = new BufferedReader(fileReader);
            bob = new StringBuilder();
            String line = null;
            try {
                try {
                    while ((line = br.readLine()) != null) {
                        bob.append(line).append("\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bob.toString();
    }

    private class MenuFunction
    extends BrowserFunction {
        public MenuFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            Object param = arguments[0];
            String value = (String)param;
            if ("new".equals(value)) {
                ApplicationNodeManager.getApplicationNode().navigate(new NavigationNodeId("riena.demo.client.CustomerRecord"));
            } else if ("history.back".equals(value)) {
                ApplicationNodeManager.getApplicationNode().historyBack();
            } else if ("history.forward".equals(value)) {
                ApplicationNodeManager.getApplicationNode().historyForward();
            }
            return null;
        }
    }

    private class SubApplicationSwitchFunction
    extends BrowserFunction {
        public SubApplicationSwitchFunction(Browser browser, String name) {
            super(browser, name);
        }

        public Object function(Object[] arguments) {
            Object param = arguments[0];
            int index = Integer.parseInt((String)param);
            SubApplicationItem subApplicationItem = (SubApplicationItem)WebThemeHeaderRenderer.this.getVisibleItems().get(index);
            ISubApplicationNode subApplicationNode = subApplicationItem.getSubApplicationNode();
            subApplicationNode.activate();
            return null;
        }
    }
}

