/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonFactory;
import org.eclipse.riena.beans.common.PersonManager;
import org.eclipse.riena.internal.example.client.beans.PersonModificationBean;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;

public class ComboSubModuleController
extends SubModuleController {
    private final PersonManager manager = new PersonManager((Collection)PersonFactory.createPersonList());
    private PersonModificationBean value;
    private IComboRidget comboOne;
    private ITextRidget textFirst;
    private ITextRidget textLast;

    public ComboSubModuleController() {
        this(null);
    }

    public ComboSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
        this.manager.setSelectedPerson((Person)this.manager.getPersons().iterator().next());
        this.value = new PersonModificationBean();
    }

    public void afterBind() {
        super.afterBind();
        this.bindModels();
    }

    private void bindModels() {
        this.comboOne.bindToModel((Object)this.manager, "persons", String.class, null, (Object)this.manager, "selectedPerson");
        this.comboOne.updateFromModel();
        this.textFirst.bindToModel((Object)this.value, "firstName");
        this.textFirst.updateFromModel();
        this.textLast.bindToModel((Object)this.value, "lastName");
        this.textLast.updateFromModel();
    }

    public void configureRidgets() {
        this.comboOne = (IComboRidget)this.getRidget(IComboRidget.class, "comboOne");
        this.value.setPerson(this.manager.getSelectedPerson());
        this.textFirst = (ITextRidget)this.getRidget(ITextRidget.class, "textFirst");
        this.textLast = (ITextRidget)this.getRidget(ITextRidget.class, "textLast");
        if (((ISubModuleNode)this.getNavigationNode()).getNavigationArgument() != null && ((ISubModuleNode)this.getNavigationNode()).getNavigationArgument().getParameter() instanceof PersonModificationBean) {
            this.setValuesFromNavigation();
        }
        this.comboOne.addPropertyChangeListener("selection", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Person selectedPerson = (Person)evt.getNewValue();
                ComboSubModuleController.this.value.setPerson(selectedPerson);
                ComboSubModuleController.this.textFirst.updateFromModel();
                ComboSubModuleController.this.textLast.updateFromModel();
            }
        });
        IActionRidget buttonSave = (IActionRidget)this.getRidget(IActionRidget.class, "buttonSave");
        buttonSave.setText("&Save");
        buttonSave.addListener(new IActionListener(){

            public void callback() {
                ComboSubModuleController.this.value.update();
                ComboSubModuleController.this.comboOne.updateFromModel();
            }
        });
        final IToggleButtonRidget buttonSecondValue = (IToggleButtonRidget)this.getRidget("buttonSecondValue");
        if (buttonSecondValue != null) {
            buttonSecondValue.setText("Always use second person!");
            buttonSecondValue.addListener(new IActionListener(){

                public void callback() {
                    if (buttonSecondValue.isSelected()) {
                        if (ComboSubModuleController.this.manager.getPersons().size() > 1) {
                            Iterator iterator = ComboSubModuleController.this.manager.getPersons().iterator();
                            iterator.next();
                            Person second = (Person)iterator.next();
                            ComboSubModuleController.this.manager.setSelectedPerson(second);
                        }
                        ComboSubModuleController.this.comboOne.setOutputOnly(true);
                    } else {
                        ComboSubModuleController.this.comboOne.setOutputOnly(false);
                    }
                    System.out.println("Selected Person: " + ComboSubModuleController.this.manager.getSelectedPerson());
                    ComboSubModuleController.this.comboOne.updateFromModel();
                }
            });
        }
        ((ISubModuleNode)this.getNavigationNode()).addListener((INavigationNodeListener)new NavigateSubModuleNavigationNodeListener());
    }

    private void setValuesFromNavigation() {
        NavigationArgument navigationArgument = ((ISubModuleNode)this.getNavigationNode()).getNavigationArgument();
        if (navigationArgument != null) {
            this.value = (PersonModificationBean)navigationArgument.getParameter();
            this.manager.setSelectedPerson(this.value.getPerson());
            this.bindModels();
        }
    }

    private class NavigateSubModuleNavigationNodeListener
    extends SubModuleNodeListener {
        private NavigateSubModuleNavigationNodeListener() {
        }

        public void afterActivated(ISubModuleNode source) {
            super.afterActivated((INavigationNode)source);
            if (((ISubModuleNode)ComboSubModuleController.this.getNavigationNode()).getNavigationArgument() != null && ((ISubModuleNode)ComboSubModuleController.this.getNavigationNode()).getNavigationArgument().getParameter() instanceof PersonModificationBean) {
                ComboSubModuleController.this.setValuesFromNavigation();
            }
        }
    }
}

