/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.monitor.client;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.log.ExtendedLogEntry;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.riena.core.logging.SynchronousLogListenerAdapter;
import org.eclipse.riena.core.util.Literal;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.core.wire.InjectService;
import org.eclipse.riena.monitor.client.AbstractCollector;
import org.eclipse.riena.monitor.client.ILogServiceCollectorFilter;
import org.eclipse.riena.monitor.client.Range;
import org.eclipse.riena.monitor.common.LogEntryTransferObject;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

public class LogServiceCollector
extends AbstractCollector
implements IExecutableExtension {
    private Range collectRange;
    private Range triggerRange;
    private ILogServiceCollectorFilter filter;
    private boolean async;
    private ExtendedLogReaderService extendedLogReaderService;
    private LogListener logListener;
    private static final String TRIGGER_RANGE = "triggerRange";
    private static final String COLLECT_RANGE = "collectRange";
    private static final String FILTER_CLASS = "filterClass";
    private static final String ASYNC_EXEC = "async";
    private static final String ASYNC_EXEC_DEFAULT = Boolean.TRUE.toString();

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        Map properties = null;
        try {
            properties = PropertiesUtils.asMap((Object)data, (Map)Literal.map((Object)ASYNC_EXEC, (Object)ASYNC_EXEC_DEFAULT), (String[])new String[]{TRIGGER_RANGE});
            String collectRangeString = (String)properties.get(COLLECT_RANGE);
            this.collectRange = new Range(collectRangeString != null ? collectRangeString : "*");
            this.triggerRange = new Range((String)properties.get(TRIGGER_RANGE));
            this.filter = this.newFilter(config, (String)properties.get(FILTER_CLASS));
            this.async = Boolean.parseBoolean((String)properties.get(ASYNC_EXEC));
            this.logListener = this.newLogListener();
        }
        catch (IllegalArgumentException e) {
            throw this.configurationException("Bad configuration.", e);
        }
    }

    private ILogServiceCollectorFilter newFilter(IConfigurationElement configurationElement, String filterClassName) {
        if (filterClassName == null) {
            return null;
        }
        Bundle bundle = ContributorFactoryOSGi.resolve((IContributor)configurationElement.getContributor());
        Assert.isLegal((bundle != null ? 1 : 0) != 0, (String)("Could not get bundle for filter class " + filterClassName));
        try {
            return (ILogServiceCollectorFilter)bundle.loadClass(filterClassName).newInstance();
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Could not create filter instance for class " + filterClassName, t);
        }
    }

    @Override
    protected void doStart() {
        if (this.extendedLogReaderService == null) {
            return;
        }
        this.extendedLogReaderService.addLogListener(this.logListener);
    }

    @Override
    protected void doStop() {
        if (this.extendedLogReaderService == null) {
            return;
        }
        this.extendedLogReaderService.removeLogListener(this.logListener);
    }

    @InjectService(useRanking=true)
    public void bind(ExtendedLogReaderService extendedLogReaderService) {
        this.extendedLogReaderService = extendedLogReaderService;
    }

    public void unbind(ExtendedLogReaderService extendedLogReaderService) {
        extendedLogReaderService.removeLogListener(this.logListener);
        this.extendedLogReaderService = null;
    }

    private LogListener newLogListener() {
        LogListener listener = new LogListener(){

            public void logged(LogEntry entry) {
                if (!LogServiceCollector.this.collectRange.matches(entry.getLevel())) {
                    return;
                }
                if (LogServiceCollector.this.filter != null && !LogServiceCollector.this.filter.isCollectible((ExtendedLogEntry)entry)) {
                    return;
                }
                LogServiceCollector.this.collect(new LogEntryTransferObject((ExtendedLogEntry)entry));
                if (LogServiceCollector.this.triggerRange.matches(entry.getLevel())) {
                    LogServiceCollector.this.triggerTransfer();
                }
            }
        };
        return this.async ? listener : new SynchronousLogListenerAdapter(listener);
    }

    private CoreException configurationException(String message, Exception e) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.riena.monitor.client", message, (Throwable)e));
    }
}

