/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.RienaStatus;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.navigation.INavigationContext;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeController;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.annotation.processor.NavigationNodeControllerAnnotationProcessor;
import org.eclipse.riena.navigation.common.TypecastingObject;
import org.eclipse.riena.navigation.listener.INavigationNodeListenerable;
import org.eclipse.riena.navigation.ui.controllers.NavigationUIFilterApplier;
import org.eclipse.riena.ui.core.context.IContext;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.ridgets.ClassRidgetMapper;
import org.eclipse.riena.ui.ridgets.ComplexRidgetResolver;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.IRidgetResolver;
import org.eclipse.riena.ui.ridgets.IStatuslineRidget;
import org.eclipse.riena.ui.ridgets.IWindowRidget;
import org.eclipse.riena.ui.ridgets.RidgetToStatuslineSubscriber;
import org.eclipse.riena.ui.ridgets.SubModuleUtils;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.riena.ui.ridgets.marker.MarkerUtil;

public abstract class NavigationNodeController<N extends INavigationNode<?>>
extends TypecastingObject
implements INavigationNodeController,
IController,
IContext {
    protected IRidgetResolver ridgetResolver = new ComplexRidgetResolver();
    private N navigationNode;
    private Map<String, IRidget> ridgets;
    private NavigationUIFilterApplier<N> nodeListener;
    private PropertyChangeListener propertyChangeListener;
    private boolean configured = false;
    private final RidgetToStatuslineSubscriber ridgetToStatuslineSubscriber = new RidgetToStatuslineSubscriber();

    public NavigationNodeController() {
        this(null);
    }

    public NavigationNodeController(N navigationNode) {
        this.ridgets = new HashMap<String, IRidget>();
        this.propertyChangeListener = new PropertyChangeHandler();
        this.nodeListener = new NavigationUIFilterApplier();
        if (navigationNode != null) {
            this.setNavigationNode(navigationNode);
        }
    }

    public N getNavigationNode() {
        return this.navigationNode;
    }

    public void setNavigationNode(N navigationNode) {
        if (this.getNavigationNode() instanceof INavigationNodeListenerable) {
            ((INavigationNodeListenerable)this.getNavigationNode()).removeListener(this.nodeListener);
        }
        this.navigationNode = navigationNode;
        navigationNode.setNavigationNodeController((INavigationNodeController)this);
        this.updateNavigationNodeMarkers();
        if (this.getNavigationNode() instanceof INavigationNodeListenerable) {
            ((INavigationNodeListenerable)this.getNavigationNode()).addListener(this.nodeListener);
        }
    }

    public boolean allowsActivate(INavigationNode<?> pNode, INavigationContext context) {
        return true;
    }

    public boolean allowsDeactivate(INavigationNode<?> pNode, INavigationContext context) {
        return true;
    }

    public void afterBind() {
        NavigationNodeControllerAnnotationProcessor.getInstance().processAnnotations((INavigationNodeController)this);
        this.updateNavigationNodeMarkers();
    }

    public boolean isActivated() {
        return this.getNavigationNode() != null && this.getNavigationNode().isActivated();
    }

    public boolean isEnabled() {
        return this.getNavigationNode() != null && this.getNavigationNode().isEnabled();
    }

    public boolean isVisible() {
        return this.getNavigationNode() != null && this.getNavigationNode().isVisible();
    }

    public boolean isDeactivated() {
        return this.getNavigationNode() == null || this.getNavigationNode().isDeactivated();
    }

    public boolean isCreated() {
        return this.getNavigationNode() == null || this.getNavigationNode().isCreated();
    }

    public boolean allowsDispose(INavigationNode<?> node, INavigationContext context) {
        return true;
    }

    public void addRidget(String id, IRidget ridget) {
        ridget.addPropertyChangeListener("marker", this.propertyChangeListener);
        ridget.addPropertyChangeListener("markerHiding", this.propertyChangeListener);
        ridget.addPropertyChangeListener("showing", this.propertyChangeListener);
        ridget.addPropertyChangeListener("update", this.propertyChangeListener);
        this.ridgets.put(id, ridget);
        this.ridgetToStatuslineSubscriber.addRidget(ridget);
    }

    public boolean removeRidget(String id) {
        this.ridgetToStatuslineSubscriber.removeRidget(this.getRidget(id));
        return this.ridgets.remove(id) != null;
    }

    public void setStatuslineToShowMarkerMessages(IStatuslineRidget statuslineToShowMarkerMessages) {
        this.ridgetToStatuslineSubscriber.setStatuslineToShowMarkerMessages(statuslineToShowMarkerMessages, this.getRidgets());
    }

    public <R extends IRidget> R getRidget(String id) {
        return (R)this.ridgetResolver.getRidget(id, this.ridgets);
    }

    public <R extends IRidget> R getRidget(Class<R> ridgetClazz, String id) {
        Object ridget = this.getRidget(id);
        if (ridget != null) {
            return ridget;
        }
        if (!SubModuleUtils.isPrepareView() || RienaStatus.isTest()) {
            try {
                if (ridgetClazz.isInterface() || Modifier.isAbstract(ridgetClazz.getModifiers())) {
                    Class mappedRidgetClazz = ClassRidgetMapper.getInstance().getRidgetClass(ridgetClazz);
                    if (mappedRidgetClazz != null) {
                        ridget = (IRidget)mappedRidgetClazz.newInstance();
                    }
                    Assert.isNotNull(ridget, (String)("Could not find a corresponding implementation for " + ridgetClazz.getName() + " in " + ClassRidgetMapper.class.getName()));
                } else {
                    ridget = (IRidget)ridgetClazz.newInstance();
                }
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            this.ridgetResolver.addRidget(id, ridget, (IRidgetContainer)this, this.ridgets);
        }
        return ridget;
    }

    public Collection<? extends IRidget> getRidgets() {
        return this.ridgets.values();
    }

    protected void updateNavigationNodeMarkers() {
        Collection mandatoryInNode;
        ArrayList<ErrorMarker> errorInRidgets = new ArrayList<ErrorMarker>();
        ArrayList<MandatoryMarker> mandatoryInRidgets = new ArrayList<MandatoryMarker>();
        for (IMarker marker : this.getRidgetMarkers()) {
            MandatoryMarker mandatoryMarker;
            if (marker instanceof ErrorMarker) {
                errorInRidgets.add((ErrorMarker)marker);
                continue;
            }
            if (!(marker instanceof MandatoryMarker) || (mandatoryMarker = (MandatoryMarker)marker).isDisabled()) continue;
            mandatoryInRidgets.add(mandatoryMarker);
        }
        Collection errorInNode = this.getNavigationNode().getMarkersOfType(ErrorMarker.class);
        if (errorInNode.isEmpty() && !errorInRidgets.isEmpty()) {
            this.getNavigationNode().addMarker((IMarker)errorInRidgets.iterator().next());
        }
        if (!errorInNode.isEmpty() && errorInRidgets.isEmpty()) {
            this.getNavigationNode().removeMarker((IMarker)errorInNode.iterator().next());
        }
        if ((mandatoryInNode = this.getNavigationNode().getMarkersOfType(MandatoryMarker.class)).isEmpty() && !mandatoryInRidgets.isEmpty()) {
            this.getNavigationNode().addMarker((IMarker)mandatoryInRidgets.iterator().next());
        }
        if (!mandatoryInNode.isEmpty() && mandatoryInRidgets.isEmpty()) {
            this.getNavigationNode().removeMarker((IMarker)mandatoryInNode.iterator().next());
        }
        ArrayList<MandatoryMarker> enabledMandatoryInNode = new ArrayList<MandatoryMarker>();
        ArrayList<MandatoryMarker> disabledMandatoryInNode = new ArrayList<MandatoryMarker>();
        for (MandatoryMarker m : new ArrayList(mandatoryInNode)) {
            if (m.isDisabled()) {
                disabledMandatoryInNode.add(m);
                continue;
            }
            enabledMandatoryInNode.add(m);
        }
        if (enabledMandatoryInNode.isEmpty() && !disabledMandatoryInNode.isEmpty() && !mandatoryInRidgets.isEmpty()) {
            this.getNavigationNode().removeMarker((IMarker)disabledMandatoryInNode.iterator().next());
            this.getNavigationNode().addMarker((IMarker)mandatoryInRidgets.iterator().next());
        }
    }

    private List<IMarker> getRidgetMarkers() {
        return MarkerUtil.getRidgetMarkers((IRidgetContainer)this);
    }

    protected void updateIcon(IWindowRidget windowRidget) {
        if (windowRidget == null) {
            return;
        }
        String nodeIcon = this.getNavigationNode().getIcon();
        windowRidget.setIcon(nodeIcon);
    }

    public void setBlocked(boolean blocked) {
        if (this.getNavigationNode() != null) {
            this.getNavigationNode().setBlocked(blocked);
        }
    }

    public boolean isBlocked() {
        return this.getNavigationNode() != null && this.getNavigationNode().isBlocked();
    }

    public NavigationNodeController<?> getParentController() {
        if (this.getNavigationNode() != null && this.getNavigationNode().getParent() == null) {
            return null;
        }
        return (NavigationNodeController)this.navigationNode.getParent().getNavigationNodeController();
    }

    public void setContext(String key, Object value) {
        Assert.isNotNull(this.getNavigationNode(), (String)"NavigationNode may not be null");
        this.getNavigationNode().setContext(key, value);
    }

    public Object getContext(String key) {
        Assert.isNotNull(this.getNavigationNode(), (String)"NavigationNode may not be null");
        return this.getNavigationNode().getContext(key);
    }

    public void navigationArgumentChanged(NavigationArgument argument) {
    }

    public void setConfigured(boolean configured) {
        this.configured = configured;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            NavigationNodeController.this.updateNavigationNodeMarkers();
        }
    }
}

