/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.util.List;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.core.util.Literal;
import org.eclipse.riena.core.util.Orderer;

@NonUITestCase
public class OrdererTest
extends RienaTestCase {
    public void testNoDependencies() {
        Orderer o = new Orderer();
        o.add((Object)"FRED", "fred", null, null);
        o.add((Object)"BARNEY", "barney", null, null);
        o.add((Object)"WILMA", "wilma", null, null);
        o.add((Object)"BETTY", "betty", null, null);
        List l = o.getOrderedObjects();
        OrdererTest.assertEquals((Object)Literal.list((Object)"FRED").list((Object)"BARNEY").list((Object)"WILMA").list((Object)"BETTY"), (Object)l);
    }

    public void testPrereq() {
        Orderer o = new Orderer();
        o.add((Object)"FRED", "fred", "wilma", null);
        o.add((Object)"BARNEY", "barney", "betty", null);
        o.add((Object)"BETTY", "betty", null, null);
        o.add((Object)"WILMA", "wilma", null, null);
        List l = o.getOrderedObjects();
        OrdererTest.assertEquals((Object)Literal.list((Object)"WILMA").list((Object)"FRED").list((Object)"BETTY").list((Object)"BARNEY"), (Object)l);
    }

    public void testPostreq() {
        Orderer o = new Orderer();
        o.add((Object)"FRED", "fred", null, "barney,wilma");
        o.add((Object)"BARNEY", "barney", null, "betty");
        o.add((Object)"BETTY", "betty", null, null);
        o.add((Object)"WILMA", "wilma", null, null);
        List l = o.getOrderedObjects();
        OrdererTest.assertEquals((Object)Literal.list((Object)"FRED").list((Object)"BARNEY").list((Object)"BETTY").list((Object)"WILMA"), (Object)l);
    }

    public void testPrePostreq() {
        Orderer o = new Orderer();
        o.add((Object)"FRED", "fred", null, "barney,wilma");
        o.add((Object)"BARNEY", "barney", "wilma", "betty");
        o.add((Object)"BETTY", "betty", null, null);
        o.add((Object)"WILMA", "wilma", null, null);
        List l = o.getOrderedObjects();
        OrdererTest.assertEquals((Object)Literal.list((Object)"FRED").list((Object)"WILMA").list((Object)"BARNEY").list((Object)"BETTY"), (Object)l);
    }

    public void testUnknownPrereq() {
        Orderer o = new Orderer();
        o.add((Object)"FRED", "fred", "charlie", "barney,wilma");
        o.add((Object)"BARNEY", "barney", "wilma", "betty");
        o.add((Object)"BETTY", "betty", null, null);
        o.add((Object)"WILMA", "wilma", null, null);
        List l = o.getOrderedObjects();
        OrdererTest.assertEquals((Object)Literal.list((Object)"FRED").list((Object)"WILMA").list((Object)"BARNEY").list((Object)"BETTY"), (Object)l);
    }

    public void testUnknownPostreq() {
        Orderer o = new Orderer();
        o.add((Object)"FRED", "fred", null, "barney,wilma");
        o.add((Object)"BARNEY", "barney", "wilma", "betty");
        o.add((Object)"BETTY", "betty", null, "dino");
        o.add((Object)"WILMA", "wilma", null, null);
        List l = o.getOrderedObjects();
        OrdererTest.assertEquals((Object)Literal.list((Object)"FRED").list((Object)"WILMA").list((Object)"BARNEY").list((Object)"BETTY"), (Object)l);
    }

    public void testCyclePre() {
        try {
            Orderer o = new Orderer();
            o.add((Object)"FRED", "fred", "wilma", null);
            o.add((Object)"BARNEY", "barney", "betty", null);
            o.add((Object)"BETTY", "betty", "fred", null);
            o.add((Object)"WILMA", "wilma", "barney", null);
            o.getOrderedObjects();
            OrdererTest.fail();
        }
        catch (Orderer.OrdererFailure e) {
            OrdererTest.assertTrue((boolean)e.getMessage().contains("between 'wilma'"));
        }
    }

    public void testCyclePost() {
        try {
            Orderer o = new Orderer();
            o.add((Object)"WILMA", "wilma", null, "betty");
            o.add((Object)"FRED", "fred", null, "barney");
            o.add((Object)"BARNEY", "barney", null, "wilma");
            o.add((Object)"BETTY", "betty", null, "fred");
            o.getOrderedObjects();
            OrdererTest.fail();
        }
        catch (Orderer.OrdererFailure e) {
            OrdererTest.assertTrue((boolean)e.getMessage().contains("between 'fred' and 'betty'"));
        }
    }

    public void testDupe() {
        Orderer o = new Orderer();
        o.add((Object)"FRED", "flintstone", null, null);
        o.add((Object)"BARNEY", "rubble", null, null);
        try {
            o.add((Object)"WILMA", "flintstone", null, null);
            OrdererTest.fail();
        }
        catch (Orderer.OrdererFailure e) {
            OrdererTest.assertTrue((boolean)e.getMessage().contains("'flintstone'"));
        }
    }

    public void testPreStar() {
        Orderer o = new Orderer();
        o.add((Object)"FRED", "fred", "*", null);
        o.add((Object)"BARNEY", "barney", "betty", null);
        o.add((Object)"WILMA", "wilma", "betty", null);
        o.add((Object)"BETTY", "betty", null, null);
        List l = o.getOrderedObjects();
        OrdererTest.assertEquals((Object)Literal.list((Object)"BETTY").list((Object)"BARNEY").list((Object)"WILMA").list((Object)"FRED"), (Object)l);
    }

    public void testPreStartDupe() {
        Orderer o = new Orderer();
        o.add((Object)"FRED", "fred", "*", null);
        o.add((Object)"BARNEY", "barney", "*", null);
        o.add((Object)"WILMA", "wilma", "betty", null);
        o.add((Object)"BETTY", "betty", null, null);
        try {
            List l = o.getOrderedObjects();
            OrdererTest.assertEquals((Object)Literal.list((Object)"BARNEY").list((Object)"BETTY").list((Object)"WILMA").list((Object)"FRED"), (Object)l);
            OrdererTest.fail();
        }
        catch (Orderer.OrdererFailure e) {
            OrdererTest.assertTrue((boolean)e.getMessage().contains("More than one trailer. Conflicting 'fred' (ordered unknown) and 'barney' (last)"));
        }
    }

    public void testPostStar() {
        Orderer o = new Orderer();
        o.add((Object)"FRED", "fred", null, "wilma");
        o.add((Object)"BARNEY", "barney", null, "*");
        o.add((Object)"WILMA", "wilma", null, "betty");
        o.add((Object)"BETTY", "betty", null, null);
        List l = o.getOrderedObjects();
        OrdererTest.assertEquals((Object)Literal.list((Object)"BARNEY").list((Object)"FRED").list((Object)"WILMA").list((Object)"BETTY"), (Object)l);
    }

    public void testPostStarDupe() {
        Orderer o = new Orderer();
        o.add((Object)"FRED", "fred", null, "wilma");
        o.add((Object)"BARNEY", "barney", null, "*");
        o.add((Object)"WILMA", "wilma", null, "*");
        o.add((Object)"BETTY", "betty", null, null);
        try {
            List l = o.getOrderedObjects();
            OrdererTest.assertEquals((Object)Literal.list((Object)"BARNEY").list((Object)"FRED").list((Object)"WILMA").list((Object)"BETTY"), (Object)l);
            OrdererTest.fail();
        }
        catch (Orderer.OrdererFailure e) {
            OrdererTest.assertTrue((boolean)e.getMessage().contains("More than one leader. Conflicting 'barney' (ordered unknown) and 'wilma' (first)"));
        }
    }

    public void testNoObjects() {
        Orderer o = new Orderer();
        List l = o.getOrderedObjects();
        OrdererTest.assertEquals((int)0, (int)l.size());
    }
}

