/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.easymock.EasyMock;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.marker.OutputMarker;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTWidgetRidget;
import org.eclipse.riena.ui.tests.base.PropertyChangeEventEquals;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

@UITestCase
public abstract class AbstractRidgetTestCase
extends RienaTestCase {
    private Shell shell;
    private Object widget;
    private IRidget ridget;
    private Text otherControl;
    protected PropertyChangeListener propertyChangeListenerMock;

    protected abstract Object createWidget(Composite var1);

    protected abstract IRidget createRidget();

    protected Object getWidget() {
        return this.widget;
    }

    protected IRidget getRidget() {
        return this.ridget;
    }

    protected Shell getShell() {
        return this.shell;
    }

    protected Control getOtherControl() {
        return this.otherControl;
    }

    protected void setUp() throws Exception {
        super.setUp();
        Display display = Display.getDefault();
        Realm realm = SWTObservables.getRealm((Display)display);
        AbstractRidgetTestCase.assertNotNull((Object)realm);
        ReflectionUtils.invokeHidden((Object)realm, (String)"setDefault", (Object[])new Object[]{realm});
        this.shell = new Shell(147456);
        this.shell.setLayout((Layout)new RowLayout(512));
        this.widget = this.createWidget((Composite)this.shell);
        this.ridget = this.createRidget();
        this.ridget.setUIControl(this.widget);
        this.propertyChangeListenerMock = (PropertyChangeListener)EasyMock.createMock(PropertyChangeListener.class);
        this.ridget.addPropertyChangeListener(this.propertyChangeListenerMock);
        this.otherControl = new Text((Composite)this.shell, 4);
        this.otherControl.setText("other focusable widget");
        this.shell.setSize(130, 100);
        this.shell.setLocation(0, 0);
        this.shell.open();
    }

    protected void tearDown() throws Exception {
        this.ridget = null;
        this.widget = null;
        this.otherControl = null;
        this.shell.dispose();
        this.shell = null;
        super.tearDown();
    }

    protected final void resetPropertyChangeEvents() {
        EasyMock.reset((Object[])new Object[]{this.propertyChangeListenerMock});
    }

    protected final void verifyPropertyChangeEvents() {
        EasyMock.verify((Object[])new Object[]{this.propertyChangeListenerMock});
    }

    protected final void expectNoPropertyChangeEvent() {
        EasyMock.reset((Object[])new Object[]{this.propertyChangeListenerMock});
        EasyMock.replay((Object[])new Object[]{this.propertyChangeListenerMock});
    }

    protected final void expectPropertyChangeEvents(PropertyChangeEvent ... propertyChangeEvents) {
        EasyMock.reset((Object[])new Object[]{this.propertyChangeListenerMock});
        PropertyChangeEvent[] propertyChangeEventArray = propertyChangeEvents;
        int n = propertyChangeEvents.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeEvent propertyChangeEvent = propertyChangeEventArray[n2];
            this.propertyChangeListenerMock.propertyChange(this.createArgumentMatcher(propertyChangeEvent));
            ++n2;
        }
        EasyMock.replay((Object[])new Object[]{this.propertyChangeListenerMock});
    }

    protected final void expectPropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        this.expectPropertyChangeEvents(new PropertyChangeEvent(this.getRidget(), propertyName, oldValue, newValue));
    }

    public void testIsVisible() {
        this.getShell().open();
        AbstractRidgetTestCase.assertTrue((String)("Fails for " + this.getRidget()), (boolean)this.getRidget().isVisible());
        if (this.isWidgetControl()) {
            AbstractRidgetTestCase.assertTrue((String)("Fails for " + this.getRidget()), (boolean)((Control)this.getWidget()).isVisible());
        }
        this.getRidget().setVisible(false);
        AbstractRidgetTestCase.assertFalse((String)("Fails for " + this.getRidget()), (boolean)this.getRidget().isVisible());
        if (this.isWidgetControl()) {
            AbstractRidgetTestCase.assertFalse((String)("Fails for " + this.getRidget()), (boolean)((Control)this.getWidget()).isVisible());
        }
        this.getRidget().setVisible(true);
        AbstractRidgetTestCase.assertTrue((String)("Fails for " + this.getRidget()), (boolean)this.getRidget().isVisible());
        if (this.isWidgetControl()) {
            AbstractRidgetTestCase.assertTrue((String)("Fails for " + this.getRidget()), (boolean)((Control)this.getWidget()).isVisible());
        }
        this.getRidget().setUIControl(null);
        this.getRidget().setVisible(false);
        AbstractRidgetTestCase.assertFalse((String)("Fails for " + this.getRidget()), (boolean)this.getRidget().isVisible());
        if (this.isWidgetControl()) {
            AbstractRidgetTestCase.assertTrue((String)("Fails for " + this.getRidget()), (boolean)((Control)this.getWidget()).isVisible());
        }
        this.getRidget().setUIControl(this.getWidget());
        AbstractRidgetTestCase.assertFalse((String)("Fails for " + this.getRidget()), (boolean)this.getRidget().isVisible());
        if (this.isWidgetControl()) {
            AbstractRidgetTestCase.assertFalse((String)("Fails for " + this.getRidget()), (boolean)((Control)this.getWidget()).isVisible());
        }
    }

    public void testIsEnabled() throws Exception {
        AbstractRidgetTestCase.assertTrue((String)("Fails for " + this.getRidget()), (boolean)this.getRidget().isEnabled());
        if (this.isWidgetControl()) {
            AbstractRidgetTestCase.assertTrue((String)("Fails for " + this.getRidget()), (boolean)((Control)this.getWidget()).isEnabled());
        }
        this.getRidget().setEnabled(false);
        AbstractRidgetTestCase.assertFalse((String)("Fails for " + this.getRidget()), (boolean)this.getRidget().isEnabled());
        if (this.isWidgetControl()) {
            AbstractRidgetTestCase.assertFalse((String)("Fails for " + this.getRidget()), (boolean)((Control)this.getWidget()).isEnabled());
        }
        this.getRidget().setEnabled(false);
        AbstractRidgetTestCase.assertFalse((String)("Fails for " + this.getRidget()), (boolean)this.getRidget().isEnabled());
        if (this.isWidgetControl()) {
            AbstractRidgetTestCase.assertFalse((String)("Fails for " + this.getRidget()), (boolean)((Control)this.getWidget()).isEnabled());
        }
        this.getRidget().setEnabled(true);
        AbstractRidgetTestCase.assertTrue((String)("Fails for " + this.getRidget()), (boolean)this.getRidget().isEnabled());
        if (this.isWidgetControl()) {
            AbstractRidgetTestCase.assertTrue((String)("Fails for " + this.getRidget()), (boolean)((Control)this.getWidget()).isEnabled());
        }
        this.getRidget().setUIControl(null);
        this.getRidget().setEnabled(false);
        AbstractRidgetTestCase.assertFalse((String)("Fails for " + this.getRidget()), (boolean)this.getRidget().isEnabled());
        if (this.isWidgetControl()) {
            AbstractRidgetTestCase.assertTrue((String)("Fails for " + this.getRidget()), (boolean)((Control)this.getWidget()).isEnabled());
        }
        this.getRidget().setUIControl(this.getWidget());
        AbstractRidgetTestCase.assertFalse((String)("Fails for " + this.getRidget()), (boolean)this.getRidget().isEnabled());
        if (this.isWidgetControl()) {
            AbstractRidgetTestCase.assertFalse((String)("Fails for " + this.getRidget()), (boolean)((Control)this.getWidget()).isEnabled());
        }
    }

    public void testFiresTooltipProperty() {
        this.expectPropertyChangeEvent("tooltip", null, "begood");
        this.getRidget().setToolTipText("begood");
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        this.getRidget().setToolTipText("begood");
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvent("tooltip", "begood", null);
        this.getRidget().setToolTipText(null);
        this.verifyPropertyChangeEvents();
    }

    public void testFiresMarkerProperty() {
        if (!(this.getRidget() instanceof IBasicMarkableRidget)) {
            return;
        }
        IBasicMarkableRidget markableRidget = (IBasicMarkableRidget)this.getRidget();
        MandatoryMarker marker = new MandatoryMarker();
        ArrayList before = new ArrayList(markableRidget.getMarkers());
        ArrayList<MandatoryMarker> after = new ArrayList<MandatoryMarker>(before);
        after.add(marker);
        AbstractRidgetTestCase.assertTrue((String)("Fails for " + markableRidget), (boolean)markableRidget.isEnabled());
        AbstractRidgetTestCase.assertEquals((String)("Fails for " + markableRidget), (int)(before.size() + 1), (int)after.size());
        this.expectPropertyChangeEvent("marker", before, after);
        markableRidget.addMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        markableRidget.addMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvent("marker", after, before);
        markableRidget.removeMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        markableRidget.removeMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
    }

    public void testFiresDisabledPropertyUsingSetter() {
        if (!(this.getRidget() instanceof IBasicMarkableRidget)) {
            return;
        }
        IBasicMarkableRidget markableRidget = (IBasicMarkableRidget)this.getRidget();
        markableRidget.removePropertyChangeListener(this.propertyChangeListenerMock);
        markableRidget.addPropertyChangeListener("enabled", this.propertyChangeListenerMock);
        AbstractRidgetTestCase.assertTrue((String)("Fails for " + markableRidget), (boolean)markableRidget.isEnabled());
        this.expectNoPropertyChangeEvent();
        markableRidget.setEnabled(true);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvent("enabled", Boolean.TRUE, Boolean.FALSE);
        markableRidget.setEnabled(false);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        markableRidget.setEnabled(false);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvent("enabled", Boolean.FALSE, Boolean.TRUE);
        markableRidget.setEnabled(true);
        this.verifyPropertyChangeEvents();
    }

    public void testFiresDisabledPropertyUsingAddRemove() {
        if (!(this.getRidget() instanceof IBasicMarkableRidget)) {
            return;
        }
        IBasicMarkableRidget markableRidget = (IBasicMarkableRidget)this.getRidget();
        DisabledMarker marker = new DisabledMarker();
        markableRidget.removePropertyChangeListener(this.propertyChangeListenerMock);
        markableRidget.addPropertyChangeListener("enabled", this.propertyChangeListenerMock);
        AbstractRidgetTestCase.assertTrue((String)("Fails for " + markableRidget), (boolean)markableRidget.isEnabled());
        this.expectPropertyChangeEvent("enabled", Boolean.TRUE, Boolean.FALSE);
        markableRidget.addMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        markableRidget.addMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvent("enabled", Boolean.FALSE, Boolean.TRUE);
        markableRidget.removeMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        markableRidget.removeMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
    }

    public void testDisableWithoutUIControl() {
        if (!(this.getRidget() instanceof IBasicMarkableRidget)) {
            return;
        }
        IBasicMarkableRidget markableRidget = (IBasicMarkableRidget)this.getRidget();
        markableRidget.setUIControl(null);
        AbstractRidgetTestCase.assertTrue((String)("Fails for " + markableRidget), (boolean)markableRidget.isEnabled());
        markableRidget.setEnabled(false);
        AbstractRidgetTestCase.assertFalse((String)("Fails for " + markableRidget), (boolean)markableRidget.isEnabled());
        markableRidget.setEnabled(true);
        AbstractRidgetTestCase.assertTrue((String)("Fails for " + markableRidget), (boolean)markableRidget.isEnabled());
    }

    public void testFiresOutputPropertyUsingSetter() {
        if (!(this.getRidget() instanceof IMarkableRidget)) {
            return;
        }
        IMarkableRidget markableRidget = (IMarkableRidget)this.getRidget();
        markableRidget.removePropertyChangeListener(this.propertyChangeListenerMock);
        markableRidget.addPropertyChangeListener("output", this.propertyChangeListenerMock);
        AbstractRidgetTestCase.assertFalse((String)("Fails for " + markableRidget), (boolean)markableRidget.isOutputOnly());
        this.expectNoPropertyChangeEvent();
        markableRidget.setOutputOnly(false);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvent("output", Boolean.FALSE, Boolean.TRUE);
        markableRidget.setOutputOnly(true);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        markableRidget.setOutputOnly(true);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvent("output", Boolean.TRUE, Boolean.FALSE);
        markableRidget.setOutputOnly(false);
        this.verifyPropertyChangeEvents();
    }

    public void testFiresOutputPropertyUsingAddRemove() {
        if (!(this.getRidget() instanceof IMarkableRidget)) {
            return;
        }
        IMarkableRidget markableRidget = (IMarkableRidget)this.getRidget();
        OutputMarker marker = new OutputMarker();
        markableRidget.removePropertyChangeListener(this.propertyChangeListenerMock);
        markableRidget.addPropertyChangeListener("output", this.propertyChangeListenerMock);
        AbstractRidgetTestCase.assertFalse((String)("Fails for " + markableRidget), (boolean)markableRidget.isOutputOnly());
        this.expectPropertyChangeEvent("output", Boolean.FALSE, Boolean.TRUE);
        markableRidget.addMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        markableRidget.addMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvent("output", Boolean.TRUE, Boolean.FALSE);
        markableRidget.removeMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        markableRidget.removeMarker((IMarker)marker);
        this.verifyPropertyChangeEvents();
    }

    public void testApplyEnabledToUIControl() {
        Object aWidget = this.createWidget((Composite)this.getShell());
        if (!(aWidget instanceof Control)) {
            return;
        }
        IRidget aRidget = this.createRidget();
        Control control = (Control)aWidget;
        control.setEnabled(false);
        aRidget.setEnabled(true);
        aRidget.setUIControl((Object)control);
        AbstractRidgetTestCase.assertTrue((boolean)aRidget.isEnabled());
        AbstractRidgetTestCase.assertTrue((boolean)control.isEnabled());
        if (aRidget instanceof IBasicMarkableRidget) {
            AbstractRidgetTestCase.assertEquals((int)0, (int)((IBasicMarkableRidget)aRidget).getMarkersOfType(DisabledMarker.class).size());
        }
    }

    private PropertyChangeEvent createArgumentMatcher(PropertyChangeEvent propertyChangeEvent) {
        return PropertyChangeEventEquals.eqPropertyChangeEvent(propertyChangeEvent);
    }

    protected void assertMarkerIgnored(IMarker marker) {
        AbstractSWTWidgetRidget ridgetImpl = (AbstractSWTWidgetRidget)this.getRidget();
        Control control = (Control)this.getWidget();
        Color originalForegroundColor = control.getForeground();
        Color originalBackgroundColor = control.getBackground();
        ridgetImpl.addMarker(marker);
        AbstractRidgetTestCase.assertTrue((boolean)control.isVisible());
        AbstractRidgetTestCase.assertTrue((boolean)control.isEnabled());
        AbstractRidgetTestCase.assertEquals((Object)originalForegroundColor, (Object)control.getForeground());
        AbstractRidgetTestCase.assertEquals((Object)originalBackgroundColor, (Object)control.getBackground());
        ridgetImpl.removeMarker(marker);
        AbstractRidgetTestCase.assertTrue((boolean)control.isVisible());
        AbstractRidgetTestCase.assertTrue((boolean)control.isEnabled());
        AbstractRidgetTestCase.assertEquals((Object)originalForegroundColor, (Object)control.getForeground());
        AbstractRidgetTestCase.assertEquals((Object)originalBackgroundColor, (Object)control.getBackground());
    }

    protected boolean isWidgetControl() {
        return this.getWidget() instanceof Control;
    }
}

