/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.riena.ui.swt.AbstractStatuslineComposite;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.nls.Messages;
import org.eclipse.riena.ui.swt.uiprocess.ProcessState;
import org.eclipse.riena.ui.swt.uiprocess.ProgressInfoDataObject;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class StatuslineUIProcess
extends AbstractStatuslineComposite {
    public static final int PROGRESS_MIN_VALUE = 0;
    public static final int PROGRESS_MAX_VALUE = 100;
    private static final int PORGRESS_BAR_HEIGHT = 14;
    private ProgressBar progressBar;
    private PopupList popup;
    private Composite popupContent;
    private List<ProgressInfoDataObject> pidos = new ArrayList<ProgressInfoDataObject>();
    private final Map<ProcessState, ILabelFormatter> stateValueMappers = new HashMap<ProcessState, ILabelFormatter>();
    private final Map<Integer, ControlHolder> pido2controlHolder = new HashMap<Integer, ControlHolder>();
    private final Map<Integer, ProgressInfoDataObject> valueCache = new HashMap<Integer, ProgressInfoDataObject>();
    private Label statusLabel;
    private Label openLabel;
    private Label noProcessActiveLabel;

    public StatuslineUIProcess(Composite parent, int style) {
        super(parent, style);
        this.initStateMappers();
        this.observeMoveAndResize(parent);
    }

    private void observeMoveAndResize(Composite parent) {
        ControlAdapter listener = new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                StatuslineUIProcess.this.configureShell();
            }

            public void controlResized(ControlEvent e) {
                StatuslineUIProcess.this.configureShell();
            }
        };
        this.addControlListener((ControlListener)listener);
        parent.getShell().addControlListener((ControlListener)listener);
        Control grabCorner = this.locateGrabCorner();
        if (grabCorner != null) {
            MouseTrackAdapter trackListener = new MouseTrackAdapter(){

                public void mouseExit(MouseEvent e) {
                    super.mouseExit(e);
                    StatuslineUIProcess.this.configureShell();
                }
            };
            SWTFacade.getDefault().addMouseTrackListener(grabCorner, (MouseTrackListener)trackListener);
        }
    }

    private void configureShell() {
        if (this.popup.getShell() != null && this.popup.getShell().isVisible()) {
            this.placeShell();
        }
    }

    private Control locateGrabCorner() {
        Shell shell = this.getShell();
        Control[] controlArray = shell.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if ("grabcorner".equals(child.getData("sizeexecutor"))) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    private void initStateMappers() {
        this.stateValueMappers.put(ProcessState.PENDING, new ILabelFormatter(){

            @Override
            public String formatValue(int value) {
                return "...";
            }
        });
        this.stateValueMappers.put(ProcessState.RUNNING, new ILabelFormatter(){

            @Override
            public String formatValue(int value) {
                return String.valueOf(value) + " %";
            }
        });
        this.stateValueMappers.put(ProcessState.FINISHED, new ILabelFormatter(){

            @Override
            public String formatValue(int value) {
                return Messages.StatuslineUIProcess_finished;
            }
        });
        this.stateValueMappers.put(ProcessState.CANCELED, new ILabelFormatter(){

            @Override
            public String formatValue(int value) {
                return Messages.StatuslineUIProcess_canceled;
            }
        });
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    @Override
    protected void createContents() {
        this.initLayout();
        this.statusLabel = new Label((Composite)this, 0);
        this.statusLabel.setBackground(LnfManager.getLnf().getColor("statusline.background"));
        this.openLabel = new Label((Composite)this, 0);
        this.openLabel.setImage(LnfManager.getLnf().getImage("statusline.uiProcessIcon"));
        this.openLabel.addMouseListener((MouseListener)new PopupController());
        this.openLabel.setBackground(LnfManager.getLnf().getColor("statusline.background"));
        FormData formData = new FormData();
        formData.top = new FormAttachment(18, 0);
        formData.width = 60;
        formData.height = 14;
        this.progressBar = new ProgressBar((Composite)this, 256);
        this.progressBar.setLayoutData((Object)formData);
        this.progressBar.setBackground(LnfManager.getLnf().getColor("statusline.background"));
        formData.left = new FormAttachment((Control)this.statusLabel, 5);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setSelection(0);
        formData = new FormData();
        formData.top = new FormAttachment(18, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.width = 100;
        this.statusLabel.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(18, 0);
        formData.left = new FormAttachment((Control)this.progressBar, 5);
        formData.bottom = new FormAttachment(100, 0);
        this.openLabel.setLayoutData((Object)formData);
        this.popup = new PopupList(this.getShell());
    }

    private void openPopup() {
        this.popup.setBlockOnOpen(false);
        this.popup.open();
        this.popup.getShell().setVisible(false);
        this.triggerListUpdate(this.pidos, true);
    }

    private void closePopup() {
        this.popup.close();
        this.pido2controlHolder.clear();
        this.valueCache.clear();
    }

    private void initLayout() {
        FormLayout layout = new FormLayout();
        layout.marginRight = 5;
        this.setLayout((Layout)layout);
    }

    public void triggerBaseUpdate(ProgressInfoDataObject pido) {
        if (this.pidoComplete(pido)) {
            this.resetStatusLineProgressBar();
            return;
        }
        StatuslineUIProcess.updateProgressBar(pido, this.getProgressBar());
        this.updateLabel(pido, this.statusLabel);
    }

    private boolean pidoComplete(ProgressInfoDataObject pido) {
        return pido.getValue() >= 100 && !pido.getProcessState().equals((Object)ProcessState.PENDING) || ProcessState.CANCELED.equals((Object)pido.getProcessState()) || ProcessState.FINISHED.equals((Object)pido.getProcessState());
    }

    private void resetStatusLineProgressBar() {
        if (!this.getProgressBar().isDisposed()) {
            this.getProgressBar().setSelection(0);
            this.statusLabel.setText("");
        }
    }

    private static void updateProgressBar(ProgressInfoDataObject pido, ProgressBar progressBar) {
        if (!progressBar.isDisposed()) {
            progressBar.setMaximum(100);
            progressBar.setSelection(pido.getValue());
        }
    }

    public void triggerListUpdate(List<ProgressInfoDataObject> pidos) {
        this.triggerListUpdate(pidos, false);
    }

    public void triggerListUpdate(List<ProgressInfoDataObject> pidos, boolean forceListUpdate) {
        if (this.complete(pidos)) {
            this.resetStatusLineProgressBar();
        }
        if (!this.isDisposed() && this.isVisible()) {
            if (this.popVisible() && (forceListUpdate || !pidos.equals(this.pidos))) {
                this.createProcessList(pidos);
            }
            this.pidos = new ArrayList<ProgressInfoDataObject>();
            this.pidos.addAll(pidos);
            if (this.popVisible()) {
                this.placeShell();
                this.updateListProgressBars();
                this.popup.getShell().setVisible(true);
            }
        } else {
            this.pidos = new ArrayList<ProgressInfoDataObject>();
            this.pidos.addAll(pidos);
        }
    }

    private boolean complete(List<ProgressInfoDataObject> pidos) {
        if (pidos.size() == 0) {
            return true;
        }
        for (ProgressInfoDataObject pido : pidos) {
            if (this.pidoComplete(pido)) continue;
            return false;
        }
        return true;
    }

    private boolean popVisible() {
        Shell shell = this.popup.getShell();
        return shell != null && !shell.isDisposed();
    }

    private void placeShell() {
        this.popup.getShell().pack();
        Point point = this.toDisplay(0, 0);
        Rectangle popupBounds = this.popup.getShell().getBounds();
        this.popup.getShell().setBounds(point.x + this.getBounds().width - popupBounds.width, point.y - popupBounds.height - 4, popupBounds.width, popupBounds.height);
    }

    private void updateListProgressBars() {
        for (ProgressInfoDataObject pido : this.pidos) {
            if (!this.freshValue(pido)) continue;
            ControlHolder holder = this.pido2controlHolder.get(pido.getKey());
            if (holder != null) {
                StatuslineUIProcess.updateProgressBar(pido, holder.progressBar);
                this.updateLabel(pido, holder.label);
            }
            this.cacheValue(pido);
        }
    }

    private void updateLabel(ProgressInfoDataObject pido, Label label) {
        if (label != null && !label.isDisposed()) {
            String strV = String.valueOf(pido.getProcessName()) + " " + this.stateValueMappers.get((Object)pido.getProcessState()).formatValue(pido.getValue());
            label.setText(strV);
        }
    }

    private void cacheValue(ProgressInfoDataObject pido) {
        this.valueCache.put(pido.getKey(), pido);
    }

    private boolean freshValue(ProgressInfoDataObject pido) {
        ProgressInfoDataObject cached = this.valueCache.get(pido.getKey());
        return cached == null || cached.compareTo(pido) != 0;
    }

    private void createProcessList(List<ProgressInfoDataObject> pidos) {
        this.checkInActiveProcesses(pidos);
        ProgressBar lastControl = null;
        HashSet<Integer> keys = new HashSet<Integer>();
        for (ProgressInfoDataObject pido : pidos) {
            ControlHolder holder;
            if (this.pidoComplete(pido)) continue;
            keys.add(pido.getKey());
            if (this.noProcessActiveLabel != null) {
                if (!this.noProcessActiveLabel.isDisposed()) {
                    this.noProcessActiveLabel.setVisible(false);
                    this.noProcessActiveLabel.dispose();
                }
                this.popupContent.layout(true);
            }
            if ((holder = this.pido2controlHolder.get(pido.getKey())) == null) {
                holder = this.createControlHolder(pido);
            }
            ProgressBar bar = holder.progressBar;
            Label label = holder.label;
            Integer progressBarWidth = 60;
            FormData formData = new FormData();
            formData.top = lastControl != null ? new FormAttachment(lastControl, 2) : new FormAttachment(5, 0);
            formData.height = 14;
            formData.width = LnfManager.getLnf().getIntegerSetting("statusline.uiProcessListWidth", 160) - progressBarWidth;
            label.setLayoutData((Object)formData);
            formData = new FormData();
            formData.top = lastControl != null ? new FormAttachment(lastControl, 2) : new FormAttachment(5, 0);
            formData.left = new FormAttachment((Control)label, 3);
            formData.height = 14;
            formData.width = progressBarWidth;
            bar.setLayoutData((Object)formData);
            lastControl = bar;
        }
        this.clearZombies(keys);
        this.popupContent.layout();
        this.popupContent.redraw();
    }

    private void checkInActiveProcesses(List<ProgressInfoDataObject> pidos) {
        if (this.complete(pidos)) {
            this.cleanInactiveProcessPresentation();
        } else if (this.noProcessActiveLabel != null) {
            this.noProcessActiveLabel.dispose();
        }
    }

    private void cleanInactiveProcessPresentation() {
        FormData formData = new FormData();
        formData.top = new FormAttachment(5, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.width = LnfManager.getLnf().getIntegerSetting("statusline.uiProcessListWidth", 160);
        if (this.noProcessActiveLabel == null || this.noProcessActiveLabel.isDisposed()) {
            this.noProcessActiveLabel = new Label(this.popupContent, 0);
            this.noProcessActiveLabel.setBackground(LnfManager.getLnf().getColor("statusline.uiProcessListBackground"));
            this.noProcessActiveLabel.setText(Messages.StatuslineUIProcess_noActiveProcess);
            this.noProcessActiveLabel.setLayoutData((Object)formData);
        }
    }

    private ControlHolder createControlHolder(ProgressInfoDataObject pido) {
        ControlHolder holder = new ControlHolder();
        holder.progressBar = new ProgressBar(this.popupContent, 0);
        holder.progressBar.setBackground(LnfManager.getLnf().getColor("statusline.background"));
        holder.progressBar.setMaximum(100);
        holder.label = new Label(this.popupContent, 0);
        holder.label.setBackground(LnfManager.getLnf().getColor("statusline.uiProcessListBackground"));
        this.pido2controlHolder.put(pido.getKey(), holder);
        return holder;
    }

    private void clearZombies(Set<Integer> activeKeys) {
        Iterator<Integer> registeredKeys = this.pido2controlHolder.keySet().iterator();
        while (registeredKeys.hasNext()) {
            Integer key = registeredKeys.next();
            if (activeKeys.contains(key)) continue;
            ControlHolder holder = this.pido2controlHolder.get(key);
            holder.progressBar.dispose();
            holder.label.dispose();
            registeredKeys.remove();
            this.valueCache.remove(key);
        }
        this.popup.getShell().redraw();
    }

    private static final class ControlHolder {
        private ProgressBar progressBar;
        private Label label;

        private ControlHolder() {
        }
    }

    static interface ILabelFormatter {
        public String formatValue(int var1);
    }

    class PopupController
    extends MouseAdapter {
        PopupController() {
        }

        public void mouseDown(MouseEvent e) {
            if (StatuslineUIProcess.this.popup.getShell() == null) {
                StatuslineUIProcess.this.openPopup();
                return;
            }
            StatuslineUIProcess.this.closePopup();
        }
    }

    class PopupList
    extends ApplicationWindow {
        public PopupList(Shell parentShell) {
            super(parentShell);
        }

        protected Control createContents(Composite parent) {
            parent.setBackground(LnfManager.getLnf().getColor("statusline.uiProcessListBackground"));
            StatuslineUIProcess.this.popupContent = parent;
            FormLayout layout = new FormLayout();
            layout.marginLeft = 5;
            layout.marginRight = 5;
            layout.marginTop = 5;
            layout.marginBottom = 5;
            parent.setLayout((Layout)layout);
            return parent;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            Rectangle rect = StatuslineUIProcess.this.getBounds();
            Point display = StatuslineUIProcess.this.toDisplay(new Point(rect.x, rect.y));
            shell.setBounds(rect.x, display.y + 100, 100, 400);
        }

        protected int getShellStyle() {
            return 526344;
        }

        protected boolean showTopSeperator() {
            return false;
        }
    }
}

