/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.util.NLS;
import org.eclipse.riena.core.service.Service;
import org.eclipse.riena.core.util.VariableManagerUtil;
import org.eclipse.riena.internal.core.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;

public final class RienaStatus {
    public static final String RIENA_DEVELOPMENT_SYSTEM_PROPERTY = "riena.development";
    public static final String RIENA_TEST_SYSTEM_PROPERTY = "riena.test";
    public static final String DEVELOPMENT_DEFAULT = RienaStatus.inOsgiDevMode();
    public static final String TEST_DEFAULT = "false";
    public static final String UNKNOWN_STAGE = "<unknown>";
    private static final String BUNDLE_UNRESOLVED_EXCEPTION = "The bundle \"{0}\" could not be resolved";
    private static final String BUNDLE_UNRESOLVED_STATE_CONFLICT = "The state indicates the bundle is resolved";
    private static final String BUNDLE_UNRESOLVED_UNSATISFIED_CONSTRAINT_EXCEPTION = "The bundle \"{0}\" could not be resolved. Reason: {1}";

    private RienaStatus() {
    }

    public static boolean isActive() {
        if (Activator.getDefault() == null) {
            return false;
        }
        return Activator.getDefault().isActive();
    }

    public static boolean areStartupActionsExecuted() {
        return Activator.getDefault().areStartupActionsExecuted();
    }

    public static boolean isDevelopment() {
        return Boolean.parseBoolean(System.getProperty(RIENA_DEVELOPMENT_SYSTEM_PROPERTY, DEVELOPMENT_DEFAULT));
    }

    private static String inOsgiDevMode() {
        return Boolean.toString(System.getProperty("osgi.dev") != null);
    }

    public static boolean isTest() {
        return Boolean.parseBoolean(System.getProperty(RIENA_TEST_SYSTEM_PROPERTY, TEST_DEFAULT));
    }

    public static String getStage() {
        try {
            return VariableManagerUtil.substitute("${riena.stage}");
        }
        catch (CoreException coreException) {
            return UNKNOWN_STAGE;
        }
    }

    public static String reportUnresolvedBundles() {
        Bundle coreBundle = FrameworkUtil.getBundle(RienaStatus.class);
        if (coreBundle == null) {
            return "Could not resolve Riena core bundle.";
        }
        BundleContext bundleContext = coreBundle.getBundleContext();
        if (bundleContext == null) {
            return "Could not get Riena bundle context.";
        }
        StringBuilder bob = new StringBuilder();
        Bundle[] bundleArray = bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getState() < 4) {
                if (bob.length() == 0) {
                    bob.append("Unresolved bundles:").append("\n");
                }
                bob.append(" - ").append(bundle.getSymbolicName()).append(" is not resolved");
                try {
                    PlatformAdmin platformAdmin = Service.get(bundleContext, PlatformAdmin.class);
                    BundleException resolutionFailureException = RienaStatus.getResolutionFailureException(bundle, platformAdmin);
                    if (resolutionFailureException != null) {
                        bob.append(" because: ").append(resolutionFailureException.getMessage());
                    }
                }
                catch (Exception e) {
                    bob.append("A problem occured while trying to compute the reason. " + e.getMessage());
                }
                bob.append("\n");
            }
            ++n2;
        }
        return bob.length() == 0 ? null : bob.toString();
    }

    private static BundleException getResolutionFailureException(Bundle bundle, PlatformAdmin platformAdmin) {
        State state = platformAdmin.getState();
        BundleDescription bundleDescription = state.getBundle(bundle.getBundleId());
        if (bundleDescription == null) {
            return new BundleException(NLS.bind((String)BUNDLE_UNRESOLVED_EXCEPTION, (Object)bundle.toString()), 4);
        }
        if (bundleDescription.isResolved()) {
            return new BundleException(BUNDLE_UNRESOLVED_STATE_CONFLICT, 4);
        }
        return RienaStatus.getResolverError(bundle, bundleDescription, platformAdmin);
    }

    private static BundleException getResolverError(Bundle bundle, BundleDescription bundleDesc, PlatformAdmin platformAdmin) {
        VersionConstraint[] errors = platformAdmin.getStateHelper().getUnsatisfiedConstraints(bundleDesc);
        if (errors == null || errors.length == 0) {
            return new BundleException(NLS.bind((String)BUNDLE_UNRESOLVED_EXCEPTION, (Object)bundle.toString()), 4);
        }
        StringBuffer message = new StringBuffer();
        int errorType = 4;
        int i = 0;
        while (i < errors.length) {
            if (errors[i] instanceof NativeCodeSpecification) {
                errorType = 8;
            }
            message.append(errors[i].toString());
            if (i < errors.length - 1) {
                message.append(", ");
            }
            ++i;
        }
        return new BundleException(NLS.bind((String)BUNDLE_UNRESOLVED_UNSATISFIED_CONSTRAINT_EXCEPTION, (Object)bundle.toString(), (Object)message.toString()), errorType);
    }
}

