/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.core.uiprocess.UIProcess;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.ILabelRidget;
import org.eclipse.riena.ui.ridgets.controller.AbstractWindowController;
import org.eclipse.riena.ui.ridgets.swt.views.AbstractDialogView;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class BlockingSubModuleController
extends SubModuleController {
    public static final String RIDGET_BLOCK_MODULE = "blockModule";
    public static final String RIDGET_BLOCK_SUB_MODULE = "blockSubModule";
    public static final String RIDGET_BLOCK_SUB_APP = "blockSubApplication";
    public static final String RIDGET_BLOCK_APPLICATION = "blockApplication";
    public static final String RIDGET_BLOCK_DIALOG = "blockDialog";
    public static final String RIDGET_DISABLE_MODULE = "disableModule";
    public static final String RIDGET_STATUS = "status";
    private static final String BTN_BLOCK = "btnBlock";
    private static final String DIALOG_STATUS = "dialogStatus";
    private ILabelRidget status;

    public BlockingSubModuleController() {
    }

    public BlockingSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    public void configureRidgets() {
        super.configureRidgets();
        IActionRidget blockSubModule = (IActionRidget)this.getRidget(IActionRidget.class, RIDGET_BLOCK_SUB_MODULE);
        blockSubModule.setText("Block current SubModule = Blocking");
        blockSubModule.addListener(new IActionListener(){

            public void callback() {
                BlockingSubModuleController.this.blockNode(BlockingSubModuleController.this.getNavigationNode());
            }
        });
        IActionRidget blockModule = (IActionRidget)this.getRidget(IActionRidget.class, RIDGET_BLOCK_MODULE);
        blockModule.setText("Block current Module = Playground");
        blockModule.addListener(new IActionListener(){

            public void callback() {
                BlockingSubModuleController.this.blockNode(BlockingSubModuleController.this.getModuleNode());
            }
        });
        IActionRidget blockSubApp = (IActionRidget)this.getRidget(IActionRidget.class, RIDGET_BLOCK_SUB_APP);
        blockSubApp.setText("Block current SubApplication = Playground Tab");
        blockSubApp.addListener(new IActionListener(){

            public void callback() {
                BlockingSubModuleController.this.blockNode(BlockingSubModuleController.this.getSubApplicationNode());
            }
        });
        IActionRidget disableModule = (IActionRidget)this.getRidget(IActionRidget.class, RIDGET_DISABLE_MODULE);
        disableModule.setText("Disable current Module = Playground");
        disableModule.addListener(new IActionListener(){

            public void callback() {
                BlockingSubModuleController.this.disableNode(BlockingSubModuleController.this.getModuleNode());
            }
        });
        IActionRidget disableApplication = (IActionRidget)this.getRidget(IActionRidget.class, RIDGET_BLOCK_APPLICATION);
        disableApplication.setText("Block application");
        disableApplication.addListener(new IActionListener(){

            public void callback() {
                BlockingSubModuleController.this.blockNode(BlockingSubModuleController.this.getApplicationNode());
            }
        });
        IActionRidget disableDialog = (IActionRidget)this.getRidget(IActionRidget.class, RIDGET_BLOCK_DIALOG);
        disableDialog.setText("Block dialog");
        disableDialog.addListener(new IActionListener(){

            public void callback() {
                new MyDialogView().open();
            }
        });
        this.status = (ILabelRidget)this.getRidget(ILabelRidget.class, RIDGET_STATUS);
    }

    private void blockNode(INavigationNode<?> node) {
        BlockerUIProcess process = new BlockerUIProcess(node, this.status);
        process.setBlock(true);
        process.start();
    }

    private void disableNode(INavigationNode<?> node) {
        BlockerUIProcess process = new BlockerUIProcess(node, this.status);
        process.setDisable(true);
        process.start();
    }

    private INavigationNode<?> getModuleNode() {
        return ((ISubModuleNode)this.getNavigationNode()).getParentOfType(IModuleNode.class);
    }

    private INavigationNode<?> getSubApplicationNode() {
        return ((ISubModuleNode)this.getNavigationNode()).getParentOfType(ISubApplicationNode.class);
    }

    private INavigationNode<?> getApplicationNode() {
        return ((ISubModuleNode)this.getNavigationNode()).getParentOfType(IApplicationNode.class);
    }

    private static class BlockerUIProcess
    extends UIProcess {
        private final INavigationNode<?> node;
        private final ILabelRidget labelRidget;
        private boolean disable;
        private boolean block;
        private String subAppToolTip;

        public BlockerUIProcess(INavigationNode<?> node, ILabelRidget labelRidget) {
            super("block", false);
            this.node = node;
            this.labelRidget = labelRidget;
        }

        private ISubApplicationNode getSubApplication() {
            return this.node instanceof ISubApplicationNode ? (ISubApplicationNode)this.node : (ISubApplicationNode)this.node.getParentOfType(ISubApplicationNode.class);
        }

        public void setBlock(boolean doBlock) {
            this.block = doBlock;
        }

        public void setDisable(boolean doDisable) {
            this.disable = doDisable;
        }

        public void initialUpdateUI(int totalWork) {
            ISubApplicationNode subApplication = this.getSubApplication();
            if (subApplication != null) {
                this.subAppToolTip = subApplication.getToolTipText();
                subApplication.setToolTipText(String.format("Node '%s' is blocked", this.node.getLabel()));
            }
            this.labelRidget.setText(String.format("Changing '%s' for 10s", this.node.getLabel()));
            if (this.block) {
                this.node.setBlocked(true);
            }
            if (this.disable) {
                this.node.setEnabled(false);
            }
        }

        public void finalUpdateUI() {
            ISubApplicationNode subApplication;
            this.labelRidget.setText(String.format("Restored '%s'", this.node.getLabel()));
            if (this.block) {
                this.node.setBlocked(false);
            }
            if (this.disable) {
                this.node.setEnabled(true);
                this.node.activate();
            }
            if ((subApplication = this.getSubApplication()) != null) {
                subApplication.setToolTipText(this.subAppToolTip);
            }
        }

        public boolean runJob(IProgressMonitor monitor) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            return true;
        }
    }

    private static class DialogBlockingProcess
    extends UIProcess {
        private final MyDialogController dialogController;

        public DialogBlockingProcess(MyDialogController dialogController) {
            super("Blocking Dialog");
            this.dialogController = dialogController;
        }

        public void initialUpdateUI(int totalWork) {
            ((ILabelRidget)this.dialogController.getRidget(ILabelRidget.class, BlockingSubModuleController.DIALOG_STATUS)).setText("Blocking for 10s, dialog is not closeable");
            this.dialogController.setBlocked(true);
        }

        public void finalUpdateUI() {
            this.dialogController.setBlocked(false);
            ((ILabelRidget)this.dialogController.getRidget(ILabelRidget.class, BlockingSubModuleController.DIALOG_STATUS)).setText("Unblocked, dialog can be closed");
        }

        public boolean runJob(IProgressMonitor monitor) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            return true;
        }
    }

    private static class MyDialogController
    extends AbstractWindowController {
        private MyDialogController() {
        }

        public void configureRidgets() {
            super.configureRidgets();
            ((IActionRidget)this.getRidget(IActionRidget.class, BlockingSubModuleController.BTN_BLOCK)).addListener(new IActionListener(){

                public void callback() {
                    new DialogBlockingProcess(MyDialogController.this).start();
                }
            });
        }
    }

    private static class MyDialogView
    extends AbstractDialogView {
        protected MyDialogView() {
            super(null);
        }

        protected Control buildView(Composite parent) {
            parent.setLayout((Layout)new FillLayout());
            Composite c = UIControlsFactory.createComposite((Composite)parent);
            UIControlsFactory.createLabel((Composite)c, (String)"Click on the button to block the dialog for 10s", (String)BlockingSubModuleController.DIALOG_STATUS);
            UIControlsFactory.createButton((Composite)c, (String)"Block", (String)BlockingSubModuleController.BTN_BLOCK);
            c.setLayout((Layout)new GridLayout());
            return c;
        }

        protected AbstractWindowController createController() {
            return new MyDialogController();
        }
    }
}

