/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.riena.beans.common.StringBean;
import org.eclipse.riena.internal.example.client.beans.Extra;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.IDecimalTextRidget;
import org.eclipse.riena.ui.ridgets.ISingleChoiceRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.listener.SelectionEvent;
import org.eclipse.riena.ui.ridgets.swt.NumberColumnFormatter;

public class CheckBoxTableSubModuleController
extends SubModuleController {
    private final StringBean choiceSelection = new StringBean("free");
    private double totalPrice;
    private ISingleChoiceRidget choice;
    private ITableRidget table;
    private IDecimalTextRidget total;
    private List<Extra> input;

    public void configureRidgets() {
        super.configureRidgets();
        this.choice = (ISingleChoiceRidget)this.getRidget(ISingleChoiceRidget.class, "choice");
        List<String> labels = Arrays.asList("Free Choice", "Standard (output-only)", "No Extras (disabled)");
        List<String> options = Arrays.asList("free", "standard", "no");
        this.choice.bindToModel(options, labels, (Object)this.choiceSelection, "value");
        this.choice.updateFromModel();
        this.table = (ITableRidget)this.getRidget(ITableRidget.class, "table");
        String[] columnPropertyNames = new String[]{"selected", "name", "category", "price"};
        this.input = this.createInput();
        this.table.setNativeToolTip(false);
        WritableList extrasList = new WritableList(this.input, Extra.class);
        this.table.bindToModel((IObservableList)extrasList, Extra.class, columnPropertyNames, null);
        this.table.updateFromModel();
        this.table.setSortedColumn(-1);
        this.table.setColumnFormatter(3, (IColumnFormatter)new NumberColumnFormatter(Double.class, 2){

            protected Number getValue(Object element) {
                return ((Extra)((Object)element)).getPrice();
            }
        });
        for (Extra extra : this.input) {
            extra.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("selected")) {
                        CheckBoxTableSubModuleController.this.updateTotal();
                    }
                }
            });
        }
        this.total = (IDecimalTextRidget)this.getRidget(IDecimalTextRidget.class, "total");
        this.total.setPrecision(2);
        this.total.bindToModel((Object)this, "totalPrice");
        this.total.setOutputOnly(true);
        this.choice.addSelectionListener(new ISelectionListener(){

            public void ridgetSelected(SelectionEvent event) {
                CheckBoxTableSubModuleController.this.updateTableMarker();
            }
        });
        this.table.addSelectionListener(new ISelectionListener(){

            public void ridgetSelected(SelectionEvent event) {
                if (event.getNewSelection() != null) {
                    System.out.println(event.getNewSelection());
                } else {
                    System.out.println("no selection");
                }
            }
        });
        this.updateTableMarker();
        this.updateTotal();
    }

    private void updateTotal() {
        double price = 0.0;
        for (Extra extra : this.input) {
            if (!extra.isSelected()) continue;
            price += extra.getPrice();
        }
        this.setTotalPrice(price);
        this.total.updateFromModel();
    }

    private void updateTableMarker() {
        if (this.choiceSelection.getValue().equals("standard")) {
            this.table.setEnabled(true);
            this.table.setOutputOnly(true);
            for (Extra extra : this.input) {
                extra.setDefault();
            }
        } else if (this.choiceSelection.getValue().equals("no")) {
            this.table.setEnabled(false);
            this.table.setOutputOnly(false);
            for (Extra extra : this.input) {
                extra.setSelected(false);
            }
        } else {
            this.table.setEnabled(true);
            this.table.setOutputOnly(false);
            for (Extra extra : this.input) {
                extra.setDefault();
            }
        }
    }

    private List<Extra> createInput() {
        ArrayList<Extra> extras = new ArrayList<Extra>();
        extras.add(new Extra("Manual Transmission", Extra.Category.PERFORMANCE, 0.0, true));
        extras.add(new Extra("Variable sport steering", Extra.Category.PERFORMANCE, 0.0, false));
        extras.add(new Extra("Sport automatic transmission with shift paddles", Extra.Category.PERFORMANCE, 500.0, false));
        extras.add(new Extra("Split fold-down-rear seat", Extra.Category.CONVENIENCE, 475.0, true));
        extras.add(new Extra("Heated Steering Wheel", Extra.Category.CONVENIENCE, 190.0, false));
        extras.add(new Extra("Power front seats with driver seat memory", Extra.Category.CONVENIENCE, 995.0, false));
        extras.add(new Extra("Heated front seats", Extra.Category.CONVENIENCE, 500.0, true));
        extras.add(new Extra("Parking Assistant", Extra.Category.CONVENIENCE, 500.0, false));
        extras.add(new Extra("Rear manual side window shades", Extra.Category.CONVENIENCE, 575.0, false));
        extras.add(new Extra("Satellite radio", Extra.Category.ENTERTAINMENT, 350.0, false));
        extras.add(new Extra("Navigation system", Extra.Category.ENTERTAINMENT, 1150.0, true));
        extras.add(new Extra("Surround sound system", Extra.Category.ENTERTAINMENT, 850.0, false));
        extras.add(new Extra("Park Distance Control", Extra.Category.SAFETY, 750.0, true));
        extras.add(new Extra("Anti-theft alarm system", Extra.Category.SAFETY, 400.0, false));
        extras.add(new Extra("Rear-view camera", Extra.Category.SAFETY, 400.0, false));
        extras.add(new Extra("Speed Limit Info", Extra.Category.SAFETY, 100.0, false));
        extras.add(new Extra("Xenon headlights", Extra.Category.SAFETY, 900.0, true));
        extras.add(new Extra("Active Blind Spot Detection", Extra.Category.SAFETY, 300.0, false));
        return extras;
    }

    public double getTotalPrice() {
        return this.totalPrice;
    }

    public void setTotalPrice(double totalPrice) {
        this.totalPrice = totalPrice;
    }
}

