/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.StringMatcher;
import org.eclipse.riena.navigation.INavigationNode;

public final class NavigationNodeUtility {
    private NavigationNodeUtility() {
    }

    public static String getNodeLongId(INavigationNode<?> node) {
        StringBuilder builder = new StringBuilder();
        NavigationNodeUtility.addToNodeLongId(builder, node);
        return builder.toString();
    }

    private static void addToNodeLongId(StringBuilder builder, INavigationNode<?> node) {
        if (node != null) {
            String id;
            if (node.getNodeId() != null && (id = node.getNodeId().getTypeId()) != null) {
                builder.insert(0, id);
            }
            builder.insert(0, "/");
            NavigationNodeUtility.addToNodeLongId(builder, node.getParent());
        }
    }

    public static List<INavigationNode<?>> findNode(String id, INavigationNode<?> node) {
        return NavigationNodeUtility.findNode(id, node, new IIdClosure(){

            @Override
            public String getId(INavigationNode<?> node) {
                if (node.getNodeId() == null) {
                    return null;
                }
                return node.getNodeId().getTypeId();
            }
        });
    }

    public static List<INavigationNode<?>> findNodesByLongId(String id, INavigationNode<?> node) {
        ArrayList result = new ArrayList();
        NavigationNodeUtility.findNodesByLongId(id, node, result);
        return result;
    }

    public static void findNodesByLongId(String id, INavigationNode<?> node, List<INavigationNode<?>> result) {
        NavigationNodeUtility.findNode(id, node, new IIdClosure(){

            @Override
            public String getId(INavigationNode<?> node) {
                String nodeLongId = NavigationNodeUtility.getNodeLongId(node);
                return nodeLongId;
            }
        }, result);
    }

    private static void findNode(String id, INavigationNode<?> node, IIdClosure closure, List<INavigationNode<?>> collector) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull(node);
        StringMatcher matcher = new StringMatcher(id);
        String nodeId = closure.getId(node);
        if (matcher.match(nodeId)) {
            collector.add(node);
        }
        List<?> children = node.getChildren();
        for (Object child : children) {
            if (!(child instanceof INavigationNode)) continue;
            NavigationNodeUtility.findNode(id, (INavigationNode)child, closure, collector);
        }
    }

    private static List<INavigationNode<?>> findNode(String id, INavigationNode<?> node, IIdClosure closure) {
        ArrayList result = new ArrayList();
        NavigationNodeUtility.findNode(id, node, closure, result);
        return result;
    }

    private static interface IIdClosure {
        public String getId(INavigationNode<?> var1);
    }
}

