/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.core.util.Millis;

@NonUITestCase
public class MillisTest
extends RienaTestCase {
    public void testSeconds() {
        MillisTest.assertEquals((long)1000L, (long)Millis.seconds((int)1));
    }

    public void testMinutes() {
        MillisTest.assertEquals((long)60000L, (long)Millis.minutes((int)1));
    }

    public void testHours() {
        MillisTest.assertEquals((long)3600000L, (long)Millis.hours((int)1));
    }

    public void testDays() {
        MillisTest.assertEquals((long)86400000L, (long)Millis.days((int)1));
    }

    public void testNullString() {
        try {
            Millis.valueOf(null);
            MillisTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
    }

    public void testEmptyMillis() {
        MillisTest.assertEquals((long)0L, (long)Millis.valueOf((String)""));
    }

    public void testStringMillis() {
        MillisTest.assertEquals((long)1234L, (long)Millis.valueOf((String)"1234 ms"));
    }

    public void testStringMillisMillis() {
        MillisTest.assertEquals((long)110L, (long)Millis.valueOf((String)"80 ms 30 ms"));
    }

    public void testStringSeconds() {
        MillisTest.assertEquals((long)3000L, (long)Millis.valueOf((String)"3 s"));
    }

    public void testStringMillisSecondsMillis() {
        MillisTest.assertEquals((long)1110L, (long)Millis.valueOf((String)"80 ms 1 s 30 ms"));
    }

    public void testStringMinutes() {
        MillisTest.assertEquals((long)240000L, (long)Millis.valueOf((String)"4 m"));
    }

    public void testStringHours() {
        MillisTest.assertEquals((long)0x6DDD00L, (long)Millis.valueOf((String)"2 h"));
    }

    public void testStringDays() {
        MillisTest.assertEquals((long)604800000L, (long)Millis.valueOf((String)"7 d"));
    }

    public void testStringWeeks() {
        MillisTest.assertEquals((long)1209600000L, (long)Millis.valueOf((String)"2 w"));
    }

    public void testStringMonths() {
        MillisTest.assertEquals((long)7257600000L, (long)Millis.valueOf((String)"3 M"));
    }

    public void testStringMixed() {
        long expected = 604800000L;
        expected += 0x6DDD00L;
        expected += 240000L;
        expected += 3000L;
        MillisTest.assertEquals((long)(expected += 1234L), (long)Millis.valueOf((String)"7 d 2 h 4 m 3 s 1234 ms"));
    }
}

