/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.ui.swt.utils.TestUtils;
import org.eclipse.riena.ui.ridgets.validation.ValidRange;

@NonUITestCase
public class ValidRangeTest
extends RienaTestCase {
    protected ValidRange createRange() {
        return new ValidRange();
    }

    protected ValidRange createRange(Number min, Number max) {
        return new ValidRange(min, max);
    }

    protected ValidRange createRange(Number min, Number max, Locale locale) {
        return new ValidRange(min, max, locale);
    }

    public void testValueWithLessPrecisionThanMinimumFloat() throws Exception {
        ValidRange v = this.createRange(Float.valueOf(3.51f), Float.valueOf(999.99f), Locale.US);
        ValidRangeTest.assertFalse((boolean)v.validate((Object)"3.5").isOK());
        ValidRangeTest.assertFalse((boolean)v.validate((Object)"3.50").isOK());
        ValidRangeTest.assertTrue((boolean)v.validate((Object)"3.51").isOK());
    }

    public void testValueWithLessPrecisionThanMinimumDouble() throws Exception {
        ValidRange v = this.createRange(3.51, 999.99, Locale.US);
        ValidRangeTest.assertFalse((boolean)v.validate((Object)"3.5").isOK());
        ValidRangeTest.assertFalse((boolean)v.validate((Object)"3.50").isOK());
        ValidRangeTest.assertTrue((boolean)v.validate((Object)"3.51").isOK());
    }

    public void testGrouping() throws Exception {
        ValidRange rule = this.createRange(1000.0, 1.0E7);
        ValidRangeTest.assertEquals((String)"Value '10.000.000,01' out of range: [1.000..10.000.000].", (String)rule.validate((Object)"10.000.000,01").getMessage());
        rule.setGroupingInMessage(false);
        ValidRangeTest.assertEquals((String)"Value '10000000,01' out of range: [1000..10000000].", (String)rule.validate((Object)"10000000,01").getMessage());
    }

    public void testRangeUSlocale() {
        ValidRange rule = this.createRange(0, 10, Locale.US);
        ValidRangeTest.assertTrue((boolean)rule.validate(null).isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"0").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"2.5").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"5").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"-0.0000001").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"10.0000001").isOK());
        rule = this.createRange(-5000, 5000, Locale.US);
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"-5000").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"-5,000").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"- 5,000").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"-5000.0001").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"-5,000.0001").isOK());
    }

    public void testEmptyValuesUSLocale() {
        ValidRange rule = this.createRange(10, 20, Locale.US);
        ValidRangeTest.assertFalse((boolean)rule.validate(null).isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"").isOK());
    }

    public void testRangeGermanLocale() {
        ValidRange rule = this.createRange(0, 10, Locale.GERMANY);
        ValidRangeTest.assertTrue((boolean)rule.validate(null).isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"0").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"2,5").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"5").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"-0,0000001").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"10,0000001").isOK());
        rule = this.createRange(-5000, 5000, Locale.GERMANY);
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"-5000").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"-5.000").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"- 5.000").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"-5000,0001").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"-5.000,0001").isOK());
    }

    public void testEmptyValuesGermanLocale() {
        ValidRange rule = this.createRange(10, 20, Locale.GERMANY);
        ValidRangeTest.assertFalse((boolean)rule.validate(null).isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"").isOK());
    }

    public void testRangeArabLocale() {
        if (!TestUtils.isArabLocaleAvailable()) {
            System.err.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".testRangeArabLocale(): Skipping test because no Arab locale is available. Use international JRE to run all tests.");
            return;
        }
        ValidRange rule = this.createRange(0, 10, new Locale("ar", "AE"));
        ValidRangeTest.assertTrue((boolean)rule.validate(null).isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"0").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"2.5").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"5").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"0.0000001-").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"10.0000001").isOK());
        rule = this.createRange(-5000, 5000, new Locale("ar", "AE"));
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"5000-").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"5,000-").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"5,000 -").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"5000.0001-").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"5,000.0001 -").isOK());
    }

    public void testEmptyValuesArabLocale() {
        ValidRange rule = this.createRange(10, 20, new Locale("ar", "AE"));
        ValidRangeTest.assertFalse((boolean)rule.validate(null).isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"").isOK());
    }

    public void testConstructorInitTypes() {
        ValidRange rule = this.createRange((byte)-10, (byte)10);
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
        rule = this.createRange((short)-10, (short)10);
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
        rule = this.createRange(-10L, 10L);
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
        rule = this.createRange(Float.valueOf(-10.0f), Float.valueOf(10.0f));
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
        rule = this.createRange(-10.0, 10.0);
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
        rule = this.createRange(BigInteger.ZERO, BigInteger.TEN);
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
        rule = this.createRange(BigDecimal.ZERO, BigDecimal.TEN);
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
    }

    public void testUnparseableNumbers() {
        ValidRange rule = this.createRange(0, 10, Locale.US);
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"A10").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"1A0").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"10A").isOK());
    }

    public void testConstructorSanity() throws Exception {
        try {
            this.createRange((byte)10, (short)10);
            ValidRangeTest.fail((String)"expected some RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            this.ok("passed test");
        }
        try {
            this.createRange(10, 1000.0);
            ValidRangeTest.fail((String)"expected some RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            this.ok("passed test");
        }
        try {
            this.createRange(100, 10);
            ValidRangeTest.fail((String)"expected some RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            this.ok("passed test");
        }
        try {
            this.createRange(null, 10);
            ValidRangeTest.fail((String)"expected some RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            this.ok("passed test");
        }
        try {
            this.createRange(100, null);
            ValidRangeTest.fail((String)"expected some RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            this.ok("passed test");
        }
        try {
            this.createRange(null, null);
            ValidRangeTest.fail((String)"expected some RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            this.ok("passed test");
        }
        try {
            this.createRange(10, 100, null);
            ValidRangeTest.fail((String)"expected some RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            this.ok("passed test");
        }
    }

    public void testSetInitializationData() throws Exception {
        ValidRange rule = this.createRange();
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"0").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"10").isOK());
        rule = this.createRange();
        rule.setInitializationData(null, null, (Object)"1");
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"1").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"10").isOK());
        rule = this.createRange();
        rule.setInitializationData(null, null, (Object)"1,10");
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"1").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"0").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"11").isOK());
        rule = this.createRange();
        rule.setInitializationData(null, null, (Object)"1.1,10.1");
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"1").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"2").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"0").isOK());
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"11").isOK());
        rule = this.createRange();
        String localString = String.valueOf(Locale.US.getLanguage()) + "," + Locale.US.getCountry();
        rule.setInitializationData(null, null, (Object)("1.1,10.1," + localString));
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"1").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"1.1").isOK());
        rule = this.createRange();
        localString = String.valueOf(Locale.GERMANY.getLanguage()) + "," + Locale.GERMANY.getCountry();
        rule.setInitializationData(null, null, (Object)("1.1,10.1," + localString));
        ValidRangeTest.assertFalse((boolean)rule.validate((Object)"1").isOK());
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)"1,1").isOK());
    }

    public void testDoubleValuesWithMinMaxEqual() {
        Double min = 5000.0;
        Double max = 5000.0;
        ValidRange rule = this.createRange(min, max);
        String value = "5000";
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)value).isOK());
        min = 5000.5;
        max = 5000.5;
        rule = this.createRange(min, max);
        value = TestUtils.getLocalizedNumber("5000,5");
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)value).isOK());
        min = 5000.55;
        max = 5000.55;
        rule = this.createRange(min, max);
        value = TestUtils.getLocalizedNumber("5000,55");
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)value).isOK());
    }

    public void testDoubleValuesWithNegativeNumbers() {
        Double min = -5000.0;
        Double max = -5000.0;
        ValidRange rule = this.createRange(min, max);
        String value = TestUtils.getLocalizedNumber("-5000");
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)value).isOK());
    }

    public void testDoubleValuesWithMinMaxEqualThreeDecimalPlaces() {
        Double min = 5000.555;
        Double max = 5000.555;
        ValidRange rule = new ValidRange((Number)min, (Number)max, Locale.getDefault(), null, 3, 15);
        String value = TestUtils.getLocalizedNumber("5000,555");
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)value).isOK());
    }

    public void testFloatValuesWithMinMaxEqualThreeDecimalPlaces() {
        ValidRange rule = new ValidRange((Number)Float.valueOf(5000.555f), (Number)Float.valueOf(5000.555f), Locale.getDefault(), null, 3, 15);
        String value = TestUtils.getLocalizedNumber("5000,555");
        ValidRangeTest.assertTrue((boolean)rule.validate((Object)value).isOK());
    }

    public void testDefaultErrorMessageConversionDouble() {
        ValidRange rule = this.createRange(1000.0, 1.0E7);
        IStatus validate = rule.validate((Object)"10.000.000,01");
        ValidRangeTest.assertFalse((boolean)validate.isOK());
        ValidRangeTest.assertEquals((String)"Value '10.000.000,01' out of range: [1.000..10.000.000].", (String)validate.getMessage());
    }

    public void testDefaultErrorMessageConversionInteger() {
        ValidRange rule = this.createRange(1000, 10000000);
        IStatus validate = rule.validate((Object)"10.000.000,01");
        ValidRangeTest.assertFalse((boolean)validate.isOK());
        ValidRangeTest.assertEquals((String)"Value '10.000.000,01' out of range: [1.000..10.000.000].", (String)validate.getMessage());
    }

    public void testCustomErrorMessageConversionInteger() {
        ValidRange rule = new ValidRange((Number)1, (Number)10, new IConverter(){

            public final Object convert(Object fromObject) {
                return fromObject.toString();
            }

            public Object getFromType() {
                return Integer.class;
            }

            public Object getToType() {
                return String.class;
            }
        });
        IStatus validate = rule.validate((Object)"11");
        ValidRangeTest.assertFalse((boolean)validate.isOK());
        ValidRangeTest.assertEquals((String)"Value '11' out of range: [1..10].", (String)validate.getMessage());
    }
}

