/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import junit.framework.TestCase;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.ui.swt.StatuslineTime;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class StatuslineTimeTest
extends TestCase {
    private Shell shell;
    private StatuslineTime statusTime;

    protected void setUp() throws Exception {
        this.shell = new Shell();
        this.statusTime = new StatuslineTime((Composite)this.shell, 0);
    }

    protected void tearDown() throws Exception {
        SwtUtilities.dispose((Widget)this.shell);
        SwtUtilities.dispose((Widget)this.statusTime);
    }

    public void testCreateContents() {
        Control[] controls = this.statusTime.getChildren();
        StatuslineTimeTest.assertEquals((int)1, (int)controls.length);
        StatuslineTimeTest.assertTrue((boolean)(controls[0] instanceof CLabel));
    }

    public void testUpdateTime() throws ParseException {
        Date dateBeforeUpdate = new Date();
        Calendar cal1 = GregorianCalendar.getInstance();
        cal1.setTime(dateBeforeUpdate);
        cal1.set(0, 0, 0);
        cal1.set(13, 0);
        ReflectionUtils.invokeHidden((Object)this.statusTime, (String)"updateTime", (Object[])new Object[0]);
        Control[] controls = this.statusTime.getChildren();
        CLabel label = (CLabel)controls[0];
        String timeString = label.getText();
        SimpleDateFormat format = (SimpleDateFormat)ReflectionUtils.invokeHidden((Object)this.statusTime, (String)"getFormat", (Object[])new Object[0]);
        Date labelDate = format.parse(timeString);
        Calendar cal2 = GregorianCalendar.getInstance();
        cal2.setTime(labelDate);
        cal2.set(0, 0, 0);
        long diff = cal1.getTimeInMillis() - cal2.getTimeInMillis();
        StatuslineTimeTest.assertTrue((diff >= 0L ? 1 : 0) != 0);
        StatuslineTimeTest.assertTrue((diff < 1000L ? 1 : 0) != 0);
    }
}

