/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import junit.framework.TestCase;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class SwtUtilitiesTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cacheDpiFactors", (Object)new float[]{0.0f, 0.0f});
    }

    protected void tearDown() throws Exception {
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cacheDpiFactors", (Object)new float[]{0.0f, 0.0f});
        super.tearDown();
    }

    public void testIsDisposedWidget() {
        Shell shell = new Shell();
        Label label = new Label((Composite)shell, 0);
        SwtUtilitiesTest.assertFalse((boolean)SwtUtilities.isDisposed((Widget)label));
        label.dispose();
        SwtUtilitiesTest.assertTrue((boolean)SwtUtilities.isDisposed((Widget)label));
        label = null;
        SwtUtilitiesTest.assertTrue((boolean)SwtUtilities.isDisposed((Widget)label));
        shell.dispose();
        SwtUtilitiesTest.assertTrue((boolean)SwtUtilities.isDisposed((Widget)shell));
        shell = null;
        SwtUtilitiesTest.assertTrue((boolean)SwtUtilities.isDisposed((Widget)shell));
    }

    public void testIsDisposedResource() {
        Color color = new Color((Device)Display.getCurrent(), 0, 0, 0);
        SwtUtilitiesTest.assertFalse((boolean)SwtUtilities.isDisposed((Resource)color));
        color.dispose();
        SwtUtilitiesTest.assertTrue((boolean)SwtUtilities.isDisposed((Resource)color));
        color = null;
        SwtUtilitiesTest.assertTrue((boolean)SwtUtilities.isDisposed((Resource)color));
    }

    public void testGetDpiFactors() throws Exception {
        float[] defaultFactors = SwtUtilities.getDpiFactors();
        SwtUtilitiesTest.assertEquals((int)2, (int)defaultFactors.length);
        MyLnf lnf = new MyLnf();
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        float[] factors = SwtUtilities.getDpiFactors();
        SwtUtilitiesTest.assertEquals((int)2, (int)factors.length);
        SwtUtilitiesTest.assertEquals((Object)Float.valueOf(defaultFactors[0]), (Object)Float.valueOf(factors[0]));
        SwtUtilitiesTest.assertEquals((Object)Float.valueOf(defaultFactors[1]), (Object)Float.valueOf(factors[1]));
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cacheDpiFactors", (Object)new float[]{0.0f, 0.0f});
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        factors = SwtUtilities.getDpiFactors();
        SwtUtilitiesTest.assertEquals((int)2, (int)factors.length);
        float[] lnfFactors = lnf.getDpiFactors(new Point(0, 0));
        SwtUtilitiesTest.assertEquals((Object)Float.valueOf(lnfFactors[0]), (Object)Float.valueOf(factors[0]));
        SwtUtilitiesTest.assertEquals((Object)Float.valueOf(lnfFactors[1]), (Object)Float.valueOf(factors[1]));
    }

    public void testConvertXToDpi() throws Exception {
        MyLnf lnf = new MyLnf();
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        int x = SwtUtilities.convertXToDpi((int)2);
        int expectedValue = 40;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)x);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cacheDpiFactors", (Object)new float[]{1.2f, 1.3f});
        x = SwtUtilities.convertXToDpi((int)2);
        expectedValue = 2;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)x);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cacheDpiFactors", (Object)new float[]{1.9f, 1.0f});
        x = SwtUtilities.convertXToDpi((int)2);
        expectedValue = 4;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)x);
    }

    public void testConvertYToDpi() throws Exception {
        MyLnf lnf = new MyLnf();
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        int y = SwtUtilities.convertYToDpi((int)2);
        int expectedValue = 6;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)y);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cacheDpiFactors", (Object)new float[]{1.2f, 2.4f});
        y = SwtUtilities.convertYToDpi((int)2);
        expectedValue = 5;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)y);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cacheDpiFactors", (Object)new float[]{1.9f, 4.4f});
        y = SwtUtilities.convertYToDpi((int)2);
        expectedValue = 9;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)y);
        ReflectionUtils.setHidden(SwtUtilities.class, (String)"cacheDpiFactors", (Object)new float[]{1.9f, 4.8f});
        y = SwtUtilities.convertYToDpi((int)2);
        expectedValue = 10;
        SwtUtilitiesTest.assertEquals((int)expectedValue, (int)y);
    }

    private static class MyLnf
    extends RienaDefaultLnf {
        private MyLnf() {
        }

        public float[] getDpiFactors(Point dpi) {
            return new float[]{20.0f, 3.0f};
        }
    }
}

