/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.lnf.renderer;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.ui.swt.lnf.AbstractLnfRenderer;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.ShellHelper;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractTitleBarRenderer
extends AbstractLnfRenderer {
    private static final int DEFAULT_HEIGHT = 26;
    protected static final int TOP_BUTTON_GAP = 2;
    private static final int BUTTON_RIGHT_GAP = 2;
    private static final int BUTTON_BUTTON_GAP = 2;
    protected static final int BTN_COUNT = 3;
    protected static final int CLOSE_BTN_INDEX = 0;
    protected static final int MAX_BTN_INDEX = 1;
    protected static final int MIN_BTN_INDEX = 2;
    protected static final int RESTORE_BTN_INDEX = 3;
    private boolean closeable;
    private boolean maximizable;
    private boolean minimizable;
    private final boolean[] pressed = new boolean[3];
    private final boolean[] hover = new boolean[3];
    private boolean active;
    private boolean maximized;
    private Rectangle imageBounds;
    private Rectangle textBounds;
    private final Rectangle[] btnBounds = new Rectangle[3];
    private Shell shell;

    public AbstractTitleBarRenderer() {
        this.resetBounds();
    }

    private void resetBounds() {
        int i = 0;
        while (i < this.btnBounds.length) {
            this.btnBounds[i] = new Rectangle(0, 0, 0, 0);
            ++i;
        }
        this.imageBounds = new Rectangle(0, 0, 0, 0);
        this.textBounds = new Rectangle(0, 0, 0, 0);
    }

    public void setShell(Shell shell) {
        Assert.isNotNull((Object)shell);
        this.shell = shell;
    }

    protected Shell getShell() {
        return this.shell;
    }

    @Override
    public void paint(GC gc, Object value) {
        if (this.shell == null) {
            this.shell = Display.getDefault().getActiveShell();
        }
        this.setActive(true);
        this.setMaximized(ShellHelper.isMaximzed(this.shell));
        this.resetBounds();
        this.paintBackground(gc);
        this.imageBounds = this.paintImage(gc);
        int i = 0;
        while (i < 3) {
            this.paintButton(gc, i);
            ++i;
        }
        this.textBounds = this.paintTitle(gc);
    }

    protected abstract void paintBackground(GC var1);

    protected abstract Rectangle paintTitle(GC var1);

    protected abstract Rectangle paintImage(GC var1);

    protected void paintButton(GC gc, int btnIndex) {
        Image image = null;
        if (this.getBtnShow()[btnIndex]) {
            int index = btnIndex;
            if (index == 1 && this.isMaximized()) {
                index = 3;
            }
            image = this.isActive() ? (this.isPressed(btnIndex) ? LnfManager.getLnf().getImage(this.getBtnHoverSelectedImageKeys()[index]) : (this.isHover(btnIndex) ? LnfManager.getLnf().getImage(this.getBtnHoverImageKeys()[index]) : LnfManager.getLnf().getImage(this.getBtnImageKeys()[index]))) : LnfManager.getLnf().getImage(this.getBtnInactiveImageKeys()[index]);
        }
        int x = this.getBounds().x + this.getBounds().width - 2;
        if (btnIndex > 0) {
            x = this.btnBounds[btnIndex - 1].x;
            if (this.btnBounds[btnIndex - 1].width > 0) {
                x -= 2;
            }
        }
        int y = 0;
        if (image != null) {
            Rectangle imgBounds = image.getBounds();
            y = this.getBounds().height / 2 - imgBounds.height / 2;
            gc.drawImage(image, x -= imgBounds.width, y -= 2);
            this.btnBounds[btnIndex].width = imgBounds.width;
            this.btnBounds[btnIndex].height = imgBounds.height;
        }
        this.btnBounds[btnIndex].x = x;
        this.btnBounds[btnIndex].y = y;
    }

    @Override
    public void dispose() {
    }

    protected boolean isPressed(int btnIndex) {
        return this.pressed[btnIndex];
    }

    protected void setPressed(int btnIndex, boolean pressed) {
        this.pressed[btnIndex] = pressed;
    }

    protected boolean isHover(int btnIndex) {
        return this.hover[btnIndex];
    }

    protected void setHover(int btnIndex, boolean hover) {
        this.hover[btnIndex] = hover;
    }

    protected boolean isActive() {
        return this.active;
    }

    protected void setActive(boolean active) {
        this.active = active;
    }

    protected boolean isMaximized() {
        return this.maximized;
    }

    protected void setMaximized(boolean maximized) {
        this.maximized = maximized;
    }

    public boolean isInsideCloseButton(Point pt) {
        return this.isInsideButton(pt, 0);
    }

    public boolean isInsideMinimizeButton(Point pt) {
        return this.isInsideButton(pt, 2);
    }

    public boolean isInsideMaximizeButton(Point pt) {
        return this.isInsideButton(pt, 1);
    }

    private boolean isInsideButton(Point pt, int btnIndex) {
        return this.btnBounds[btnIndex].contains(pt);
    }

    public boolean isInsideMoveArea(Point pt) {
        boolean result = false;
        Rectangle bounds = this.getBounds();
        if (bounds != null) {
            Rectangle moveArea = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
            int minX = bounds.x + bounds.width;
            int maxHeight = this.textBounds.y + this.textBounds.height;
            Rectangle[] rectangleArray = this.btnBounds;
            int n = this.btnBounds.length;
            int n2 = 0;
            while (n2 < n) {
                Rectangle btnBound = rectangleArray[n2];
                minX = Math.min(minX, btnBound.x);
                maxHeight = Math.max(maxHeight, btnBound.y + btnBound.height);
                ++n2;
            }
            int width = minX - bounds.x;
            if (width < 0) {
                width = 0;
            }
            moveArea.width = width;
            moveArea.height = maxHeight;
            result = moveArea.contains(pt);
        }
        return result;
    }

    public Rectangle getAllButtonsBounds() {
        Rectangle bounds = new Rectangle(this.btnBounds[0].x, this.btnBounds[0].y, this.btnBounds[0].width, this.btnBounds[0].height);
        int i = 1;
        while (i < this.btnBounds.length) {
            bounds.add(this.btnBounds[i]);
            ++i;
        }
        return bounds;
    }

    protected Rectangle getImageBounds() {
        return this.imageBounds;
    }

    protected Rectangle[] getButtonsBounds() {
        return this.btnBounds;
    }

    public boolean isCloseButtonPressed() {
        return this.isPressed(0);
    }

    public void setCloseButtonPressed(boolean pressed) {
        this.setPressed(0, pressed);
    }

    public boolean isCloseButtonHover() {
        return this.isHover(0);
    }

    public void setCloseButtonHover(boolean hover) {
        this.setHover(0, hover);
    }

    public boolean isMaximizedButtonPressed() {
        return this.isPressed(1);
    }

    public void setMaximizedButtonPressed(boolean pressed) {
        this.setPressed(1, pressed);
    }

    public boolean isMaximizedButtonHover() {
        return this.isHover(1);
    }

    public void setMaximizedButtonHover(boolean hover) {
        this.setHover(1, hover);
    }

    public boolean isMinimizedButtonPressed() {
        return this.isPressed(2);
    }

    public void setMinimizedButtonPressed(boolean pressed) {
        this.setPressed(2, pressed);
    }

    public boolean isMinimizedButtonHover() {
        return this.isHover(2);
    }

    public void setMinimizedButtonHover(boolean hover) {
        this.setHover(2, hover);
    }

    protected abstract String[] getBtnImageKeys();

    protected abstract String[] getBtnHoverSelectedImageKeys();

    protected abstract String[] getBtnHoverImageKeys();

    protected abstract String[] getBtnInactiveImageKeys();

    private boolean[] getBtnShow() {
        boolean[] btnShow = new boolean[]{this.isCloseable(), this.isMaximizable(), this.isMinimizable()};
        return btnShow;
    }

    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setMaximizable(boolean maximizable) {
        this.maximizable = maximizable;
    }

    public boolean isMaximizable() {
        return this.maximizable;
    }

    public void setMinimizable(boolean minimizable) {
        this.minimizable = minimizable;
    }

    public boolean isMinimizable() {
        return this.minimizable;
    }

    public int getHeight() {
        int height = 0;
        if (this.getBounds() != null) {
            height = this.getBounds().height;
        }
        if (height <= 0) {
            height = 26;
        }
        return height;
    }
}

