/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.uiprocess;

import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.window.Window;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.ui.swt.uiprocess.ICancelListener;
import org.eclipse.riena.ui.swt.uiprocess.IProcessWindowListener;
import org.eclipse.riena.ui.swt.uiprocess.IProgressControl;
import org.eclipse.riena.ui.swt.uiprocess.UIProcessWindow;
import org.eclipse.riena.ui.swt.utils.IPropertyNameProvider;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class UIProcessControl
implements IProgressControl,
IPropertyNameProvider {
    private static final Logger logger = Log4r.getLogger(UIProcessControl.class);
    private static final int UPDATE_DELAY = 200;
    private boolean processing;
    private UIProcessWindow processWindow;
    private final ListenerList<ICancelListener> cancelListeners = new ListenerList(ICancelListener.class);
    private ProcessUpdateThread processUpdateThread;
    private String name;
    private Rectangle initBounds;

    public UIProcessControl(Shell parentShell) {
        Assert.isNotNull((Object)parentShell);
        this.createProcessWindow(parentShell);
    }

    private void createProcessWindow(Shell parentShell) {
        this.processWindow = new UIProcessWindow(parentShell, this);
        this.processWindow.addProcessWindowListener(new IProcessWindowListener(){

            @Override
            public void windowAboutToClose() {
                UIProcessControl.this.stopProcessing();
                UIProcessControl.this.fireCanceled(true);
            }
        });
    }

    public Window getWindow() {
        return this.processWindow;
    }

    private void showWindow() {
        this.processWindow.openWindow();
    }

    @Override
    public void stop() {
        this.closeWindow();
    }

    private void closeWindow() {
        this.stopProcessing();
        this.processWindow.closeWindow();
    }

    protected synchronized boolean isProcessing() {
        return this.processing;
    }

    public synchronized void setProcessing(boolean processing) {
        this.processing = processing;
    }

    @Override
    public void showProcessing() {
        this.startProcessing();
    }

    private void startProcessing() {
        if (!this.isProcessing()) {
            this.setProcessing(true);
            if (this.getProgressBar() != null && !this.getProgressBar().isDisposed()) {
                this.getProgressBar().setMaximum(100);
            }
            if (this.getPercentControl() != null && !this.getPercentControl().isDisposed()) {
                this.getPercentControl().setText("");
            }
            if (this.processUpdateThread == null || !this.processUpdateThread.isAlive()) {
                this.startUpdateThread();
            }
        }
    }

    private void startUpdateThread() {
        this.processUpdateThread = new ProcessUpdateThread();
        this.processUpdateThread.start();
    }

    private void processUpdateLoop() {
        final int[] selection = new int[1];
        while (this.isProcessing()) {
            selection[0] = selection[0] <= 100 ? selection[0] + 10 : 0;
            if (this.getProgressBar() != null && !this.getProgressBar().isDisposed()) {
                this.getProgressBar().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!UIProcessControl.this.getProgressBar().isDisposed() && UIProcessControl.this.isProcessing()) {
                            UIProcessControl.this.getProgressBar().setSelection(selection[0]);
                        }
                    }
                });
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                logger.log(1, e.getMessage(), (Throwable)e);
            }
        }
    }

    private ProgressBar getProgressBar() {
        return this.processWindow.getProgressBar();
    }

    @Override
    public void showProgress(int value, int maxValue) {
        if (maxValue <= 0) {
            return;
        }
        this.stopProcessing();
        int percentValue = this.calcSelection(value, maxValue);
        if (this.getWindow().getShell() != null && !this.getWindow().getShell().isDisposed()) {
            this.getPercentControl().setText(String.valueOf(String.valueOf(percentValue)) + " %");
            this.getProgressBar().setSelection(percentValue);
        }
    }

    private Label getPercentControl() {
        return this.processWindow.getPercent();
    }

    private int calcSelection(int value, int maxValue) {
        double v = (double)value / (double)maxValue * 100.0;
        return (int)v;
    }

    private void stopProcessing() {
        this.setProcessing(false);
    }

    @Override
    public void start() {
        this.showWindow();
    }

    @Override
    public void setDescription(String text) {
        this.processWindow.setDescription(text);
    }

    public String getDescription() {
        String text = this.processWindow.getDescription().getText();
        if (text == null) {
            return "";
        }
        return text;
    }

    @Override
    public void setTitle(String text) {
        Shell shell = this.processWindow.getShell();
        if (!StringUtils.equals((CharSequence)text, (CharSequence)shell.getText())) {
            shell.setText(text);
            Rectangle bounds = shell.getBounds();
            shell.redraw(0, 0, bounds.width, bounds.height, true);
        }
    }

    @Override
    public void addCancelListener(ICancelListener listener) {
        this.cancelListeners.add((Object)listener);
    }

    @Override
    public void removeCancelListener(ICancelListener listener) {
        this.cancelListeners.remove((Object)listener);
    }

    protected void fireCanceled(boolean windowClosing) {
        ICancelListener[] iCancelListenerArray = (ICancelListener[])this.cancelListeners.getListeners();
        int n = iCancelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICancelListener listener = iCancelListenerArray[n2];
            listener.canceled(windowClosing);
            ++n2;
        }
    }

    @Override
    public String getPropertyName() {
        return this.name;
    }

    @Override
    public void setPropertyName(String propertyName) {
        this.name = propertyName;
    }

    public void setCancelVisible(boolean cancelVisible) {
        this.processWindow.setCancelVisible(cancelVisible);
    }

    public void setCancelEnabled(boolean cancelEnabled) {
        this.processWindow.setCancelEnabled(cancelEnabled);
    }

    public void pack() {
        if (this.initBounds == null) {
            Shell shell = this.getWindow().getShell();
            shell.pack();
            Rectangle bounds = shell.getBounds();
            Rectangle constrainedShellBounds = this.getConstrainedShellBounds(bounds);
            if (!bounds.equals((Object)constrainedShellBounds)) {
                shell.setBounds(constrainedShellBounds);
                shell.layout();
            }
            this.initBounds = shell.getBounds();
        }
    }

    protected Rectangle getConstrainedShellBounds(Rectangle preferredSize) {
        Rectangle result = new Rectangle(preferredSize.x, preferredSize.y, preferredSize.width, preferredSize.height);
        Shell shell = this.getWindow().getShell();
        Rectangle bounds = shell.getMonitor().getClientArea();
        bounds.x += 10;
        bounds.y += 10;
        bounds.height -= 20;
        bounds.width -= 20;
        if (result.height > bounds.height) {
            result.height = bounds.height;
        }
        if (result.width > bounds.width) {
            result.width = bounds.width;
        }
        result.x = Math.max(bounds.x, Math.min(result.x, bounds.x + bounds.width - result.width));
        result.y = Math.max(bounds.y, Math.min(result.y, bounds.y + bounds.height - result.height));
        return result;
    }

    private final class ProcessUpdateThread
    extends Thread {
        private ProcessUpdateThread() {
        }

        @Override
        public void run() {
            this.setPriority(10);
            this.setName("ProcessUpdateThread");
            UIProcessControl.this.processUpdateLoop();
        }
    }
}

