/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.cache.LRUHashMap;
import org.eclipse.riena.ui.swt.facades.GCFacade;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public final class SwtUtilities {
    private static final String THREE_DOTS = "...";
    private static final Map<GCString, Integer> TEXT_WIDTH_CACHE = LRUHashMap.createLRUHashMap((int)2048);
    private static final Map<GCChar, Integer> CHAR_WIDTH_CACHE = LRUHashMap.createLRUHashMap((int)1024);
    private static final float DEFAULT_DPI_X = 96.0f;
    private static final float DEFAULT_DPI_Y = 96.0f;
    private static float[] cacheDpiFactors = new float[]{0.0f, 0.0f};

    private SwtUtilities() {
        throw new Error("SwtUtilities is just a container for static methods");
    }

    public static String clipText(GC gc, String text, int maxWidth) {
        int textwidth = SwtUtilities.calcTextWidth(gc, text);
        if (textwidth <= maxWidth) {
            return text;
        }
        int threeDotsWidth = SwtUtilities.calcTextWidth(gc, THREE_DOTS);
        StringBuilder shortenedText = new StringBuilder(text);
        while (textwidth + threeDotsWidth > maxWidth && shortenedText.length() != 0) {
            shortenedText.setLength(shortenedText.length() - 1);
            textwidth = SwtUtilities.calcTextWidth(gc, shortenedText);
        }
        shortenedText.append(THREE_DOTS);
        return shortenedText.toString();
    }

    public static int calcTextWidth(GC gc, CharSequence text) {
        if (text == null) {
            return 0;
        }
        GCString lookupKey = new GCString(gc, text);
        Integer width = TEXT_WIDTH_CACHE.get(lookupKey);
        if (width == null) {
            int w = 0;
            int i = 0;
            while (i < text.length()) {
                w += SwtUtilities.calcCharWidth(gc, text.charAt(i));
                ++i;
            }
            width = w;
            TEXT_WIDTH_CACHE.put(lookupKey, width);
        }
        return width;
    }

    public static int calcCharWidth(GC gc, char ch) {
        GCChar lookupKey = new GCChar(gc, ch);
        Integer width = CHAR_WIDTH_CACHE.get(lookupKey);
        if (width == null) {
            width = GCFacade.getDefault().getAdvanceWidth(gc, ch);
            CHAR_WIDTH_CACHE.put(lookupKey, width);
        }
        return width;
    }

    public static void dispose(Resource resource) {
        if (!SwtUtilities.isDisposed(resource)) {
            resource.dispose();
        }
    }

    public static void dispose(Widget widget) {
        if (!SwtUtilities.isDisposed(widget)) {
            widget.dispose();
        }
    }

    public static int findColumn(Tree tree, Point pt) {
        int width = 0;
        int[] colOrder = tree.getColumnOrder();
        TreeColumn[] columns = new TreeColumn[colOrder.length];
        int i = 0;
        while (i < colOrder.length) {
            int idx = colOrder[i];
            columns[i] = tree.getColumn(idx);
            ++i;
        }
        TreeColumn[] treeColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn col = treeColumnArray[n2];
            int colWidth = col.getWidth();
            if (width < pt.x && pt.x < width + colWidth) {
                return tree.indexOf(col);
            }
            width += colWidth;
            ++n2;
        }
        return -1;
    }

    public static int findColumn(Table table, Point pt) {
        int width = 0;
        int[] colOrder = table.getColumnOrder();
        TableColumn[] columns = new TableColumn[colOrder.length];
        int i = 0;
        while (i < colOrder.length) {
            int idx = colOrder[i];
            columns[i] = table.getColumn(idx);
            ++i;
        }
        TableColumn[] tableColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            int colWidth = col.getWidth();
            if (width < pt.x && pt.x < width + colWidth) {
                return table.indexOf(col);
            }
            width += colWidth;
            ++n2;
        }
        return -1;
    }

    public static boolean hasStyle(Widget widget, int styleBit) {
        return widget == null ? false : (widget.getStyle() & styleBit) == styleBit;
    }

    public static boolean isDisposed(Widget widget) {
        return widget == null || widget.isDisposed();
    }

    public static boolean isDisposed(Resource resource) {
        return resource == null || resource.isDisposed();
    }

    public static Point getDpi() {
        return SwtUtilities.getDpi(null);
    }

    public static Point getDpi(Widget widget) {
        Display display = null;
        if (widget != null) {
            display = widget.getDisplay();
        }
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        Assert.isNotNull((Object)display, (String)"No display exits");
        return display.getDPI();
    }

    public static float[] getDpiFactors() {
        return SwtUtilities.getDpiFactors(null);
    }

    public static float[] getDpiFactors(Widget widget) {
        Point dpi;
        if (cacheDpiFactors[0] <= 0.001f || cacheDpiFactors[1] <= 0.001f) {
            dpi = SwtUtilities.getDpi(widget);
            float[] lnfDpiFactors = LnfManager.getLnf().getDpiFactors(dpi);
            if (lnfDpiFactors.length == 2) {
                SwtUtilities.cacheDpiFactors[0] = lnfDpiFactors[0];
                SwtUtilities.cacheDpiFactors[1] = lnfDpiFactors[1];
            }
        }
        if (cacheDpiFactors[0] <= 0.001f || cacheDpiFactors[1] <= 0.001f) {
            dpi = SwtUtilities.getDpi(widget);
            SwtUtilities.cacheDpiFactors[0] = (float)dpi.x / 96.0f;
            SwtUtilities.cacheDpiFactors[1] = (float)dpi.y / 96.0f;
        }
        return cacheDpiFactors;
    }

    public static int convertXToDpi(int x) {
        float factorX = SwtUtilities.getDpiFactors()[0];
        return SwtUtilities.convertPixelToDpi(x, factorX);
    }

    public static int convertYToDpi(int y) {
        float factorY = SwtUtilities.getDpiFactors()[1];
        return SwtUtilities.convertPixelToDpi(y, factorY);
    }

    private static int convertPixelToDpi(int px, float factor) {
        if (px < 0) {
            return -((int)((double)((float)(-px) * factor) + 0.5));
        }
        return (int)((double)((float)px * factor) + 0.5);
    }

    public static Color makeBrighter(Color color, float f) {
        Assert.isNotNull((Object)color);
        Assert.isTrue(((double)f >= 0.0 ? 1 : 0) != 0);
        float[] hsb = color.getRGB().getHSB();
        float h = hsb[0];
        float s = hsb[1];
        float b = hsb[2];
        b *= f;
        if (b > 1.0f) {
            b = 1.0f;
        }
        RGB rgb = new RGB(h, s, b);
        return new Color(color.getDevice(), rgb);
    }

    private static final class GCChar {
        private final char ch;
        private final Font font;

        private GCChar(GC gc, char ch) {
            this.font = gc.getFont();
            this.ch = ch;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.ch;
            result = 31 * result + (this.font == null ? 0 : this.font.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            GCChar other = (GCChar)obj;
            if (this.ch != other.ch) {
                return false;
            }
            return !(this.font == null ? other.font != null : !this.font.equals((Object)other.font));
        }
    }

    private static final class GCString {
        private final String text;
        private final Font font;

        private GCString(GC gc, CharSequence seq) {
            this.font = gc.getFont();
            this.text = seq.toString();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.font == null ? 0 : this.font.hashCode());
            result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            GCString other = (GCString)obj;
            if (this.font == null ? other.font != null : !this.font.equals((Object)other.font)) {
                return false;
            }
            return !(this.text == null ? other.text != null : !this.text.equals(other.text));
        }
    }
}

