/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.core;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.riena.communication.core.IRemoteServiceRegistry;
import org.eclipse.riena.communication.core.hooks.ICallHook;
import org.eclipse.riena.communication.core.progressmonitor.IRemoteProgressMonitorRegistry;
import org.eclipse.riena.communication.core.progressmonitor.ProgressMonitorRegistryImpl;
import org.eclipse.riena.core.RienaActivator;
import org.eclipse.riena.core.RienaConstants;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.communication.core.factory.OrderedCallHooksExecuter;
import org.eclipse.riena.internal.communication.core.proxyselector.ProxySelectorConfiguration;
import org.eclipse.riena.internal.communication.core.registry.RemoteServiceRegistry;
import org.eclipse.riena.internal.communication.core.ssl.SSLConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
extends RienaActivator {
    public static final String PLUGIN_ID = "org.eclipse.riena.communication.core";
    private RemoteServiceRegistry serviceRegistry;
    private ServiceRegistration regServiceRegistry;
    private SSLConfiguration sslConfiguration;
    private ProxySelectorConfiguration proxySelectorConfiguration;
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.serviceRegistry = new RemoteServiceRegistry();
        this.serviceRegistry.start();
        Hashtable properties = RienaConstants.newDefaultServiceProperties();
        this.regServiceRegistry = context.registerService(IRemoteServiceRegistry.class.getName(), (Object)this.serviceRegistry, (Dictionary)properties);
        this.configureSSL();
        this.configureProxySelector();
        this.configureOrderedCallHooks();
        context.registerService(IRemoteProgressMonitorRegistry.class.getName(), (Object)new ProgressMonitorRegistryImpl(), null);
    }

    private void configureOrderedCallHooks() {
        OrderedCallHooksExecuter hook = new OrderedCallHooksExecuter();
        Wire.instance((Object)hook).andStart(this.getContext());
        this.getContext().registerService(ICallHook.class.getName(), (Object)hook, null);
    }

    private void configureSSL() {
        this.sslConfiguration = new SSLConfiguration();
        Wire.instance((Object)this.sslConfiguration).andStart(this.getContext());
    }

    private void configureProxySelector() {
        this.proxySelectorConfiguration = new ProxySelectorConfiguration();
        Wire.instance((Object)this.proxySelectorConfiguration).andStart(this.getContext());
    }

    public void stop(BundleContext context) throws Exception {
        this.regServiceRegistry.unregister();
        this.regServiceRegistry = null;
        this.serviceRegistry.stop();
        this.serviceRegistry = null;
        this.proxySelectorConfiguration.uninstall();
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }
}

