/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.exceptionhandler;

import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.exception.IExceptionHandler;
import org.eclipse.riena.ui.ridgets.IMessageBoxRidget;
import org.eclipse.riena.ui.ridgets.swt.SwtRidgetFactory;
import org.eclipse.riena.ui.swt.MessageBox;
import org.eclipse.riena.ui.swt.uiprocess.SwtUISynchronizer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ExceptionMessageBox
implements IExceptionHandler {
    private static final SwtUISynchronizer uiSynchronizer = new SwtUISynchronizer();

    public IExceptionHandler.Action handleException(final Throwable t, String msg, Logger logger) {
        final Wrapper resultWrapper = new Wrapper();
        uiSynchronizer.syncExec(new Runnable(){

            @Override
            public void run() {
                resultWrapper.action = ExceptionMessageBox.this.showMessageBox(t);
            }
        });
        return resultWrapper.action;
    }

    private IExceptionHandler.Action showMessageBox(Throwable t) {
        Display display = uiSynchronizer.getDisplay();
        MessageBox messageBox = new MessageBox((Composite)display.getActiveShell());
        IMessageBoxRidget messageBoxRidget = (IMessageBoxRidget)SwtRidgetFactory.createRidget((Object)messageBox);
        messageBoxRidget.setTitle("Exception at Runtime");
        messageBoxRidget.setType(IMessageBoxRidget.Type.ERROR);
        if (t != null) {
            messageBoxRidget.setText(t.getMessage() != null ? t.getMessage() : t.toString());
        }
        IMessageBoxRidget.MessageBoxOption ok = new IMessageBoxRidget.MessageBoxOption("OK");
        IMessageBoxRidget.MessageBoxOption ignore = new IMessageBoxRidget.MessageBoxOption("Ignore");
        IMessageBoxRidget.MessageBoxOption printstack = new IMessageBoxRidget.MessageBoxOption("Print stacktrace and OK");
        messageBoxRidget.setOptions(new IMessageBoxRidget.MessageBoxOption[]{ok, ignore, printstack});
        IMessageBoxRidget.MessageBoxOption show = messageBoxRidget.show();
        if (t != null && show.equals(printstack)) {
            t.printStackTrace();
        }
        if (show.equals(ignore)) {
            return IExceptionHandler.Action.NOT_HANDLED;
        }
        return IExceptionHandler.Action.OK;
    }

    public IExceptionHandler.Action handleUncaught(Throwable t, String msg, Logger logger) {
        return IExceptionHandler.Action.NOT_HANDLED;
    }

    private static class Wrapper {
        IExceptionHandler.Action action;

        private Wrapper() {
        }
    }
}

