/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.example.client.beans;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.beans.common.AbstractBean;

public class Extra
extends AbstractBean {
    public static final String PROPERTY_SELECTED = "selected";
    private boolean selected;
    private final boolean defaultSelected;
    private final String name;
    private final Category category;
    private final double price;

    public Extra(String name, Category category, double price, boolean selected) {
        this.name = name;
        this.category = category;
        this.price = price;
        this.selected = selected;
        this.defaultSelected = selected;
    }

    public void setDefault() {
        this.setSelected(this.defaultSelected);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        boolean oldSelected = this.selected;
        this.selected = selected;
        this.firePropertyChanged(PROPERTY_SELECTED, oldSelected, selected);
    }

    public String getName() {
        return this.name;
    }

    public Category getCategory() {
        return this.category;
    }

    public double getPrice() {
        return this.price;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(" ");
        sb.append("Category: ");
        sb.append((Object)this.getCategory());
        sb.append(", ");
        sb.append("Price (\u20ac): ");
        sb.append(", ");
        sb.append(this.getPrice());
        sb.append(", ");
        sb.append("selected: ");
        sb.append(this.isSelected());
        return sb.toString();
    }

    public static enum Category {
        PERFORMANCE("Performance"),
        CONVENIENCE("Convenience"),
        ENTERTAINMENT("Entertainment"),
        SAFETY("Safety");

        private String label;

        private Category(String label) {
            Assert.isNotNull((Object)label);
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

