/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.navigation.ui.swt;

import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public final class CoolbarUtils {
    public static CoolItem initCoolBar(CoolBar coolBar, Font font) {
        if (coolBar.getItemCount() == 0) {
            CoolItem coolItem = new CoolItem(coolBar, 4);
            ToolBar toolBar = new ToolBar((Composite)coolBar, 0x800000);
            toolBar.setFont(font);
            coolItem.setControl((Control)toolBar);
            coolItem.setSize(new Point(0, 1));
        } else {
            CoolItem[] items;
            CoolItem[] coolItemArray = items = coolBar.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                CoolItem coolItem = coolItemArray[n2];
                Control ciControl = coolItem.getControl();
                if (CoolbarUtils.updateFont(ciControl, font)) {
                    CoolbarUtils.updateToolbarSize(coolItem);
                }
                ++n2;
            }
        }
        coolBar.setBackground(CoolbarUtils.getCoolbarBackground());
        coolBar.setBackgroundMode(2);
        coolBar.setLocked(true);
        return coolBar.getItem(0);
    }

    private static Color getCoolbarBackground() {
        return LnfManager.getLnf().getColor("Coolbar.background");
    }

    private static boolean updateFont(Control control, Font newFont) {
        Font oldFont;
        boolean result = false;
        if (control != null && (newFont != (oldFont = control.getFont()) || newFont != null && !newFont.equals((Object)oldFont))) {
            control.setFont(newFont);
            result = true;
        }
        return result;
    }

    private static void updateToolbarSize(CoolItem coolItem) {
        Control control = coolItem.getControl();
        if (control instanceof ToolBar) {
            ToolBar toolBar = (ToolBar)control;
            ToolItem[] toolItemArray = toolBar.getItems();
            int n = toolItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ToolItem item = toolItemArray[n2];
                String text = item.getText();
                item.setText("");
                item.setText(text);
                ++n2;
            }
            toolBar.pack();
            Point newSize = toolBar.computeSize(-1, -1);
            Point preferredSize = coolItem.computeSize(newSize.x, newSize.y);
            coolItem.setPreferredSize(preferredSize);
            coolItem.setMinimumSize(newSize);
            coolItem.setSize(preferredSize);
        }
    }

    private CoolbarUtils() {
    }
}

