/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.application;

import org.eclipse.riena.core.exception.ExceptionFailure;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class LoginNonActivityTimer
implements Runnable {
    private final Display display;
    private final int nonActivityDuration;
    private EventListener eventListener;
    private final ILoginExecutor loginExecutor;

    public LoginNonActivityTimer(Display display, ILoginExecutor loginExecutor, int nonActivityDuration) {
        this.display = display;
        this.loginExecutor = loginExecutor;
        this.nonActivityDuration = nonActivityDuration;
        this.initializeEventListener();
    }

    private void initializeEventListener() {
        this.eventListener = new EventListener();
        this.display.addFilter(1, (Listener)this.eventListener);
        this.display.addFilter(2, (Listener)this.eventListener);
        this.display.addFilter(8, (Listener)this.eventListener);
        this.display.addFilter(3, (Listener)this.eventListener);
        this.display.addFilter(4, (Listener)this.eventListener);
        this.display.addFilter(31, (Listener)this.eventListener);
        SWTFacade facade = SWTFacade.getDefault();
        facade.addFilterMouseExit(this.display, (Listener)this.eventListener);
        facade.addFilterMouseMove(this.display, (Listener)this.eventListener);
        facade.addFilterMouseWheel(this.display, (Listener)this.eventListener);
    }

    @Override
    public void run() {
        try {
            if (!this.eventListener.activity) {
                this.loginExecutor.prePerformLogin();
                this.loginExecutor.postPerformLogin(this.loginExecutor.performLogin());
            }
            this.schedule();
        }
        catch (Exception e) {
            throw new ExceptionFailure(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void schedule() {
        this.initializeForSchedule();
        this.display.timerExec(this.getTimerDelay(), (Runnable)this);
    }

    private int getTimerDelay() {
        return this.nonActivityDuration - (int)(System.currentTimeMillis() - this.eventListener.activityTime);
    }

    private void initializeForSchedule() {
        if (this.eventListener.activityTime == -1L) {
            this.eventListener.activityTime = System.currentTimeMillis();
        }
        this.eventListener.activity = false;
    }

    private static final class EventListener
    implements Listener {
        private boolean activity = false;
        private long activityTime = -1L;

        private EventListener() {
        }

        public void handleEvent(Event event) {
            this.activity = true;
            this.activityTime = System.currentTimeMillis();
        }
    }

    public static interface ILoginExecutor<LOGIN_RESULT> {
        public void prePerformLogin() throws Exception;

        public LOGIN_RESULT performLogin();

        public void postPerformLogin(LOGIN_RESULT var1) throws Exception;

        public int getNonActivityDuration();
    }
}

