/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.common;

import java.security.Principal;
import java.util.Iterator;
import javax.security.auth.Subject;
import org.eclipse.riena.communication.core.hooks.CallContext;
import org.eclipse.riena.communication.core.hooks.ICallHook;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.core.util.Base64;
import org.eclipse.riena.internal.security.common.Activator;
import org.eclipse.riena.security.common.ISubjectHolder;

public class BasicAuthenticationCallHook
implements ICallHook {
    private ISubjectHolder subjectHolder = null;

    public BasicAuthenticationCallHook() {
        Inject.service(ISubjectHolder.class).useRanking().into((Object)this).andStart(Activator.getDefault().getContext());
    }

    public void bind(ISubjectHolder subjectHolderService) {
        this.subjectHolder = subjectHolderService;
    }

    public void unbind(ISubjectHolder subjectHolderService) {
        this.subjectHolder = null;
    }

    public void afterCall(CallContext context) {
    }

    public void beforeCall(CallContext context) {
        if (this.subjectHolder == null) {
            return;
        }
        Subject subject = this.subjectHolder.getSubject();
        if (subject == null) {
            return;
        }
        Object credential = null;
        Iterator<Object> iterator = subject.getPrivateCredentials().iterator();
        if (iterator.hasNext()) {
            credential = iterator.next();
        }
        String password = credential instanceof String ? (String)credential : "";
        for (Principal principal : subject.getPrincipals()) {
            String useridPlusPassword = String.valueOf(principal.getName()) + ":" + password;
            String authorizationInBase64 = new String(Base64.encode((byte[])useridPlusPassword.getBytes()));
            context.getMessageContext().addRequestHeader("Authorization", "Basic " + authorizationInBase64);
        }
    }
}

