/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.navigation.ui.filter;

import junit.framework.TestCase;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.navigation.ui.filter.AbstractUIFilterRuleNavigationMarker;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.NavigationProcessor;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;

@NonUITestCase
public class AbstractUIFilterRuleNavigationMarkerTest
extends TestCase {
    public void testMatches() {
        SubModuleNode node = new SubModuleNode();
        node.setNodeId(new NavigationNodeId("id"));
        MyUIFilterRuleNavigationMarker attribute = new MyUIFilterRuleNavigationMarker("*/" + node.getNodeId().getTypeId(), null);
        AbstractUIFilterRuleNavigationMarkerTest.assertFalse((boolean)attribute.matches(null));
        AbstractUIFilterRuleNavigationMarkerTest.assertFalse((boolean)attribute.matches(new Object[]{new Object()}));
        SubModuleNode sm = new SubModuleNode();
        sm.setNodeId(new NavigationNodeId("id2"));
        AbstractUIFilterRuleNavigationMarkerTest.assertFalse((boolean)attribute.matches(new Object[]{sm}));
        AbstractUIFilterRuleNavigationMarkerTest.assertTrue((boolean)attribute.matches(new Object[]{node}));
    }

    public void testApply() {
        SubModuleNode node = new SubModuleNode();
        node.setNodeId(new NavigationNodeId("id"));
        node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        AbstractUIFilterRuleNavigationMarkerTest.assertTrue((boolean)node.isVisible());
        MyUIFilterRuleNavigationMarker attribute = new MyUIFilterRuleNavigationMarker(node.getNodeId().getTypeId(), (IMarker)new HiddenMarker());
        attribute.apply(node);
        AbstractUIFilterRuleNavigationMarkerTest.assertFalse((boolean)node.isVisible());
    }

    public void testRemove() {
        SubModuleNode node = new SubModuleNode();
        node.setNodeId(new NavigationNodeId("id"));
        node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        AbstractUIFilterRuleNavigationMarkerTest.assertTrue((boolean)node.isEnabled());
        MyUIFilterRuleNavigationMarker attribute = new MyUIFilterRuleNavigationMarker(node.getNodeId().getTypeId(), (IMarker)new DisabledMarker());
        attribute.apply(node);
        AbstractUIFilterRuleNavigationMarkerTest.assertFalse((boolean)node.isEnabled());
        attribute.remove(node);
        AbstractUIFilterRuleNavigationMarkerTest.assertTrue((boolean)node.isEnabled());
    }

    private static class MyUIFilterRuleNavigationMarker
    extends AbstractUIFilterRuleNavigationMarker {
        public MyUIFilterRuleNavigationMarker(String nodeId, IMarker marker) {
            super(nodeId, marker);
        }
    }
}

