/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractTraverseRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.SpinnerRidget;
import org.eclipse.riena.ui.ridgets.ISpinnerRidget;
import org.eclipse.riena.ui.ridgets.ITraverseRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public class SpinnerRidgetTest
extends AbstractTraverseRidgetTest {
    @Override
    protected Widget createWidget(Composite parent) {
        return new Spinner(parent, 0);
    }

    protected ISpinnerRidget createRidget() {
        return new SpinnerRidget();
    }

    protected Spinner getWidget() {
        return (Spinner)super.getWidget();
    }

    protected ISpinnerRidget getRidget() {
        return (ISpinnerRidget)super.getRidget();
    }

    @Override
    protected int getIncrement(Control control) {
        return ((Spinner)control).getIncrement();
    }

    @Override
    protected int getMaximum(Control control) {
        return ((Spinner)control).getMaximum();
    }

    @Override
    protected int getMinimum(Control control) {
        return ((Spinner)control).getMinimum();
    }

    @Override
    protected int getPageIncrement(Control control) {
        return ((Spinner)control).getPageIncrement();
    }

    @Override
    protected int getValue(Control control) {
        return ((Spinner)control).getSelection();
    }

    @Override
    protected void setValue(Control control, int value) {
        ((Spinner)control).setSelection(value);
    }

    protected int getTextLimit(Control control) {
        return ((Spinner)control).getTextLimit();
    }

    protected int getDigits(Control control) {
        return ((Spinner)control).getDigits();
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        SpinnerRidgetTest.assertSame(SpinnerRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testSetDigits() {
        ISpinnerRidget ridget = this.getRidget();
        Spinner control = this.getWidget();
        SpinnerRidgetTest.assertEquals((int)0, (int)ridget.getDigits());
        SpinnerRidgetTest.assertEquals((int)0, (int)control.getDigits());
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        ridget.setTextLimit(4);
        ridget.setDigits(2);
        SpinnerRidgetTest.assertEquals((int)2, (int)ridget.getDigits());
        SpinnerRidgetTest.assertEquals((int)2, (int)control.getDigits());
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        try {
            ridget.setTextLimit(4);
            ridget.setDigits(5);
            SpinnerRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        SpinnerRidgetTest.assertEquals((int)2, (int)ridget.getDigits());
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        ridget.setTextLimit(4);
        ridget.setDigits(3);
        ridget.setTextLimit(2);
        SpinnerRidgetTest.assertEquals((int)2, (int)ridget.getDigits());
        SpinnerRidgetTest.assertEquals((int)2, (int)control.getDigits());
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        ridget.setDigits(0);
        SpinnerRidgetTest.assertEquals((int)0, (int)ridget.getDigits());
        SpinnerRidgetTest.assertEquals((int)0, (int)control.getDigits());
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        ridget.setDigits(-1);
        SpinnerRidgetTest.assertEquals((int)0, (int)ridget.getDigits());
        SpinnerRidgetTest.assertEquals((int)0, (int)control.getDigits());
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
    }

    public void testSetDigitsFiresEvents() {
        ISpinnerRidget ridget = this.getRidget();
        ridget.setTextLimit(5);
        ridget.setDigits(1);
        this.expectPropertyChangeEvent("digits", 1, 3);
        ridget.setDigits(3);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setDigits(3);
        this.verifyPropertyChangeEvents();
        try {
            this.resetEasyMock();
            this.expectNoPropertyChangeEvent();
            ridget.setDigits(ridget.getTextLimit() + 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.verifyPropertyChangeEvents();
        }
        this.resetEasyMock();
        ridget.setDigits(1);
        this.expectPropertyChangeEvent("digits", 1, 0);
        ridget.setDigits(-1);
        this.verifyPropertyChangeEvents();
        this.resetEasyMock();
        ridget.setDigits(1);
        this.expectPropertyChangeEvent("digits", 1, 0);
        ridget.setDigits(0);
        this.verifyPropertyChangeEvents();
    }

    public void testSetTextLimit() {
        ISpinnerRidget ridget = this.getRidget();
        Spinner control = this.getWidget();
        ridget.setTextLimit(9);
        SpinnerRidgetTest.assertEquals((int)9, (int)ridget.getTextLimit());
        SpinnerRidgetTest.assertEquals((int)9, (int)control.getTextLimit());
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        ridget.setTextLimit(SpinnerRidget.LIMIT);
        SpinnerRidgetTest.assertEquals((int)SpinnerRidget.LIMIT, (int)ridget.getTextLimit());
        SpinnerRidgetTest.assertEquals((int)SpinnerRidget.LIMIT, (int)control.getTextLimit());
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        ridget.setTextLimit(SpinnerRidget.LIMIT + 1);
        SpinnerRidgetTest.assertEquals((int)SpinnerRidget.LIMIT, (int)ridget.getTextLimit());
        SpinnerRidgetTest.assertEquals((int)SpinnerRidget.LIMIT, (int)control.getTextLimit());
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        ridget.setTextLimit(9);
        try {
            ridget.setTextLimit(-1);
            SpinnerRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        SpinnerRidgetTest.assertEquals((int)9, (int)ridget.getTextLimit());
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        try {
            ridget.setTextLimit(0);
            SpinnerRidgetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
        SpinnerRidgetTest.assertEquals((int)9, (int)ridget.getTextLimit());
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        ridget.setTextLimit(10);
        ridget.setDigits(5);
        SpinnerRidgetTest.assertEquals((int)10, (int)ridget.getTextLimit());
        SpinnerRidgetTest.assertEquals((int)10, (int)control.getTextLimit());
        SpinnerRidgetTest.assertEquals((int)5, (int)ridget.getDigits());
        SpinnerRidgetTest.assertEquals((int)5, (int)control.getDigits());
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
        ridget.setTextLimit(2);
        SpinnerRidgetTest.assertEquals((int)2, (int)ridget.getTextLimit());
        SpinnerRidgetTest.assertEquals((int)2, (int)control.getTextLimit());
        SpinnerRidgetTest.assertEquals((int)2, (int)ridget.getDigits());
        SpinnerRidgetTest.assertEquals((int)2, (int)control.getDigits());
        this.assertPropertiesEqual((ITraverseRidget)ridget, (Control)control);
    }

    @Override
    protected void assertPropertiesEqual(ITraverseRidget ridget, Control control) {
        super.assertPropertiesEqual(ridget, control);
        SpinnerRidget spinnerRidget = (SpinnerRidget)ridget;
        SpinnerRidgetTest.assertEquals((int)this.getTextLimit(control), (int)spinnerRidget.getTextLimit());
        SpinnerRidgetTest.assertEquals((int)this.getDigits(control), (int)spinnerRidget.getDigits());
    }

    public void testSetTextLimitFiresEvents() {
        ISpinnerRidget ridget = this.getRidget();
        ridget.setTextLimit(2);
        this.expectPropertyChangeEvent("textLimit", 2, 4);
        ridget.setTextLimit(4);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setTextLimit(4);
        this.verifyPropertyChangeEvents();
        this.resetEasyMock();
        ridget.setTextLimit(4);
        ridget.setDigits(3);
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "digits", 3, 2), new PropertyChangeEvent(ridget, "textLimit", 4, 2));
        ridget.setTextLimit(2);
        this.verifyPropertyChangeEvents();
        try {
            this.resetEasyMock();
            this.expectNoPropertyChangeEvent();
            ridget.setTextLimit(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.verifyPropertyChangeEvents();
        }
        try {
            this.resetEasyMock();
            this.expectNoPropertyChangeEvent();
            ridget.setTextLimit(-1);
            this.verifyPropertyChangeEvents();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.verifyPropertyChangeEvents();
        }
        this.resetEasyMock();
        ridget.setTextLimit(4);
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "textLimit", 4, SpinnerRidget.LIMIT));
        ridget.setTextLimit(SpinnerRidget.LIMIT + 1);
        this.verifyPropertyChangeEvents();
    }

    public void testApplyDigitAndTextLimitOnBind() {
        ISpinnerRidget ridget = this.getRidget();
        Spinner control = (Spinner)this.createWidget((Composite)this.getShell());
        SpinnerRidgetTest.assertNotSame((Object)control, (Object)ridget.getUIControl());
        ridget.setTextLimit(4);
        ridget.setDigits(2);
        ridget.setUIControl((Object)control);
        SpinnerRidgetTest.assertEquals((int)2, (int)control.getDigits());
        SpinnerRidgetTest.assertEquals((int)4, (int)control.getTextLimit());
    }
}

