/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

abstract class AbstractObserver<T>
extends SelectionAdapter {
    private final IRidget source;
    private ListenerList<T> listeners;

    public AbstractObserver(IRidget source) {
        Assert.isNotNull((Object)source);
        this.source = source;
    }

    public final void widgetSelected(SelectionEvent evt) {
        this.fireAction(evt);
    }

    public final void addListener(T listener) {
        Assert.isNotNull(listener, (String)"listener is null");
        if (this.listeners == null) {
            this.listeners = this.createList();
        }
        this.listeners.add(listener);
    }

    public final void removeListener(T listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected abstract ListenerList<T> createList();

    protected abstract void fireAction(SelectionEvent var1);

    protected final IRidget getSource() {
        return this.source;
    }

    protected final ListenerList<T> getListeners() {
        return this.listeners;
    }
}

