/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.facades.internal;

import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public abstract class AbstractNavigationToolTip
extends DefaultToolTip {
    public AbstractNavigationToolTip(Control control) {
        super(control);
    }

    protected abstract String getToolTipText(Event var1);

    protected abstract Integer getLnfDelay(RienaDefaultLnf var1);

    protected abstract Font getLnfFont(RienaDefaultLnf var1);

    protected abstract Color getLnfBackground(RienaDefaultLnf var1);

    protected abstract Color getLnfForeground(RienaDefaultLnf var1);

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        CLabel label = new CLabel(parent, this.getStyle(event));
        Color fgColor = this.getForegroundColor(event);
        Color bgColor = this.getBackgroundColor(event);
        Font font = this.getFont(event);
        if (fgColor != null) {
            label.setForeground(fgColor);
        }
        if (bgColor != null) {
            label.setBackground(bgColor);
        }
        if (font != null) {
            label.setFont(font);
        }
        label.setText(this.getToolTipText(event));
        return label;
    }

    protected boolean shouldCreateToolTip(Event event) {
        boolean should = super.shouldCreateToolTip(event);
        if (should) {
            this.initLookAndFeel();
        }
        return should;
    }

    private void initLookAndFeel() {
        Font font;
        Color color;
        RienaDefaultLnf lnf = LnfManager.getLnf();
        Integer delay = this.getLnfDelay(lnf);
        if (delay != null) {
            this.setPopupDelay(delay);
        }
        if ((color = this.getLnfForeground(lnf)) != null) {
            this.setForegroundColor(color);
        }
        if ((color = this.getLnfBackground(lnf)) != null) {
            this.setBackgroundColor(color);
        }
        if ((font = this.getLnfFont(lnf)) != null) {
            this.setFont(font);
        }
    }
}

