/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.layout;

import org.eclipse.riena.internal.ui.swt.layout.DpiGridData;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

public class DpiGridLayout
extends Layout {
    public int numColumns = 1;
    public boolean makeColumnsEqualWidth = false;
    public int marginWidth = 5;
    public int marginHeight = 5;
    public int marginLeft = 0;
    public int marginTop = 0;
    public int marginRight = 0;
    public int marginBottom = 0;
    public int horizontalSpacing = 5;
    public int verticalSpacing = 5;

    public DpiGridLayout() {
    }

    public DpiGridLayout(int numColumns, boolean makeColumnsEqualWidth) {
        this.numColumns = numColumns;
        this.makeColumnsEqualWidth = makeColumnsEqualWidth;
    }

    protected boolean flushCache(Control control) {
        DpiGridData data = this.getDpiGridData(control);
        if (data != null) {
            data.flushCache();
        }
        return true;
    }

    DpiGridData getData(Control[][] grid, int row, int column, int rowCount, int columnCount, boolean first) {
        Control control = grid[row][column];
        if (control != null) {
            int j;
            if (control.getLayoutData() instanceof GridData) {
                GridData gridData = (GridData)control.getLayoutData();
                control.setLayoutData((Object)new DpiGridData(gridData));
            }
            DpiGridData data = (DpiGridData)control.getLayoutData();
            int hSpan = Math.max(1, Math.min(data.horizontalSpan, columnCount));
            int vSpan = Math.max(1, data.verticalSpan);
            int i = first ? row + vSpan - 1 : row - vSpan + 1;
            int n = j = first ? column + hSpan - 1 : column - hSpan + 1;
            if (i >= 0 && i < rowCount && j >= 0 && j < columnCount && control == grid[i][j]) {
                return data;
            }
        }
        return null;
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle rect = composite.getClientArea();
        this.layout(composite, true, rect.x, rect.y, rect.width, rect.height, flushCache);
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Point size = this.layout(composite, false, 0, 0, wHint, hHint, flushCache);
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        return size;
    }

    private Point layout(Composite composite, boolean move, int x, int y, int width, int height, boolean flushCache) {
        int i;
        int k;
        int k2;
        int i2;
        DpiGridData data;
        if (this.numColumns < 1) {
            return this.getMarginPoint();
        }
        Control[] children = composite.getChildren();
        int count = 0;
        int i3 = 0;
        while (i3 < children.length) {
            Control control = children[i3];
            data = this.getDpiGridData(control);
            if (data == null || !data.exclude) {
                children[count++] = children[i3];
            }
            ++i3;
        }
        if (count == 0) {
            return this.getMarginPoint();
        }
        i3 = 0;
        while (i3 < count) {
            Control child = children[i3];
            data = this.getDpiGridData(child);
            if (data == null) {
                GridData gridData = new GridData();
                child.setLayoutData((Object)gridData);
                data = this.getDpiGridData(child);
            }
            if (flushCache) {
                data.flushCache();
            }
            data.computeSize(child, data.widthHint, data.heightHint, flushCache);
            if (data.grabExcessHorizontalSpace && data.minimumWidth > 0 && data.cacheWidth < data.minimumWidth) {
                int trim = this.getTrim(child);
                data.cacheHeight = -1;
                data.cacheWidth = -1;
                data.computeSize(child, Math.max(0, data.minimumWidth - trim), data.heightHint, false);
            }
            if (data.grabExcessVerticalSpace && data.minimumHeight > 0) {
                data.cacheHeight = Math.max(data.cacheHeight, data.minimumHeight);
            }
            ++i3;
        }
        int row = 0;
        int column = 0;
        int rowCount = 0;
        int columnCount = this.numColumns;
        Control[][] grid = new Control[4][columnCount];
        int i4 = 0;
        while (i4 < count) {
            Control child = children[i4];
            DpiGridData data2 = this.getDpiGridData(child);
            int hSpan = Math.max(1, Math.min(data2.horizontalSpan, columnCount));
            int vSpan = Math.max(1, data2.verticalSpan);
            while (true) {
                int lastRow;
                if ((lastRow = row + vSpan) >= grid.length) {
                    Control[][] newGrid = new Control[lastRow + 4][columnCount];
                    System.arraycopy(grid, 0, newGrid, 0, grid.length);
                    grid = newGrid;
                }
                if (grid[row] == null) {
                    grid[row] = new Control[columnCount];
                }
                while (column < columnCount && grid[row][column] != null) {
                    ++column;
                }
                int endCount = column + hSpan;
                if (endCount <= columnCount) {
                    int index = column;
                    while (index < endCount && grid[row][index] == null) {
                        ++index;
                    }
                    if (index == endCount) break;
                    column = index;
                }
                if (column + hSpan < columnCount) continue;
                column = 0;
                ++row;
            }
            int j = 0;
            while (j < vSpan) {
                if (grid[row + j] == null) {
                    grid[row + j] = new Control[columnCount];
                }
                int k3 = 0;
                while (k3 < hSpan) {
                    grid[row + j][column + k3] = child;
                    ++k3;
                }
                ++j;
            }
            rowCount = Math.max(rowCount, row + vSpan);
            column += hSpan;
            ++i4;
        }
        int dpiHorizontalSpacing = SwtUtilities.convertXToDpi(this.horizontalSpacing);
        int dpiMarginLeft = SwtUtilities.convertXToDpi(this.marginLeft);
        int dpiMarginWidth = SwtUtilities.convertXToDpi(this.marginWidth);
        int dpiMarginRight = SwtUtilities.convertXToDpi(this.marginRight);
        int availableWidth = width - dpiHorizontalSpacing * (columnCount - 1) - (dpiMarginLeft + dpiMarginWidth * 2 + dpiMarginRight);
        int expandCount = 0;
        int[] widths = new int[columnCount];
        int[] minWidths = new int[columnCount];
        boolean[] expandColumn = new boolean[columnCount];
        int j = 0;
        while (j < columnCount) {
            int hSpan;
            DpiGridData data3;
            i2 = 0;
            while (i2 < rowCount) {
                data3 = this.getData(grid, i2, j, rowCount, columnCount, true);
                if (data3 != null && (hSpan = Math.max(1, Math.min(data3.horizontalSpan, columnCount))) == 1) {
                    int w = data3.cacheWidth + data3.horizontalIndent;
                    widths[j] = Math.max(widths[j], w);
                    if (data3.grabExcessHorizontalSpace) {
                        if (!expandColumn[j]) {
                            ++expandCount;
                        }
                        expandColumn[j] = true;
                    }
                    if (!data3.grabExcessHorizontalSpace || data3.minimumWidth != 0) {
                        w = !data3.grabExcessHorizontalSpace || data3.minimumWidth == -1 ? data3.cacheWidth : data3.minimumWidth;
                        minWidths[j] = Math.max(minWidths[j], w += data3.horizontalIndent);
                    }
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < rowCount) {
                data3 = this.getData(grid, i2, j, rowCount, columnCount, false);
                if (data3 != null && (hSpan = Math.max(1, Math.min(data3.horizontalSpan, columnCount))) > 1) {
                    int delta;
                    int last;
                    int remainder;
                    int w;
                    int spanWidth = 0;
                    int spanMinWidth = 0;
                    int spanExpandCount = 0;
                    int k4 = 0;
                    while (k4 < hSpan) {
                        spanWidth += widths[j - k4];
                        spanMinWidth += minWidths[j - k4];
                        if (expandColumn[j - k4]) {
                            ++spanExpandCount;
                        }
                        ++k4;
                    }
                    if (data3.grabExcessHorizontalSpace && spanExpandCount == 0) {
                        ++expandCount;
                        expandColumn[j] = true;
                    }
                    if ((w = data3.cacheWidth + data3.horizontalIndent - spanWidth - (hSpan - 1) * dpiHorizontalSpacing) > 0) {
                        if (this.makeColumnsEqualWidth) {
                            int equalWidth = (w + spanWidth) / hSpan;
                            remainder = (w + spanWidth) % hSpan;
                            last = -1;
                            k2 = 0;
                            while (k2 < hSpan) {
                                last = j - k2;
                                widths[last] = Math.max(equalWidth, widths[j - k2]);
                                ++k2;
                            }
                            if (last > -1) {
                                int n = last;
                                widths[n] = widths[n] + remainder;
                            }
                        } else if (spanExpandCount == 0) {
                            int n = j;
                            widths[n] = widths[n] + w;
                        } else {
                            delta = w / spanExpandCount;
                            remainder = w % spanExpandCount;
                            last = -1;
                            k2 = 0;
                            while (k2 < hSpan) {
                                if (expandColumn[j - k2]) {
                                    last = j - k2;
                                    widths[last] = widths[last] + delta;
                                }
                                ++k2;
                            }
                            if (last > -1) {
                                int n = last;
                                widths[n] = widths[n] + remainder;
                            }
                        }
                    }
                    if (!data3.grabExcessHorizontalSpace || data3.minimumWidth != 0) {
                        int n = w = !data3.grabExcessHorizontalSpace || data3.minimumWidth == -1 ? data3.cacheWidth : data3.minimumWidth;
                        if ((w += data3.horizontalIndent - spanMinWidth - (hSpan - 1) * dpiHorizontalSpacing) > 0) {
                            if (spanExpandCount == 0) {
                                int n2 = j;
                                minWidths[n2] = minWidths[n2] + w;
                            } else {
                                delta = w / spanExpandCount;
                                remainder = w % spanExpandCount;
                                last = -1;
                                k2 = 0;
                                while (k2 < hSpan) {
                                    if (expandColumn[j - k2]) {
                                        last = j - k2;
                                        minWidths[last] = minWidths[last] + delta;
                                    }
                                    ++k2;
                                }
                                if (last > -1) {
                                    int n3 = last;
                                    minWidths[n3] = minWidths[n3] + remainder;
                                }
                            }
                        }
                    }
                }
                ++i2;
            }
            ++j;
        }
        if (this.makeColumnsEqualWidth) {
            int minColumnWidth = 0;
            int columnWidth = 0;
            int i5 = 0;
            while (i5 < columnCount) {
                minColumnWidth = Math.max(minColumnWidth, minWidths[i5]);
                columnWidth = Math.max(columnWidth, widths[i5]);
                ++i5;
            }
            columnWidth = width == -1 || expandCount == 0 ? columnWidth : Math.max(minColumnWidth, availableWidth / columnCount);
            i5 = 0;
            while (i5 < columnCount) {
                expandColumn[i5] = expandCount > 0;
                widths[i5] = columnWidth;
                ++i5;
            }
        } else if (width != -1 && expandCount > 0) {
            int totalWidth = 0;
            i2 = 0;
            while (i2 < columnCount) {
                totalWidth += widths[i2];
                ++i2;
            }
            int c = expandCount;
            int delta = (availableWidth - totalWidth) / c;
            int remainder = (availableWidth - totalWidth) % c;
            int last = -1;
            while (totalWidth != availableWidth) {
                int j2 = 0;
                while (j2 < columnCount) {
                    if (expandColumn[j2]) {
                        if (widths[j2] + delta > minWidths[j2]) {
                            last = j2;
                            widths[last] = widths[j2] + delta;
                        } else {
                            widths[j2] = minWidths[j2];
                            expandColumn[j2] = false;
                            --c;
                        }
                    }
                    ++j2;
                }
                if (last > -1) {
                    int n = last;
                    widths[n] = widths[n] + remainder;
                }
                j2 = 0;
                while (j2 < columnCount) {
                    int i6 = 0;
                    while (i6 < rowCount) {
                        int hSpan;
                        DpiGridData data4 = this.getData(grid, i6, j2, rowCount, columnCount, false);
                        if (!(data4 == null || (hSpan = Math.max(1, Math.min(data4.horizontalSpan, columnCount))) <= 1 || data4.grabExcessHorizontalSpace && data4.minimumWidth == 0)) {
                            int w;
                            int spanWidth = 0;
                            int spanExpandCount = 0;
                            k2 = 0;
                            while (k2 < hSpan) {
                                spanWidth += widths[j2 - k2];
                                if (expandColumn[j2 - k2]) {
                                    ++spanExpandCount;
                                }
                                ++k2;
                            }
                            int n = w = !data4.grabExcessHorizontalSpace || data4.minimumWidth == -1 ? data4.cacheWidth : data4.minimumWidth;
                            if ((w += data4.horizontalIndent - spanWidth - (hSpan - 1) * dpiHorizontalSpacing) > 0) {
                                if (spanExpandCount == 0) {
                                    int n4 = j2;
                                    widths[n4] = widths[n4] + w;
                                } else {
                                    int delta2 = w / spanExpandCount;
                                    int remainder2 = w % spanExpandCount;
                                    int last2 = -1;
                                    int k5 = 0;
                                    while (k5 < hSpan) {
                                        if (expandColumn[j2 - k5]) {
                                            last2 = j2 - k5;
                                            widths[last2] = widths[last2] + delta2;
                                        }
                                        ++k5;
                                    }
                                    if (last2 > -1) {
                                        int n5 = last2;
                                        widths[n5] = widths[n5] + remainder2;
                                    }
                                }
                            }
                        }
                        ++i6;
                    }
                    ++j2;
                }
                if (c != 0) {
                    totalWidth = 0;
                    int i7 = 0;
                    while (i7 < columnCount) {
                        totalWidth += widths[i7];
                        ++i7;
                    }
                    delta = (availableWidth - totalWidth) / c;
                    remainder = (availableWidth - totalWidth) % c;
                    last = -1;
                    continue;
                }
                break;
            }
        }
        DpiGridData[] flush = null;
        int flushLength = 0;
        if (width != -1) {
            int j3 = 0;
            while (j3 < columnCount) {
                int i8 = 0;
                while (i8 < rowCount) {
                    DpiGridData data5 = this.getData(grid, i8, j3, rowCount, columnCount, false);
                    if (data5 != null && data5.heightHint == -1) {
                        Control child = grid[i8][j3];
                        int hSpan = Math.max(1, Math.min(data5.horizontalSpan, columnCount));
                        int currentWidth = 0;
                        int k6 = 0;
                        while (k6 < hSpan) {
                            currentWidth += widths[j3 - k6];
                            ++k6;
                        }
                        if ((currentWidth += (hSpan - 1) * dpiHorizontalSpacing - data5.horizontalIndent) != data5.cacheWidth && data5.horizontalAlignment == 4 || data5.cacheWidth > currentWidth) {
                            int trim = this.getTrim(child);
                            data5.cacheHeight = -1;
                            data5.cacheWidth = -1;
                            data5.computeSize(child, Math.max(0, currentWidth - trim), data5.heightHint, false);
                            if (data5.grabExcessVerticalSpace && data5.minimumHeight > 0) {
                                data5.cacheHeight = Math.max(data5.cacheHeight, data5.minimumHeight);
                            }
                            if (flush == null) {
                                flush = new DpiGridData[count];
                            }
                            flush[flushLength++] = data5;
                        }
                    }
                    ++i8;
                }
                ++j3;
            }
        }
        int dpiVerticalSpacing = SwtUtilities.convertYToDpi(this.verticalSpacing);
        int dpiMarginTop = SwtUtilities.convertYToDpi(this.marginTop);
        int dpiMarginHeight = SwtUtilities.convertYToDpi(this.marginHeight);
        int dpiMarginBottom = SwtUtilities.convertYToDpi(this.marginBottom);
        int availableHeight = height - dpiVerticalSpacing * (rowCount - 1) - (dpiMarginTop + dpiMarginHeight * 2 + dpiMarginBottom);
        expandCount = 0;
        int[] heights = new int[rowCount];
        int[] minHeights = new int[rowCount];
        boolean[] expandRow = new boolean[rowCount];
        int i9 = 0;
        while (i9 < rowCount) {
            int vSpan;
            int j4 = 0;
            while (j4 < columnCount) {
                DpiGridData data6 = this.getData(grid, i9, j4, rowCount, columnCount, true);
                if (data6 != null && (vSpan = Math.max(1, Math.min(data6.verticalSpan, rowCount))) == 1) {
                    int h = data6.cacheHeight + data6.verticalIndent;
                    heights[i9] = Math.max(heights[i9], h);
                    if (data6.grabExcessVerticalSpace) {
                        if (!expandRow[i9]) {
                            ++expandCount;
                        }
                        expandRow[i9] = true;
                    }
                    if (!data6.grabExcessVerticalSpace || data6.minimumHeight != 0) {
                        h = !data6.grabExcessVerticalSpace || data6.minimumHeight == -1 ? data6.cacheHeight : data6.minimumHeight;
                        minHeights[i9] = Math.max(minHeights[i9], h += data6.verticalIndent);
                    }
                }
                ++j4;
            }
            j4 = 0;
            while (j4 < columnCount) {
                DpiGridData data7 = this.getData(grid, i9, j4, rowCount, columnCount, false);
                if (data7 != null && (vSpan = Math.max(1, Math.min(data7.verticalSpan, rowCount))) > 1) {
                    int last;
                    int remainder;
                    int delta;
                    int h;
                    int spanHeight = 0;
                    int spanMinHeight = 0;
                    int spanExpandCount = 0;
                    int k7 = 0;
                    while (k7 < vSpan) {
                        spanHeight += heights[i9 - k7];
                        spanMinHeight += minHeights[i9 - k7];
                        if (expandRow[i9 - k7]) {
                            ++spanExpandCount;
                        }
                        ++k7;
                    }
                    if (data7.grabExcessVerticalSpace && spanExpandCount == 0) {
                        ++expandCount;
                        expandRow[i9] = true;
                    }
                    if ((h = data7.cacheHeight + data7.verticalIndent - spanHeight - (vSpan - 1) * dpiVerticalSpacing) > 0) {
                        if (spanExpandCount == 0) {
                            int n = i9;
                            heights[n] = heights[n] + h;
                        } else {
                            delta = h / spanExpandCount;
                            remainder = h % spanExpandCount;
                            last = -1;
                            k = 0;
                            while (k < vSpan) {
                                if (expandRow[i9 - k]) {
                                    last = i9 - k;
                                    heights[last] = heights[last] + delta;
                                }
                                ++k;
                            }
                            if (last > -1) {
                                int n = last;
                                heights[n] = heights[n] + remainder;
                            }
                        }
                    }
                    if (!data7.grabExcessVerticalSpace || data7.minimumHeight != 0) {
                        int n = h = !data7.grabExcessVerticalSpace || data7.minimumHeight == -1 ? data7.cacheHeight : data7.minimumHeight;
                        if ((h += data7.verticalIndent - spanMinHeight - (vSpan - 1) * dpiVerticalSpacing) > 0) {
                            if (spanExpandCount == 0) {
                                int n6 = i9;
                                minHeights[n6] = minHeights[n6] + h;
                            } else {
                                delta = h / spanExpandCount;
                                remainder = h % spanExpandCount;
                                last = -1;
                                k = 0;
                                while (k < vSpan) {
                                    if (expandRow[i9 - k]) {
                                        last = i9 - k;
                                        minHeights[last] = minHeights[last] + delta;
                                    }
                                    ++k;
                                }
                                if (last > -1) {
                                    int n7 = last;
                                    minHeights[n7] = minHeights[n7] + remainder;
                                }
                            }
                        }
                    }
                }
                ++j4;
            }
            ++i9;
        }
        if (height != -1 && expandCount > 0) {
            int totalHeight = 0;
            i = 0;
            while (i < rowCount) {
                totalHeight += heights[i];
                ++i;
            }
            int c = expandCount;
            int delta = (availableHeight - totalHeight) / c;
            int remainder = (availableHeight - totalHeight) % c;
            int last = -1;
            while (totalHeight != availableHeight) {
                int i10 = 0;
                while (i10 < rowCount) {
                    if (expandRow[i10]) {
                        if (heights[i10] + delta > minHeights[i10]) {
                            last = i10;
                            heights[last] = heights[i10] + delta;
                        } else {
                            heights[i10] = minHeights[i10];
                            expandRow[i10] = false;
                            --c;
                        }
                    }
                    ++i10;
                }
                if (last > -1) {
                    int n = last;
                    heights[n] = heights[n] + remainder;
                }
                i10 = 0;
                while (i10 < rowCount) {
                    int j5 = 0;
                    while (j5 < columnCount) {
                        int vSpan;
                        DpiGridData data8 = this.getData(grid, i10, j5, rowCount, columnCount, false);
                        if (!(data8 == null || (vSpan = Math.max(1, Math.min(data8.verticalSpan, rowCount))) <= 1 || data8.grabExcessVerticalSpace && data8.minimumHeight == 0)) {
                            int h;
                            int spanHeight = 0;
                            int spanExpandCount = 0;
                            k = 0;
                            while (k < vSpan) {
                                spanHeight += heights[i10 - k];
                                if (expandRow[i10 - k]) {
                                    ++spanExpandCount;
                                }
                                ++k;
                            }
                            int n = h = !data8.grabExcessVerticalSpace || data8.minimumHeight == -1 ? data8.cacheHeight : data8.minimumHeight;
                            if ((h += data8.verticalIndent - spanHeight - (vSpan - 1) * dpiVerticalSpacing) > 0) {
                                if (spanExpandCount == 0) {
                                    int n8 = i10;
                                    heights[n8] = heights[n8] + h;
                                } else {
                                    int delta2 = h / spanExpandCount;
                                    int remainder2 = h % spanExpandCount;
                                    int last2 = -1;
                                    int k8 = 0;
                                    while (k8 < vSpan) {
                                        if (expandRow[i10 - k8]) {
                                            last2 = i10 - k8;
                                            heights[last2] = heights[last2] + delta2;
                                        }
                                        ++k8;
                                    }
                                    if (last2 > -1) {
                                        int n9 = last2;
                                        heights[n9] = heights[n9] + remainder2;
                                    }
                                }
                            }
                        }
                        ++j5;
                    }
                    ++i10;
                }
                if (c == 0) break;
                totalHeight = 0;
                i10 = 0;
                while (i10 < rowCount) {
                    totalHeight += heights[i10];
                    ++i10;
                }
                delta = (availableHeight - totalHeight) / c;
                remainder = (availableHeight - totalHeight) % c;
                last = -1;
            }
        }
        if (move) {
            int gridY = y + dpiMarginTop + dpiMarginHeight;
            i = 0;
            while (i < rowCount) {
                int gridX = x + dpiMarginLeft + dpiMarginWidth;
                int j6 = 0;
                while (j6 < columnCount) {
                    DpiGridData data9 = this.getData(grid, i, j6, rowCount, columnCount, true);
                    if (data9 != null) {
                        int hSpan = Math.max(1, Math.min(data9.horizontalSpan, columnCount));
                        int vSpan = Math.max(1, data9.verticalSpan);
                        int cellWidth = 0;
                        int cellHeight = 0;
                        int k9 = 0;
                        while (k9 < hSpan) {
                            cellWidth += widths[j6 + k9];
                            ++k9;
                        }
                        k9 = 0;
                        while (k9 < vSpan) {
                            cellHeight += heights[i + k9];
                            ++k9;
                        }
                        int childX = gridX + data9.horizontalIndent;
                        int childWidth = Math.min(data9.cacheWidth, cellWidth += dpiHorizontalSpacing * (hSpan - 1));
                        switch (data9.horizontalAlignment) {
                            case 2: 
                            case 0x1000000: {
                                childX += Math.max(0, (cellWidth - data9.horizontalIndent - childWidth) / 2);
                                break;
                            }
                            case 3: 
                            case 131072: 
                            case 0x1000008: {
                                childX += Math.max(0, cellWidth - data9.horizontalIndent - childWidth);
                                break;
                            }
                            case 4: {
                                childWidth = cellWidth - data9.horizontalIndent;
                            }
                        }
                        int childY = gridY + data9.verticalIndent;
                        int childHeight = Math.min(data9.cacheHeight, cellHeight += dpiVerticalSpacing * (vSpan - 1));
                        switch (data9.verticalAlignment) {
                            case 2: 
                            case 0x1000000: {
                                childY += Math.max(0, (cellHeight - data9.verticalIndent - childHeight) / 2);
                                break;
                            }
                            case 3: 
                            case 1024: 
                            case 0x1000008: {
                                childY += Math.max(0, cellHeight - data9.verticalIndent - childHeight);
                                break;
                            }
                            case 4: {
                                childHeight = cellHeight - data9.verticalIndent;
                            }
                        }
                        Control child = grid[i][j6];
                        if (child != null) {
                            child.setBounds(childX, childY, childWidth, childHeight);
                        }
                    }
                    gridX += widths[j6] + dpiHorizontalSpacing;
                    ++j6;
                }
                gridY += heights[i] + dpiVerticalSpacing;
                ++i;
            }
        }
        i9 = 0;
        while (i9 < flushLength) {
            flush[i9].cacheHeight = -1;
            flush[i9].cacheWidth = -1;
            ++i9;
        }
        int totalDefaultWidth = 0;
        int totalDefaultHeight = 0;
        int i11 = 0;
        while (i11 < columnCount) {
            totalDefaultWidth += widths[i11];
            ++i11;
        }
        i11 = 0;
        while (i11 < rowCount) {
            totalDefaultHeight += heights[i11];
            ++i11;
        }
        return new Point(totalDefaultWidth += dpiHorizontalSpacing * (columnCount - 1) + dpiMarginLeft + dpiMarginWidth * 2 + dpiMarginRight, totalDefaultHeight += dpiVerticalSpacing * (rowCount - 1) + dpiMarginTop + dpiMarginHeight * 2 + dpiMarginBottom);
    }

    private Point getMarginPoint() {
        int x = this.marginLeft + this.marginWidth * 2 + this.marginRight;
        x = SwtUtilities.convertXToDpi(x);
        int y = this.marginTop + this.marginHeight * 2 + this.marginBottom;
        y = SwtUtilities.convertYToDpi(y);
        return new Point(x, y);
    }

    private int getTrim(Control control) {
        if (control instanceof Scrollable) {
            Rectangle rect = ((Scrollable)control).computeTrim(0, 0, 0, 0);
            return rect.width;
        }
        return control.getBorderWidth() * 2;
    }

    private DpiGridData getDpiGridData(Control control) {
        if (control.getLayoutData() instanceof GridData) {
            GridData gridData = (GridData)control.getLayoutData();
            control.setLayoutData((Object)new DpiGridData(gridData));
        }
        return (DpiGridData)control.getLayoutData();
    }

    private String getName() {
        String string = ((Object)((Object)this)).getClass().getName();
        int index = string.lastIndexOf(46);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1, string.length());
    }

    public String toString() {
        String string = String.valueOf(this.getName()) + " {";
        if (this.numColumns != 1) {
            string = String.valueOf(string) + "numColumns=" + this.numColumns + " ";
        }
        if (this.makeColumnsEqualWidth) {
            string = String.valueOf(string) + "makeColumnsEqualWidth=" + this.makeColumnsEqualWidth + " ";
        }
        if (this.marginWidth != 0) {
            string = String.valueOf(string) + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            string = String.valueOf(string) + "marginHeight=" + this.marginHeight + " ";
        }
        if (this.marginLeft != 0) {
            string = String.valueOf(string) + "marginLeft=" + this.marginLeft + " ";
        }
        if (this.marginRight != 0) {
            string = String.valueOf(string) + "marginRight=" + this.marginRight + " ";
        }
        if (this.marginTop != 0) {
            string = String.valueOf(string) + "marginTop=" + this.marginTop + " ";
        }
        if (this.marginBottom != 0) {
            string = String.valueOf(string) + "marginBottom=" + this.marginBottom + " ";
        }
        if (this.horizontalSpacing != 0) {
            string = String.valueOf(string) + "horizontalSpacing=" + this.horizontalSpacing + " ";
        }
        if (this.verticalSpacing != 0) {
            string = String.valueOf(string) + "verticalSpacing=" + this.verticalSpacing + " ";
        }
        string = string.trim();
        string = String.valueOf(string) + "}";
        return string;
    }
}

