/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.lnf.rienadefault;

import java.beans.Beans;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.swt.lnf.ColorLnfResource;
import org.eclipse.riena.ui.swt.lnf.FontDescriptor;
import org.eclipse.riena.ui.swt.lnf.ILnfCustomizer;
import org.eclipse.riena.ui.swt.lnf.ILnfMarkerSupportExtension;
import org.eclipse.riena.ui.swt.lnf.ILnfRenderer;
import org.eclipse.riena.ui.swt.lnf.ILnfRendererExtension;
import org.eclipse.riena.ui.swt.lnf.ILnfResource;
import org.eclipse.riena.ui.swt.lnf.ILnfTheme;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultTheme;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;

public class RienaDefaultLnf
implements ILnfCustomizer {
    private static final Logger LOGGER = Log4r.getLogger(RienaDefaultLnf.class);
    private static final String SYSTEM_PROPERTY_LNF_SETTING_PREFIX = "riena.lnf.setting.";
    private final Map<String, ILnfResource<?>> resourceTable = new HashMap();
    private final Set<String> resourcePrefixes = new HashSet<String>();
    private final Map<String, Object> settingTable = new ConcurrentHashMap<String, Object>();
    private final Map<String, ILnfRenderer> rendererTable = new HashMap<String, ILnfRenderer>();
    private ILnfMarkerSupportExtension[] markerSupportList = new ILnfMarkerSupportExtension[0];
    private ILnfTheme theme;
    private boolean initialized;

    public RienaDefaultLnf(ILnfTheme theme) {
        this.setTheme(theme);
    }

    public RienaDefaultLnf() {
        this(null);
    }

    @Override
    public ILnfResource<?> getLnfResource(String key) {
        return this.resourceTable.get(key);
    }

    @Override
    public ILnfResource<?> putLnfResource(String key, ILnfResource<?> resource) {
        int dot = key.indexOf(46);
        if (dot != -1) {
            this.resourcePrefixes.add(key.substring(0, dot));
        }
        return this.resourceTable.put(key, resource);
    }

    public boolean containsLnfResourcePrefix(String prefix) {
        return this.resourcePrefixes.contains(prefix);
    }

    @Override
    public Object getLnfSetting(String key) {
        return this.settingTable.get(key);
    }

    @Override
    public Object putLnfSetting(String key, Object setting) {
        return this.settingTable.put(key, setting);
    }

    public void initialize() {
        if (!this.isInitialized()) {
            this.uninitialize();
            this.setInitialized(true);
            this.initializeTheme();
            this.readSystemProperties();
        }
    }

    private void readSystemProperties() {
        Properties sysProps = System.getProperties();
        Set<Object> sysPropKeys = sysProps.keySet();
        for (Object propKey : sysPropKeys) {
            String propKeyName = propKey.toString();
            if (!propKeyName.startsWith(SYSTEM_PROPERTY_LNF_SETTING_PREFIX)) continue;
            String lnfKey = propKeyName.substring(SYSTEM_PROPERTY_LNF_SETTING_PREFIX.length());
            Object lnfValue = sysProps.get(propKeyName);
            this.putLnfSetting(lnfKey, lnfValue);
        }
    }

    public void uninitialize() {
        this.resourceTable.clear();
        this.resourcePrefixes.clear();
        this.settingTable.clear();
        this.setInitialized(false);
    }

    @InjectExtension
    public void update(ILnfRendererExtension[] rendererExtensions) {
        this.rendererTable.clear();
        ILnfRendererExtension[] iLnfRendererExtensionArray = rendererExtensions;
        int n = rendererExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            ILnfRendererExtension rendererExtension = iLnfRendererExtensionArray[n2];
            String id = rendererExtension.getLnfId();
            if (!(!StringUtils.isEmpty((CharSequence)id) && !id.equals(this.getLnfId()) || StringUtils.isEmpty((CharSequence)id) && this.rendererTable.get(rendererExtension.getLnfKey()) != null)) {
                this.rendererTable.put(rendererExtension.getLnfKey(), rendererExtension.createRenderer());
            }
            ++n2;
        }
    }

    @InjectExtension
    public void update(ILnfMarkerSupportExtension[] markerSupportExtensions) {
        this.markerSupportList = markerSupportExtensions;
    }

    public AbstractMarkerSupport getMarkerSupport(Class<? extends IRidget> ridgetClass) {
        String markerSupportID = this.getStringSetting("markerSupport.id");
        ILnfMarkerSupportExtension[] iLnfMarkerSupportExtensionArray = this.markerSupportList;
        int n = this.markerSupportList.length;
        int n2 = 0;
        while (n2 < n) {
            ILnfMarkerSupportExtension lnfMarkerSupportExtension = iLnfMarkerSupportExtensionArray[n2];
            if (!StringUtils.isEmpty((CharSequence)lnfMarkerSupportExtension.getId()) && lnfMarkerSupportExtension.getId().equals(markerSupportID)) {
                return lnfMarkerSupportExtension.createMarkerSupport();
            }
            ++n2;
        }
        if (Platform.getBundle((String)"org.eclipse.swt") != null) {
            LOGGER.log(3, "No MarkerSupport with the ID \"" + markerSupportID + "\" exists.");
        }
        return null;
    }

    protected void initializeTheme() {
        this.putLnfResource("black", new ColorLnfResource(0, 0, 0));
        this.putLnfResource("white", new ColorLnfResource(255, 255, 255));
        if (this.getTheme() != null) {
            this.getTheme().customizeLnf(this);
        }
    }

    public Resource getResource(String key) {
        ILnfResource<?> value = this.resourceTable.get(key);
        if (value != null) {
            return value.getResource();
        }
        return null;
    }

    public Color getColor(String key) {
        return this.getColor(key, null);
    }

    public Color getColor(String key, Color defaultValue) {
        Resource value = this.getResource(key);
        if (value instanceof Color) {
            return (Color)value;
        }
        return defaultValue;
    }

    public Font getFont(String key) {
        Resource value = this.getResource(key);
        if (value instanceof Font) {
            return (Font)value;
        }
        return null;
    }

    public Font getFont(String key, int height, int style) {
        FontDescriptor fontDescriptor = new FontDescriptor(key, height, style, this);
        return fontDescriptor.getFont();
    }

    public Image getImage(String key) {
        Resource value = this.getResource(key);
        if (value instanceof Image) {
            return (Image)value;
        }
        return null;
    }

    public ILnfRenderer getRenderer(String key) {
        return this.rendererTable.get(key);
    }

    public Object getSetting(String key) {
        return this.settingTable.get(key);
    }

    public Integer getIntegerSetting(String key) {
        Object value = this.getSetting(key);
        if (value == null) {
            if (Beans.isDesignTime()) {
                return new Integer(0);
            }
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        String strgValue = value.toString();
        try {
            return new Integer(strgValue);
        }
        catch (NumberFormatException numberFormatException) {
            if (Beans.isDesignTime()) {
                return 0;
            }
            return null;
        }
    }

    public Integer getIntegerSetting(String key, Integer defaultValue) {
        Integer value = this.getIntegerSetting(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public Boolean getBooleanSetting(String key) {
        Object value = this.getSetting(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.valueOf(value.toString());
    }

    public Boolean getBooleanSetting(String key, boolean defaultValue) {
        Boolean value = this.getBooleanSetting(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String getStringSetting(String key) {
        Object value = this.getSetting(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public String getStringSetting(String key, String defaultValue) {
        Object value = this.getSetting(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return defaultValue;
    }

    public ILnfTheme getTheme() {
        if (this.theme == null) {
            this.theme = new RienaDefaultTheme();
            this.initialize();
        }
        return this.theme;
    }

    public void setTheme(ILnfTheme newTheme) {
        if (this.theme != newTheme) {
            this.theme = newTheme;
            this.setInitialized(false);
            this.initialize();
        }
    }

    private boolean isInitialized() {
        return this.initialized;
    }

    private void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    protected String getLnfId() {
        return "";
    }

    @Override
    public float[] getDpiFactors(Point dpi) {
        return new float[]{0.0f, 0.0f};
    }

    @Override
    public String getIconScaleSuffix(Point dpi) {
        return null;
    }
}

