/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.communication.core.IRemoteServiceReference;
import org.eclipse.riena.communication.core.IRemoteServiceRegistration;
import org.eclipse.riena.communication.core.IRemoteServiceRegistry;
import org.eclipse.riena.communication.core.RemoteFailure;
import org.eclipse.riena.communication.core.RemoteServiceDescription;
import org.eclipse.riena.communication.core.factory.IRemoteServiceFactory;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.RienaStatus;
import org.eclipse.riena.core.util.Iter;
import org.eclipse.riena.core.util.Orderer;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.core.wire.InjectService;
import org.eclipse.riena.internal.communication.core.Activator;
import org.eclipse.riena.internal.communication.core.factory.CallHooksProxy;
import org.eclipse.riena.internal.communication.core.factory.ICallInterceptorExtension;
import org.eclipse.riena.internal.communication.core.factory.IRemoteServiceFactoryExtension;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class RemoteServiceFactory {
    private IRemoteServiceRegistry registry;
    private HashMap<String, IRemoteServiceFactory> remoteServiceFactoryImplementations = null;
    private ICallInterceptorExtension[] callInterceptorExtensions;
    private Map<Class<?>, List<ICallInterceptorExtension>> callInterceptorsRaw;
    private Map<Class<?>, Iterable<Class<?>>> callInterceptors;
    private boolean callInterceptorsReified;
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), RemoteServiceFactory.class);

    protected RemoteServiceFactory() {
    }

    @InjectService(useRanking=true)
    public void bind(IRemoteServiceRegistry registryParm) {
        this.registry = registryParm;
    }

    public void unbind(IRemoteServiceRegistry registryParm) {
        if (this.registry == registryParm) {
            this.registry = null;
        }
    }

    @InjectExtension
    public void update(IRemoteServiceFactoryExtension[] factories) {
        this.remoteServiceFactoryImplementations = new HashMap();
        IRemoteServiceFactoryExtension[] iRemoteServiceFactoryExtensionArray = factories;
        int n = factories.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteServiceFactoryExtension factory = iRemoteServiceFactoryExtensionArray[n2];
            this.remoteServiceFactoryImplementations.put(factory.getProtocol(), factory.createRemoteServiceFactory());
            ++n2;
        }
    }

    public IRemoteServiceRegistration createAndRegisterProxy(Class<?> interfaceClass, String url, String protocol, BundleContext context) {
        RemoteServiceDescription rsd = this.createDescription(interfaceClass, url, protocol, context.getBundle());
        return this.createAndRegisterProxy(rsd, context);
    }

    public IRemoteServiceRegistration createAndRegisterProxy(RemoteServiceDescription rsDesc, BundleContext context) {
        IRemoteServiceReference rsRef = this.createProxy(rsDesc);
        if (rsRef == null) {
            rsRef = this.createLazyProxy(rsDesc);
        }
        if (rsRef == null) {
            LOGGER.log(1, "could not create serviceInstance (neither serviceInstance nor lazy serviceInstance) for " + rsDesc);
            return null;
        }
        if (this.registry != null) {
            IRemoteServiceRegistration reg = this.registry.registerService(rsRef, context);
            return reg;
        }
        return null;
    }

    public IRemoteServiceReference createProxy(Class<?> interfaceClass, String url, String protocol, BundleContext context) {
        return this.createProxy(this.createDescription(interfaceClass, url, protocol, context.getBundle()));
    }

    private RemoteServiceDescription createDescription(Class<?> interfaceClass, String url, String protocol, Bundle bundle) {
        return new RemoteServiceDescription(interfaceClass, url, protocol, bundle);
    }

    public IRemoteServiceReference createProxy(RemoteServiceDescription rsd) {
        if (!RienaStatus.isActive()) {
            LOGGER.log(2, "riena.core is not started. This may probably not work.");
        }
        if (rsd.getProtocol() == null) {
            return null;
        }
        IRemoteServiceFactory factory = this.remoteServiceFactoryImplementations.get(rsd.getProtocol());
        if (factory == null) {
            LOGGER.log(2, "no IRemoteServiceFactory extension available protocol [" + rsd.getProtocol() + "] id [" + rsd.getServiceInterfaceClassName() + "]");
            return null;
        }
        LOGGER.log(3, "found protocol [" + rsd.getProtocol() + "] " + factory);
        IRemoteServiceReference rsr = factory.createProxy(rsd);
        CallHooksProxy callHooksProxy = new CallHooksProxy(rsr.getServiceInstance());
        callHooksProxy.setRemoteServiceDescription(rsd);
        callHooksProxy.setMessageContextAccessor(factory.getMessageContextAccessor());
        Object serviceProxy = Proxy.newProxyInstance(rsd.getServiceInterfaceClass().getClassLoader(), new Class[]{rsd.getServiceInterfaceClass()}, (InvocationHandler)callHooksProxy);
        rsr.setServiceInstance(this.createInterceptorChain(rsd.getServiceInterfaceClass(), serviceProxy));
        return rsr;
    }

    private Object createInterceptorChain(Class<?> serviceInterface, Object serviceProxy) {
        Object delegate = serviceProxy;
        for (Class<?> interceptorClass : this.getCallInterceptors(serviceInterface)) {
            delegate = this.createInterceptor(serviceInterface, interceptorClass, delegate);
        }
        return delegate;
    }

    private Object createInterceptor(Class<?> serviceInterface, Class<?> interceptorClass, Object delegate) {
        try {
            if (!serviceInterface.isAssignableFrom(interceptorClass)) {
                throw new RemoteFailure("Could not create call-interceptor class " + interceptorClass.getName() + " because it does not implement " + serviceInterface.getName());
            }
            Constructor<?> constructor = interceptorClass.getConstructor(serviceInterface);
            Object interceptor = constructor.newInstance(delegate);
            return interceptor;
        }
        catch (NoSuchMethodException e) {
            throw new RemoteFailure("Could not create call-interceptor class " + interceptorClass.getName() + " because it does not have a public constructor with a single " + serviceInterface.getName() + " parameter.", e);
        }
        catch (Exception e) {
            throw new RemoteFailure("Could not create call-interceptor class " + interceptorClass.getName(), e);
        }
    }

    private synchronized Iterable<Class<?>> getCallInterceptors(Class<?> serviceInterface) {
        if (!this.callInterceptorsReified) {
            if (this.callInterceptorsRaw == null) {
                this.callInterceptorsRaw = new HashMap();
                ICallInterceptorExtension[] iCallInterceptorExtensionArray = this.callInterceptorExtensions;
                int n = this.callInterceptorExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    ICallInterceptorExtension callInterceptorExtension = iCallInterceptorExtensionArray[n2];
                    List<ICallInterceptorExtension> list = this.callInterceptorsRaw.get(callInterceptorExtension.getServiceInterface());
                    if (list == null) {
                        list = new ArrayList<ICallInterceptorExtension>();
                        this.callInterceptorsRaw.put(callInterceptorExtension.getServiceInterface(), list);
                    }
                    list.add(callInterceptorExtension);
                    ++n2;
                }
            }
            if (this.callInterceptors == null) {
                this.callInterceptors = new HashMap();
            }
            for (Map.Entry<Class<?>, List<ICallInterceptorExtension>> entry : this.callInterceptorsRaw.entrySet()) {
                if (this.callInterceptors.containsKey(entry.getKey())) continue;
                Orderer orderer = new Orderer();
                for (ICallInterceptorExtension extension : entry.getValue()) {
                    orderer.add(extension.getCallInterceptorClass(), extension.getName(), extension.getPreInterceptors(), extension.getPostInterceptors());
                }
                this.callInterceptors.put(entry.getKey(), Iter.ableReverse((List)orderer.getOrderedObjects()));
            }
            this.callInterceptorsReified = true;
        }
        return Iter.able(this.callInterceptors.get(serviceInterface));
    }

    @InjectExtension
    public synchronized void update(ICallInterceptorExtension[] callInterceptorExtensions) {
        this.callInterceptorExtensions = callInterceptorExtensions;
        this.callInterceptors = null;
        this.callInterceptorsRaw = null;
        this.callInterceptorsReified = false;
    }

    private IRemoteServiceReference createLazyProxy(RemoteServiceDescription rsd) {
        Class<?> serviceClass = rsd.getServiceInterfaceClass();
        if (serviceClass == null) {
            LOGGER.log(1, "Could not load service interface class '" + rsd.getServiceInterfaceClassName() + "'.");
            return null;
        }
        LazyProxyHandler lazyProxyHandler = new LazyProxyHandler(rsd);
        Object serviceInstance = Proxy.newProxyInstance(rsd.getServiceClassLoader(), new Class[]{serviceClass}, (InvocationHandler)lazyProxyHandler);
        LazyRemoteServiceReference ref = new LazyRemoteServiceReference(serviceInstance, rsd.getServiceInterfaceClassName(), rsd);
        lazyProxyHandler.setLazyRemoteServiceReference(ref);
        return ref;
    }

    public Class<?> loadClass(String interfaceClassName) throws ClassNotFoundException {
        return this.getClass().getClassLoader().loadClass(interfaceClassName);
    }

    private class LazyProxyHandler
    implements InvocationHandler {
        private InvocationHandler delegateHandler;
        private final RemoteServiceDescription rsd;
        private LazyRemoteServiceReference lazyRemoteServiceReference;

        protected LazyProxyHandler(RemoteServiceDescription rsd) {
            this.rsd = rsd;
        }

        public void setLazyRemoteServiceReference(LazyRemoteServiceReference ref) {
            this.lazyRemoteServiceReference = ref;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.delegateHandler == null) {
                IRemoteServiceReference ref = RemoteServiceFactory.this.createProxy(this.rsd);
                if (ref == null) {
                    throw new RuntimeException("LazyProxy: missing IRemoteServiceFactory to create proxy for protocol=" + this.rsd.getProtocol() + " url=" + this.rsd.getURL() + " interface=" + this.rsd.getServiceInterfaceClassName());
                }
                Object proxyInstance = ref.getServiceInstance();
                this.delegateHandler = Proxy.getInvocationHandler(proxyInstance);
                this.lazyRemoteServiceReference.setDelegateRef(ref);
            }
            return this.delegateHandler.invoke(proxy, method, args);
        }
    }

    private static class LazyRemoteServiceReference
    implements IRemoteServiceReference {
        private final Object serviceInstance;
        private final String serviceClass;
        private IRemoteServiceReference delegateReference;
        private BundleContext tempBundleContext;
        private final RemoteServiceDescription rsd;
        private ServiceRegistration serviceRegistration;

        protected LazyRemoteServiceReference(Object serviceInstance, String serviceClass, RemoteServiceDescription rsd) {
            this.serviceInstance = serviceInstance;
            this.serviceClass = serviceClass;
            this.rsd = rsd;
        }

        private void setDelegateRef(IRemoteServiceReference delegateRef) {
            this.delegateReference = delegateRef;
            if (this.tempBundleContext != null) {
                delegateRef.setContext(this.tempBundleContext);
            }
        }

        @Override
        public void dispose() {
            if (this.delegateReference != null) {
                this.delegateReference.dispose();
            }
        }

        public boolean equals(Object obj) {
            if (this.delegateReference != null) {
                return this.delegateReference.equals(obj);
            }
            return false;
        }

        @Override
        public RemoteServiceDescription getDescription() {
            if (this.delegateReference == null) {
                return this.rsd;
            }
            return this.delegateReference.getDescription();
        }

        @Override
        public BundleContext getContext() {
            if (this.delegateReference == null) {
                return this.tempBundleContext;
            }
            return this.delegateReference.getContext();
        }

        @Override
        public Object getServiceInstance() {
            if (this.delegateReference == null) {
                return this.serviceInstance;
            }
            return this.delegateReference.getServiceInstance();
        }

        @Override
        public String getServiceInterfaceClassName() {
            if (this.delegateReference == null) {
                return this.serviceClass;
            }
            return this.delegateReference.getServiceInterfaceClassName();
        }

        @Override
        public ServiceRegistration getServiceRegistration() {
            return this.serviceRegistration;
        }

        @Override
        public String getURL() {
            if (this.delegateReference != null) {
                return this.delegateReference.getURL();
            }
            return null;
        }

        public int hashCode() {
            if (this.delegateReference != null) {
                return this.delegateReference.hashCode();
            }
            return this.getClass().hashCode();
        }

        @Override
        public void setContext(BundleContext context) {
            if (this.delegateReference == null) {
                this.tempBundleContext = context;
            } else {
                this.delegateReference.setContext(context);
            }
        }

        @Override
        public void setServiceInstance(Object serviceInstance) {
            if (this.delegateReference == null) {
                throw new RuntimeException("trying to set serviceInstance for lazyRemoteServiceReference with no delegate");
            }
            this.delegateReference.setServiceInstance(serviceInstance);
        }

        @Override
        public void setServiceRegistration(ServiceRegistration serviceRegistration) {
            this.serviceRegistration = serviceRegistration;
        }

        public String toString() {
            if (this.delegateReference != null) {
                return this.delegateReference.toString();
            }
            String symbolicName = "no context";
            if (this.tempBundleContext != null) {
                symbolicName = this.tempBundleContext.getBundle().getSymbolicName();
            }
            return "(lazyreference) context for bundle=" + symbolicName + ", end point=(" + this.getDescription() + ")";
        }
    }
}

