/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.hooks;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;

public abstract class AbstractHooksProxy
implements InvocationHandler {
    private final Object proxiedInstance;
    private final AtomicReference<Map<MethodKey, Method>> methodTableRef;

    public AbstractHooksProxy(Object proxiedInstance) {
        this.proxiedInstance = proxiedInstance;
        this.methodTableRef = new AtomicReference();
    }

    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        Subject subject = this.getSubject();
        if (subject == null) {
            return this.invoke(method, args);
        }
        try {
            return Subject.doAsPrivileged(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return AbstractHooksProxy.this.invoke(method, args);
                }
            }, null);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof InvocationTargetException) {
                cause = ((InvocationTargetException)cause).getTargetException();
            }
            throw cause;
        }
    }

    /*
     * Unable to fully structure code
     */
    private Object invoke(Method method, Object[] args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        methodTable = this.methodTableRef.get();
        if (methodTable == null) {
            proxyMethod = method;
        } else {
            proxyMethod = methodTable.get(new MethodKey(method));
            if (proxyMethod == null) {
                throw new NoSuchMethodException(this.proxiedInstance + " " + method.getName() + "," + Arrays.toString(args));
            }
        }
        try {
            return proxyMethod.invoke(this.proxiedInstance, args);
        }
        catch (IllegalArgumentException v0) {
            if (methodTable != null) {
                throw new NoSuchMethodException(this.proxiedInstance + " " + method.getName() + "," + Arrays.toString(args));
            }
            methods = this.proxiedInstance.getClass().getMethods();
            tempMethodTable = new HashMap<MethodKey, Method>(methods.length);
            var10_7 = methods;
            var9_8 = methods.length;
            var8_9 = 0;
            ** while (var8_9 < var9_8)
        }
lbl-1000:
        // 1 sources

        {
            keyMethod = var10_7[var8_9];
            tempMethodTable.put(new MethodKey(keyMethod), keyMethod);
            ++var8_9;
            continue;
        }
lbl24:
        // 1 sources

        this.methodTableRef.compareAndSet(null, tempMethodTable);
        return this.invoke(method, args);
    }

    protected Object getProxiedInstance() {
        return this.proxiedInstance;
    }

    public abstract Subject getSubject();

    private static final class MethodKey {
        private final Method method;
        private final Class<?>[] params;

        public MethodKey(Method method) {
            this.method = method;
            this.params = method.getParameterTypes();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof MethodKey)) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            if (!this.method.getName().equals(other.method.getName())) {
                return false;
            }
            if (!this.method.getReturnType().equals(other.method.getReturnType())) {
                return false;
            }
            if (this.params.length != other.params.length) {
                return false;
            }
            int i = 0;
            while (i < this.params.length) {
                if (this.params[i] != other.params[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public int hashCode() {
            return this.method.getName().hashCode() + 31 * this.params.length;
        }
    }
}

