/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.factory.hessian.serializer;

import com.caucho.hessian.io.AbstractDeserializer;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.AbstractSerializer;
import com.caucho.hessian.io.Deserializer;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.Serializer;
import java.io.IOException;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.riena.communication.core.RemoteFailure;
import org.eclipse.riena.communication.factory.hessian.serializer.AbstractRienaSerializerFactory;

public class XMLGregorianCalendarSerializerFactory
extends AbstractRienaSerializerFactory {
    public Deserializer getDeserializer(Class cl) throws HessianProtocolException {
        if (cl == XMLGregorianCalendar.class) {
            return new XMLGregorianCalendarDeserializer();
        }
        return null;
    }

    public Serializer getSerializer(Class cl) throws HessianProtocolException {
        if (XMLGregorianCalendar.class.isAssignableFrom(cl)) {
            return new XMLGregorianCalendarSerializer();
        }
        return null;
    }

    private static class XMLGregorianCalendarDeserializer
    extends AbstractDeserializer {
        private XMLGregorianCalendarDeserializer() {
        }

        public Object readObject(AbstractHessianInput in) throws IOException {
            boolean valid = in.readBoolean();
            long time = in.readLong();
            GregorianCalendar gregorian = new GregorianCalendar();
            gregorian.setTimeInMillis(time);
            try {
                XMLGregorianCalendar xmlGregorian = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorian);
                if (!valid) {
                    xmlGregorian.clear();
                }
                return xmlGregorian;
            }
            catch (DatatypeConfigurationException e) {
                throw new RemoteFailure("Could not instanciate XMLGegrorianCalendar specific implementation. This may happen if e.g. the SDK defines a different or no implementation of XMLGregorienCalendar", (Throwable)e);
            }
        }
    }

    private static class XMLGregorianCalendarSerializer
    extends AbstractSerializer {
        private XMLGregorianCalendarSerializer() {
        }

        public void writeObject(Object obj, AbstractHessianOutput out) throws IOException {
            if (obj == null) {
                out.writeNull();
                return;
            }
            XMLGregorianCalendar calendar = (XMLGregorianCalendar)obj;
            out.writeBoolean(calendar.isValid());
            out.writeLong(calendar.toGregorianCalendar().getTimeInMillis());
        }
    }
}

