/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonFactory;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.ridgets.AbstractMasterDetailsDelegate;
import org.eclipse.riena.ui.ridgets.IMasterDetailsDelegate;
import org.eclipse.riena.ui.ridgets.IMasterDetailsRidget;
import org.eclipse.riena.ui.ridgets.IMultipleChoiceRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.ISingleChoiceRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.validation.NotEmpty;

public class MasterDetailsSubModuleController3
extends SubModuleController {
    private final List<Person> input = PersonFactory.createPersonList();

    public void configureRidgets() {
        String[] properties = new String[]{"firstname", "lastname"};
        String[] headers = new String[]{"First Name", "Last Name"};
        IMasterDetailsRidget master3 = (IMasterDetailsRidget)this.getRidget(IMasterDetailsRidget.class, "master3");
        master3.setDelegate((IMasterDetailsDelegate)new PersonDelegate());
        master3.bindToModel((IObservableList)new WritableList(this.input, Person.class), Person.class, properties, headers);
        master3.updateFromModel();
        master3.setDirectWriting(true);
    }

    private static final class PersonDelegate
    extends AbstractMasterDetailsDelegate {
        private static final String[] GENDER = new String[]{"female", "male"};
        private final Person workingCopy = this.createWorkingCopy();

        private PersonDelegate() {
        }

        public void configureRidgets(IRidgetContainer container) {
            IMultipleChoiceRidget pets;
            ITextRidget txtFirst = (ITextRidget)container.getRidget(ITextRidget.class, "first");
            txtFirst.setMandatory(true);
            txtFirst.setDirectWriting(true);
            txtFirst.bindToModel((Object)this.workingCopy, "firstname");
            txtFirst.updateFromModel();
            ITextRidget txtLast = (ITextRidget)container.getRidget(ITextRidget.class, "last");
            txtLast.setMandatory(true);
            txtLast.setDirectWriting(true);
            txtLast.addValidationRule((IValidator)new NotEmpty(), ValidationTime.ON_UI_CONTROL_EDIT);
            txtLast.bindToModel((Object)this.workingCopy, "lastname");
            txtLast.updateFromModel();
            ISingleChoiceRidget gender = (ISingleChoiceRidget)container.getRidget(ISingleChoiceRidget.class, "gender");
            if (gender != null) {
                gender.bindToModel(Arrays.asList(GENDER), null, (Object)this.workingCopy, "gender");
                gender.updateFromModel();
            }
            if ((pets = (IMultipleChoiceRidget)container.getRidget(IMultipleChoiceRidget.class, "pets")) != null) {
                pets.bindToModel(Arrays.asList(Person.Pets.values()), null, (Object)this.workingCopy, "pets");
                pets.updateFromModel();
            }
        }

        public Person createWorkingCopy() {
            return new Person("", "");
        }

        public Person copyBean(Object source, Object target) {
            Person from = (Person)source;
            Person to = (Person)target;
            to.setFirstname(from.getFirstname());
            to.setLastname(from.getLastname());
            to.setGender(from.getGender());
            to.setPets(from.getPets());
            return to;
        }

        public Object getWorkingCopy() {
            return this.workingCopy;
        }

        public boolean isChanged(Object source, Object target) {
            Person p1 = (Person)source;
            Person p2 = (Person)target;
            boolean equals = p1.getFirstname().equals(p2.getFirstname()) && p1.getLastname().equals(p2.getLastname()) && p1.getGender().equals(p2.getGender()) && p1.getPets().equals(p2.getPets());
            return !equals;
        }

        public String isValid(IRidgetContainer container) {
            ITextRidget txtLast = (ITextRidget)container.getRidget(ITextRidget.class, "last");
            if (txtLast.isErrorMarked()) {
                return "'Last Name' is not valid.";
            }
            return null;
        }
    }
}

