/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.singleton.SessionSingletonProvider;
import org.eclipse.riena.core.singleton.SingletonProvider;
import org.eclipse.riena.core.util.FileUtils;
import org.eclipse.riena.core.util.ReflectionFailure;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.navigation.ui.swt.Activator;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.ImageFileExtension;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;

public class ImageReplacer {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), ImageReplacer.class);
    private static final SingletonProvider<ImageReplacer> IR = new SessionSingletonProvider(ImageReplacer.class);
    private final Class<? extends ImageDescriptor> fileImageDescriptorClass;
    private final Class<? extends ImageDescriptor> urlImageDescriptorClass;

    protected ImageReplacer() {
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromFile(this.getClass(), (String)"");
        this.fileImageDescriptorClass = imageDescriptor.getClass();
        Class<?> imageDescriptorClass = null;
        try {
            URL url = new URL("file", "", "");
            imageDescriptor = ImageDescriptor.createFromURL((URL)url);
            imageDescriptorClass = imageDescriptor.getClass();
        }
        catch (MalformedURLException ex) {
            LOGGER.log(1, "Can't create ImageDescriptor for URL.", (Throwable)ex);
        }
        this.urlImageDescriptorClass = imageDescriptorClass;
    }

    public static ImageReplacer getInstance() {
        return (ImageReplacer)IR.getInstance();
    }

    private boolean isImageDescriptorSupported(ImageDescriptor imageDescriptor) {
        if (imageDescriptor != null) {
            if (imageDescriptor.getClass() == this.urlImageDescriptorClass) {
                return true;
            }
            if (imageDescriptor.getClass() == this.fileImageDescriptorClass) {
                return true;
            }
        }
        return false;
    }

    public void replaceImagesOfManager(IContributionManager contributionManager) {
        if (contributionManager != null) {
            IContributionItem[] items;
            IContributionItem[] iContributionItemArray = items = contributionManager.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                if (item instanceof IToolBarContributionItem) {
                    this.replaceImagesOfManager((IContributionManager)((IToolBarContributionItem)item).getToolBarManager());
                } else if (item instanceof IMenuManager) {
                    this.replaceImagesOfManager((IContributionManager)((IMenuManager)item));
                } else {
                    this.replaceImages(contributionManager, item);
                }
                ++n2;
            }
        }
    }

    protected void replaceImages(IContributionManager contributionManager, IContributionItem item) {
        if (item instanceof CommandContributionItem) {
            CommandContributionItem commandItem = (CommandContributionItem)item;
            CommandContributionItemParameter itemParamter = commandItem.getData();
            itemParamter.commandId = commandItem.getCommand().getId();
            contributionManager.remove(item);
            if (this.replaceImages(itemParamter)) {
                contributionManager.add((IContributionItem)new CommandContributionItem(itemParamter));
            } else {
                contributionManager.add(item);
            }
        }
    }

    private boolean replaceImages(CommandContributionItemParameter itemParamter) {
        ImageDescriptor scaledImage;
        boolean replaced = false;
        if (itemParamter.icon != null && (scaledImage = this.getScaledImage(itemParamter.icon)) != null && !itemParamter.icon.equals(scaledImage)) {
            replaced = true;
            itemParamter.icon = scaledImage;
        }
        if (itemParamter.disabledIcon != null && (scaledImage = this.getScaledImage(itemParamter.disabledIcon)) != null && !itemParamter.disabledIcon.equals(scaledImage)) {
            replaced = true;
            itemParamter.disabledIcon = scaledImage;
        }
        if (itemParamter.hoverIcon != null && (scaledImage = this.getScaledImage(itemParamter.hoverIcon)) != null && !itemParamter.hoverIcon.equals(scaledImage)) {
            replaced = true;
            itemParamter.hoverIcon = scaledImage;
        }
        return replaced;
    }

    private ImageDescriptor getScaledImage(ImageDescriptor image) {
        if (image == null) {
            return null;
        }
        if (this.isImageDescriptorSupported(image)) {
            String filePath;
            block6: {
                try {
                    filePath = (String)ReflectionUtils.invokeHidden((Object)image, (String)"getFilePath", (Object[])new Object[0]);
                    if (!StringUtils.isEmpty((CharSequence)filePath)) break block6;
                    return null;
                }
                catch (ReflectionFailure reflectionFailure) {
                    return null;
                }
            }
            String imageName = this.getImageName(filePath);
            ImageFileExtension imageFileExtension = null;
            String fileNameExtension = FileUtils.getFileExtension((String)filePath);
            imageFileExtension = ImageFileExtension.getImageFileExtension((String)fileNameExtension);
            if (imageFileExtension == null) {
                imageFileExtension = ImageFileExtension.PNG;
            }
            return ImageStore.getInstance().getImageDescriptor(imageName, imageFileExtension);
        }
        return null;
    }

    private String getImageName(String fullName) {
        String suffix;
        if (StringUtils.isEmpty((CharSequence)fullName)) {
            return fullName;
        }
        String imageName = FileUtils.getNameWithoutExtension((String)fullName);
        if (LnfManager.isLnfCreated() && !StringUtils.isEmpty((CharSequence)(suffix = LnfManager.getLnf().getIconScaleSuffix(null))) && imageName.endsWith(suffix)) {
            imageName = imageName.substring(0, imageName.length() - suffix.length());
        }
        return imageName;
    }

    public String getImageName(URI imageUrl) {
        if (imageUrl == null) {
            return null;
        }
        String fullName = imageUrl.getPath();
        return this.getImageName(fullName);
    }
}

