/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface OnNavigationNodeEvent {
    public Event event();

    public static enum Event {
        BEFORE_ACTIVATED,
        AFTER_ACTIVATED,
        LABEL_CHANGED,
        ICON_CHANGED,
        SELECTED_CHANGED,
        CHILD_ADDED,
        CHILD_REMOVED,
        PRESENTATION_CHANGED,
        PARENT_CHANGED,
        EXPANDED_CHANGED,
        MARKER_CHANGED,
        ACTIVATED,
        DEACTIVATED,
        BEFORE_DECTIVATED,
        AFTER_DECTIVATED,
        DISPOSED,
        BEFORE_DISPOSED,
        AFTER_DISPOSED,
        STATE_CHANGED,
        BLOCK,
        FILTER_ADDED,
        FILTER_REMOVED,
        PREPARED,
        NODE_ID_CHANGED;

        private final String methodName;

        private Event() {
            this.methodName = this.toCamelCase(this.toString());
        }

        private Event(String methodName) {
            this.methodName = methodName;
        }

        private String toCamelCase(String string) {
            StringBuilder bob = new StringBuilder(string.length());
            boolean nextUp = false;
            int i = 0;
            while (i < string.length()) {
                char c = string.charAt(i);
                if (nextUp) {
                    bob.append(c);
                } else if (c != '_') {
                    bob.append(Character.toLowerCase(c));
                }
                nextUp = c == '_';
                ++i;
            }
            return bob.toString();
        }

        public String getMethodName() {
            return this.methodName;
        }
    }
}

