/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.marker;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.ui.core.marker.IMessageMarker;
import org.eclipse.riena.ui.core.marker.MessageMarker;
import org.eclipse.riena.ui.ridgets.marker.ValidationMessageMarker;

@NonUITestCase
public class ValidationMessageMarkerTest
extends RienaTestCase {
    private final IValidator validationRule = new IValidator(){

        public IStatus validate(Object value) {
            return Status.OK_STATUS;
        }
    };

    public void testConstructorWithNullMessageMarker() {
        try {
            new ValidationMessageMarker(null);
            ValidationMessageMarkerTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            new ValidationMessageMarker(null, this.validationRule);
            ValidationMessageMarkerTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testGetMessage() {
        ValidationMessageMarker result1 = new ValidationMessageMarker((IMessageMarker)new MessageMarker("msg"));
        ValidationMessageMarkerTest.assertEquals((String)"msg", (String)result1.getMessage());
        ValidationMessageMarker result2 = new ValidationMessageMarker((IMessageMarker)new MessageMarker());
        ValidationMessageMarkerTest.assertEquals((String)"", (String)result2.getMessage());
    }

    public void testGetRule() {
        ValidationMessageMarker result1 = new ValidationMessageMarker((IMessageMarker)new MessageMarker("msg"), this.validationRule);
        ValidationMessageMarkerTest.assertSame((Object)this.validationRule, (Object)result1.getValidationRule());
        ValidationMessageMarker result2 = new ValidationMessageMarker((IMessageMarker)new MessageMarker("msg"), null);
        ValidationMessageMarkerTest.assertNull((Object)result2.getValidationRule());
    }

    public void testEquals() {
        ValidationMessageMarker result1a = new ValidationMessageMarker((IMessageMarker)new MessageMarker("1"), this.validationRule);
        ValidationMessageMarker result1b = new ValidationMessageMarker((IMessageMarker)new MessageMarker("1"), this.validationRule);
        ValidationMessageMarker result1c = new ValidationMessageMarker((IMessageMarker)new MessageMarker("1"), this.validationRule);
        ValidationMessageMarker result2a = new ValidationMessageMarker((IMessageMarker)new MessageMarker("2"));
        ValidationMessageMarker result2b = new ValidationMessageMarker((IMessageMarker)new MessageMarker("2"));
        ValidationMessageMarkerTest.assertTrue((boolean)result1a.equals((Object)result1a));
        ValidationMessageMarkerTest.assertTrue((boolean)result1a.equals((Object)result1b));
        ValidationMessageMarkerTest.assertTrue((boolean)result1b.equals((Object)result1a));
        ValidationMessageMarkerTest.assertTrue((boolean)result1b.equals((Object)result1c));
        ValidationMessageMarkerTest.assertTrue((boolean)result1a.equals((Object)result1c));
        ValidationMessageMarkerTest.assertTrue((boolean)result2a.equals((Object)result2a));
        ValidationMessageMarkerTest.assertTrue((boolean)result2a.equals((Object)result2b));
        ValidationMessageMarkerTest.assertTrue((boolean)result2b.equals((Object)result2a));
        ValidationMessageMarkerTest.assertFalse((boolean)result1a.equals(null));
        ValidationMessageMarkerTest.assertFalse((boolean)result1a.equals(new Object()));
        ValidationMessageMarkerTest.assertFalse((boolean)result1a.equals((Object)result2a));
        ValidationMessageMarkerTest.assertFalse((boolean)result2a.equals((Object)result1a));
    }

    public void testHashCodeEqual() {
        ValidationMessageMarker result1a = new ValidationMessageMarker((IMessageMarker)new MessageMarker("1"), this.validationRule);
        ValidationMessageMarker result1b = new ValidationMessageMarker((IMessageMarker)new MessageMarker("1"), this.validationRule);
        int hash1 = result1a.hashCode();
        ValidationMessageMarkerTest.assertEquals((int)hash1, (int)result1a.hashCode());
        ValidationMessageMarkerTest.assertTrue((boolean)result1a.equals((Object)result1b));
        ValidationMessageMarkerTest.assertEquals((int)hash1, (int)result1b.hashCode());
    }

    public void testHashCodeNotEqual() {
        ValidationMessageMarker result1 = new ValidationMessageMarker((IMessageMarker)new MessageMarker("1"), this.validationRule);
        ValidationMessageMarker result2 = new ValidationMessageMarker((IMessageMarker)new MessageMarker("2"), this.validationRule);
        ValidationMessageMarker result3 = new ValidationMessageMarker((IMessageMarker)new MessageMarker("1"));
        ValidationMessageMarkerTest.assertFalse((result1.hashCode() == result2.hashCode() ? 1 : 0) != 0);
        ValidationMessageMarkerTest.assertFalse((result1.hashCode() == result3.hashCode() ? 1 : 0) != 0);
        ValidationMessageMarkerTest.assertFalse((result2.hashCode() == result3.hashCode() ? 1 : 0) != 0);
    }
}

