/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractChoiceRidget;
import org.eclipse.riena.ui.ridgets.IElementComparer;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ISingleChoiceRidget;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.listener.SelectionEvent;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.swt.ChoiceComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class SingleChoiceRidget
extends AbstractChoiceRidget
implements ISingleChoiceRidget {
    private final WritableValue selectionObservable = new WritableValue();
    private Binding optionsBinding;
    private Binding selectionBinding;
    private Object emptySelectionItem;
    private ListenerList<ISelectionListener> selectionListeners;
    private IElementComparer comparer;

    public SingleChoiceRidget() {
        this.selectionObservable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                SingleChoiceRidget.this.disableMandatoryMarkers(SingleChoiceRidget.this.hasMandatoryInput());
            }
        });
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SingleChoiceRidget.this.updateSelection(SingleChoiceRidget.this.getUIControl());
            }
        });
        this.addPropertyChangeListener("output", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean isOutput = (Boolean)evt.getNewValue();
                SingleChoiceRidget.this.updateEditable(SingleChoiceRidget.this.getUIControl(), !isOutput);
            }
        });
    }

    @Override
    protected void bindUIControl() {
        if (this.optionsBinding != null) {
            this.createChildren(this.getUIControl());
        }
    }

    @Override
    protected void checkUIControl(Object uiControl) {
        this.checkType(uiControl, ChoiceComposite.class);
        if (uiControl != null) {
            ChoiceComposite composite = (ChoiceComposite)uiControl;
            Assert.isTrue((!composite.isMultipleSelection() ? 1 : 0) != 0, (String)"expected single selection ChoiceComposite");
        }
    }

    @Override
    protected void unbindUIControl() {
        super.unbindUIControl();
        this.disposeChildren(this.getUIControl());
    }

    public ChoiceComposite getUIControl() {
        return (ChoiceComposite)super.getUIControl();
    }

    public void bindToModel(IObservableList optionValues, IObservableValue selectionValue) {
        Assert.isNotNull((Object)optionValues, (String)"optionValues");
        Assert.isNotNull((Object)selectionValue, (String)"selectionValue");
        this.bindToModel(optionValues, null, selectionValue);
    }

    public void bindToModel(Object listHolder, String listPropertyName, Object selectionHolder, String selectionPropertyName) {
        Assert.isNotNull((Object)listHolder, (String)"listHolder");
        Assert.isNotNull((Object)listPropertyName, (String)"listPropertyName");
        Assert.isNotNull((Object)selectionHolder, (String)"selectionHolder");
        Assert.isNotNull((Object)selectionPropertyName, (String)"selectionPropertyName");
        IObservableList optionValues = AbstractSWTRidget.isBean(listHolder.getClass()) ? BeansObservables.observeList((Object)listHolder, (String)listPropertyName) : PojoObservables.observeList((Object)listHolder, (String)listPropertyName);
        IObservableValue selectionValue = AbstractSWTRidget.isBean(selectionHolder.getClass()) ? BeansObservables.observeValue((Object)selectionHolder, (String)selectionPropertyName) : PojoObservables.observeValue((Object)selectionHolder, (String)selectionPropertyName);
        this.bindToModel(optionValues, null, selectionValue);
    }

    public void bindToModel(List<? extends Object> optionValues, List<String> optionLabels, Object selectionHolder, String selectionPropertyName) {
        Assert.isNotNull(optionValues, (String)"optionValues");
        Assert.isNotNull((Object)selectionHolder, (String)"selectionHolder");
        Assert.isNotNull((Object)selectionPropertyName, (String)"selectionPropertyName");
        WritableList list = new WritableList(optionValues, null);
        IObservableValue selectionValue = AbstractSWTRidget.isBean(selectionHolder.getClass()) ? BeansObservables.observeValue((Object)selectionHolder, (String)selectionPropertyName) : PojoObservables.observeValue((Object)selectionHolder, (String)selectionPropertyName);
        this.bindToModel((IObservableList)list, optionLabels, selectionValue);
    }

    public void setComparer(IElementComparer comparer) {
        this.comparer = comparer;
    }

    public IElementComparer getComparer() {
        return this.comparer;
    }

    protected boolean isElementContained(Object element, Collection<?> collection) {
        if (this.getComparer() == null) {
            return collection.contains(element);
        }
        Iterator<?> i = collection.iterator();
        while (i.hasNext()) {
            if (!this.areElementsEqual(element, i.next())) continue;
            return true;
        }
        return false;
    }

    protected boolean areElementsEqual(Object element1, Object element2) {
        if (this.getComparer() != null) {
            return this.getComparer().equals(element1, element2);
        }
        return element1 != null && element1.equals(element2) || element1 == null && element2 == null;
    }

    public void updateFromModel() {
        this.assertIsBoundToModel();
        super.updateFromModel();
        this.optionsBinding.updateModelToTarget();
        Object oldSelection = this.selectionObservable.getValue();
        this.selectionBinding.updateModelToTarget();
        this.layoutNewChildren();
        Object newSelection = oldSelection;
        if (newSelection != null && !this.isElementContained(newSelection, (Collection<?>)this.optionsObservable)) {
            this.selectionObservable.setValue(null);
            newSelection = null;
        }
        this.firePropertyChange("selection", oldSelection, newSelection);
    }

    public Object getSelection() {
        return this.selectionObservable.getValue();
    }

    public void setSelection(Object candidate) {
        this.assertIsBoundToModel();
        if (candidate != null && !this.isElementContained(candidate, (Collection<?>)this.optionsObservable)) {
            throw new BindingException("candidate not in option list: " + candidate);
        }
        Object oldSelection = this.selectionObservable.getValue();
        this.selectionObservable.setValue(candidate);
        this.updateSelection(this.getUIControl());
        this.firePropertyChange("selection", oldSelection, candidate);
    }

    public Object getEmptySelectionItem() {
        return this.emptySelectionItem;
    }

    public void setEmptySelectionItem(Object emptySelectionItem) {
        this.emptySelectionItem = emptySelectionItem;
    }

    public IObservableList getObservableList() {
        return this.optionsObservable;
    }

    @Override
    public final boolean isDisableMandatoryMarker() {
        return this.hasMandatoryInput();
    }

    public void addSelectionListener(ISelectionListener selectionListener) {
        Assert.isNotNull((Object)selectionListener, (String)"selectionListener is null");
        if (this.selectionListeners == null) {
            this.selectionListeners = new ListenerList(ISelectionListener.class);
            this.addPropertyChangeListener("selection", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SingleChoiceRidget.this.notifySelectionListeners(Arrays.asList(evt.getOldValue()), Arrays.asList(evt.getNewValue()));
                }
            });
        }
        this.selectionListeners.add((Object)selectionListener);
    }

    public void removeSelectionListener(ISelectionListener selectionListener) {
        if (this.selectionListeners != null) {
            this.selectionListeners.remove((Object)selectionListener);
        }
    }

    private void assertIsBoundToModel() {
        if (this.optionsBinding == null || this.selectionBinding == null) {
            throw new BindingException("ridget not bound to model");
        }
    }

    private void bindToModel(IObservableList optionValues, List<String> optionLabels, IObservableValue selectionValue) {
        if (optionLabels != null) {
            Assert.isLegal((optionValues.size() == optionLabels.size() ? 1 : 0) != 0, (String)"Mismatch between number of optionValues and optionLabels");
        }
        this.unbindUIControl();
        if (this.optionsBinding != null) {
            this.optionsBinding.dispose();
            this.optionsBinding = null;
            this.optionsObservable.clear();
        }
        if (this.selectionBinding != null) {
            this.selectionBinding.dispose();
            this.selectionBinding = null;
            this.selectionObservable.setValue(null);
        }
        DataBindingContext dbc = new DataBindingContext();
        this.optionsBinding = dbc.bindList((IObservableList)this.optionsObservable, optionValues, new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE), new UpdateListStrategy(UpdateListStrategy.POLICY_ON_REQUEST));
        this.selectionBinding = dbc.bindValue((IObservableValue)this.selectionObservable, selectionValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        this.optionLabels = optionLabels != null ? optionLabels.toArray(new String[optionLabels.size()]) : null;
        this.bindUIControl();
    }

    @Override
    protected void configureOptionButton(Button button) {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
                Button button = (Button)e.widget;
                Object data = button.getData();
                if (button.getSelection() && !SingleChoiceRidget.this.isOutputOnly()) {
                    SingleChoiceRidget.this.setSelection(data);
                    if (!button.isDisposed()) {
                        SingleChoiceRidget.this.fireFocusIn((Control)button.getParent());
                    }
                }
            }
        };
        button.addSelectionListener((SelectionListener)listener);
        button.setData("choiceRidget.listener", (Object)listener);
    }

    @Override
    protected void unconfigureOptionButton(Button button) {
        Object data = button.getData("choiceRidget.listener");
        if (data instanceof SelectionListener) {
            button.removeSelectionListener((SelectionListener)data);
        }
        button.setData("choiceRidget.listener", null);
    }

    private void fireFocusIn(Control control) {
        Event event = new Event();
        event.type = 15;
        event.widget = control;
        control.notifyListeners(15, event);
    }

    private boolean hasInput() {
        return this.getSelection() != null;
    }

    private boolean hasMandatoryInput() {
        return this.hasInput() && (this.emptySelectionItem == null || !this.emptySelectionItem.equals(this.getSelection()));
    }

    private void updateEditable(ChoiceComposite control, boolean isEditable) {
        if (control != null && !control.isDisposed()) {
            control.setEditable(isEditable);
        }
    }

    @Override
    protected void updateSelection(ChoiceComposite control) {
        boolean canSelect;
        boolean bl = canSelect = this.isEnabled() || !MarkerSupport.isHideDisabledRidgetContent();
        if (control != null && !control.isDisposed()) {
            Object value = this.selectionObservable.getValue();
            Control[] controlArray = control.getChildrenButtons();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                Button button = (Button)child;
                boolean isSelected = canSelect && this.areElementsEqual(value, child.getData());
                button.setSelection(isSelected);
                ++n2;
            }
        }
        this.updateEditable(control, !this.isOutputOnly());
    }

    private void notifySelectionListeners(List<?> oldSelectionList, List<?> newSelectionList) {
        if (this.selectionListeners != null) {
            SelectionEvent event = new SelectionEvent((IRidget)this, oldSelectionList, newSelectionList);
            ISelectionListener[] iSelectionListenerArray = (ISelectionListener[])this.selectionListeners.getListeners();
            int n = iSelectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISelectionListener listener = iSelectionListenerArray[n2];
                listener.ridgetSelected(event);
                ++n2;
            }
        }
    }
}

