/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.separator;

import java.beans.Beans;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.separator.SeparatorDescriptor;
import org.eclipse.riena.ui.swt.separator.SeparatorLineRenderer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class Separator
extends Canvas {
    private final SeparatorDescriptor descriptor;

    protected Separator(Composite parent, ORIENTATION orientation, int style, Color firstLineColor, Color secondLineColor) {
        super(parent, style | 0x10);
        Color firstLine = firstLineColor == null ? this.getDisplay().getSystemColor(1) : firstLineColor;
        this.descriptor = new SeparatorDescriptor(orientation, secondLineColor == null ? 1 : 2, firstLine, secondLineColor);
        this.addPaintListener(new Painter());
    }

    public Separator(Composite parent, int style, Color firstLineColor, Color secondLineColor) {
        this(parent, (style & 0x100) > 0 ? ORIENTATION.HORIZONTAL : ORIENTATION.VERTICAL, style & 0xFFFFFCFF, firstLineColor, secondLineColor);
    }

    public Separator(Composite parent, int style, Color lineColor) {
        this(parent, style, lineColor, null);
    }

    public Separator(Composite parent, int style) {
        this(parent, style, Beans.isDesignTime() ? Display.getDefault().getSystemColor(2) : LnfManager.getLnf().getColor("titlebar.separator.firstline.color"), Beans.isDesignTime() ? Display.getDefault().getSystemColor(2) : LnfManager.getLnf().getColor("titlebar.separator.secondtline.color"));
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (ORIENTATION.HORIZONTAL.equals((Object)this.descriptor.getOrientation())) {
            return super.computeSize(wHint, this.descriptor.getLines(), changed);
        }
        return super.computeSize(this.descriptor.getLines(), hHint, changed);
    }

    public static enum ORIENTATION {
        VERTICAL,
        HORIZONTAL;

    }

    private class Painter
    implements PaintListener {
        private Painter() {
        }

        public void paintControl(PaintEvent e) {
            Separator.this.setBackground(Separator.this.getParent().getBackground());
            SeparatorLineRenderer separatorLineRenderer = this.getSeparatorLineRenderer();
            separatorLineRenderer.setDescriptor(Separator.this.descriptor);
            separatorLineRenderer.setBounds(Separator.this.getBounds());
            separatorLineRenderer.paint(e.gc, (Object)Separator.this);
        }

        private SeparatorLineRenderer getSeparatorLineRenderer() {
            return new SeparatorLineRenderer();
        }
    }
}

