/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.util.Util;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.ui.swt.utils.RcpUtilities;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class ShellHelper {
    private static final Logger LOGGER = Log4r.getLogger(ShellHelper.class);
    private Rectangle restoreBounds;

    public void maximizeRestore() {
        this.maximizeRestore(RcpUtilities.getWorkbenchShell());
    }

    public void maximizeRestore(Shell shell) {
        if (shell == null) {
            LOGGER.log(2, "No shell of the application found! Maximize/restore of shell canceled.");
            return;
        }
        if (ShellHelper.isTitleless(shell)) {
            if (ShellHelper.isMaximzed(shell)) {
                if (this.restoreBounds != null) {
                    shell.setBounds(this.restoreBounds);
                    shell.redraw(this.restoreBounds.x, this.restoreBounds.y, this.restoreBounds.width, this.restoreBounds.height, true);
                } else {
                    LOGGER.log(2, "No restore bounds exists! Restore of shell canceled.");
                }
            } else {
                this.restoreBounds = shell.getBounds();
                Rectangle clientBounds = ShellHelper.calcMaxBounds(shell);
                shell.setBounds(clientBounds);
                shell.redraw(clientBounds.x, clientBounds.y, clientBounds.width, clientBounds.height, true);
            }
        } else {
            shell.setMaximized(shell.getMaximized());
        }
    }

    public static Rectangle calcMaxBounds(Shell shell) {
        Rectangle clientBounds = shell.getMonitor().getClientArea();
        Rectangle newBounds = new Rectangle(clientBounds.x, clientBounds.y, clientBounds.width, clientBounds.height);
        if (ShellHelper.isTaskbarHidden(shell)) {
            ++newBounds.x;
            ++newBounds.y;
            newBounds.width -= 2;
            newBounds.height -= 2;
        }
        return newBounds;
    }

    private static boolean isTaskbarHidden(Shell shell) {
        if (!Util.isWindows()) {
            return false;
        }
        Rectangle clientBounds = shell.getMonitor().getClientArea();
        Rectangle monitorBounds = shell.getMonitor().getBounds();
        return clientBounds.equals((Object)monitorBounds);
    }

    @Deprecated
    public static boolean isShellMaximzed() {
        Shell shell = RcpUtilities.getWorkbenchShell();
        if (shell == null) {
            LOGGER.log(2, "No shell of the application found!");
            return false;
        }
        return ShellHelper.isMaximzed(shell);
    }

    public static boolean isMaximzed(Shell shell) {
        if (shell == null || shell.isDisposed()) {
            LOGGER.log(2, "shell equals null or is disposed!");
            return false;
        }
        if (ShellHelper.isTitleless(shell)) {
            Rectangle clientBounds = shell.getMonitor().getClientArea();
            if (clientBounds.equals((Object)shell.getBounds())) {
                return true;
            }
            clientBounds = ShellHelper.calcMaxBounds(shell);
            return clientBounds.equals((Object)shell.getBounds());
        }
        return shell.getMaximized();
    }

    private static boolean isTitleless(Shell shell) {
        if (shell == null || shell.isDisposed()) {
            LOGGER.log(2, "shell equals null or is disposed!");
            return false;
        }
        int style = shell.getStyle();
        return (style & 8) == 8;
    }

    public static void center(Shell shell) {
        if (shell != null) {
            Rectangle surroundingBounds = ShellHelper.getSurroundingBounds(shell);
            Rectangle shellBounds = shell.getBounds();
            int leftMargin = surroundingBounds.x + (surroundingBounds.width - shellBounds.width) / 2;
            int topMargin = surroundingBounds.y + (surroundingBounds.height - shellBounds.height) / 2;
            shell.setLocation(leftMargin, topMargin);
        }
    }

    private static Rectangle getSurroundingBounds(Shell shell) {
        return shell.getParent() != null ? shell.getParent().getBounds() : ShellHelper.getClosestMonitor(shell.getDisplay(), shell.getLocation()).getBounds();
    }

    public static Monitor getClosestMonitor(Shell shell) {
        return ShellHelper.getClosestMonitor(shell.getDisplay(), shell.getLocation());
    }

    private static Monitor getClosestMonitor(Display toSearch, Point toFind) {
        int closest = Integer.MAX_VALUE;
        Monitor result = toSearch.getPrimaryMonitor();
        Monitor[] monitorArray = toSearch.getMonitors();
        int n = monitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor current = monitorArray[n2];
            Rectangle clientArea = current.getBounds();
            if (clientArea.contains(toFind)) {
                return current;
            }
            int distance = Geometry.distanceSquared((Point)Geometry.centerPoint((Rectangle)clientArea), (Point)toFind);
            if (distance < closest) {
                closest = distance;
                result = current;
            }
            ++n2;
        }
        return result;
    }
}

