/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.injector.service;

import org.eclipse.riena.core.injector.service.ServiceDescriptor;
import org.eclipse.riena.core.injector.service.ServiceInjector;
import org.osgi.framework.ServiceReference;

public class RankingInjector
extends ServiceInjector {
    private ServiceReference trackedServiceRef = null;

    RankingInjector(ServiceDescriptor serviceId, Object target) {
        super(serviceId, target);
    }

    @Override
    protected void doStart() {
        ServiceReference serviceRef = this.getCurrentHighest();
        this.doBind(serviceRef);
    }

    @Override
    protected void doStop() {
        this.invokeUnbindMethod(this.trackedServiceRef);
        this.trackedServiceRef = null;
    }

    @Override
    protected void doBind(ServiceReference serviceRef) {
        if (serviceRef == null) {
            return;
        }
        ServiceReference tempRef = this.trackedServiceRef;
        if (tempRef != null && serviceRef.compareTo((Object)tempRef) < 0) {
            return;
        }
        this.invokeUnbindMethod(this.trackedServiceRef);
        this.invokeBindMethod(serviceRef);
        this.trackedServiceRef = serviceRef;
    }

    @Override
    protected void doUnbind(ServiceReference serviceRef) {
        if (serviceRef == null) {
            return;
        }
        ServiceReference tempRef = this.trackedServiceRef;
        if (tempRef != null && serviceRef.compareTo((Object)tempRef) != 0) {
            return;
        }
        this.invokeUnbindMethod(serviceRef);
        ServiceReference highest = this.getCurrentHighest();
        if (highest == null) {
            this.trackedServiceRef = null;
            return;
        }
        this.invokeBindMethod(highest);
        this.trackedServiceRef = highest;
    }

    private ServiceReference getCurrentHighest() {
        ServiceReference[] serviceRefs = this.getServiceReferences();
        return RankingInjector.highestServiceRef(serviceRefs);
    }

    private static ServiceReference highestServiceRef(ServiceReference[] serviceRefs) {
        if (serviceRefs == null || serviceRefs.length == 0) {
            return null;
        }
        if (serviceRefs.length == 1) {
            return serviceRefs[0];
        }
        ServiceReference highest = serviceRefs[0];
        int i = 1;
        while (i < serviceRefs.length) {
            if (serviceRefs[i].compareTo((Object)highest) > 0) {
                highest = serviceRefs[i];
            }
            ++i;
        }
        return highest;
    }
}

