/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.application;

import java.security.Permissions;
import java.security.Principal;
import javax.security.auth.Subject;
import org.eclipse.riena.core.service.Service;
import org.eclipse.riena.example.client.application.ExampleActionBarAdvisor;
import org.eclipse.riena.internal.example.client.Activator;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.ui.controllers.ApplicationController;
import org.eclipse.riena.navigation.ui.swt.application.SwtApplication;
import org.eclipse.riena.security.common.ISubjectHolder;
import org.eclipse.riena.security.common.authorization.IPermissionCache;
import org.eclipse.riena.ui.ridgets.IStatuslineRidget;
import org.eclipse.riena.ui.workarea.WorkareaManager;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class SwtExampleApplication
extends SwtApplication {
    protected ApplicationController createApplicationController(IApplicationNode node) {
        ApplicationController controller = super.createApplicationController(node);
        controller.setMenubarVisible(true);
        return controller;
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ExampleActionBarAdvisor(configurer);
    }

    protected void initializeUI() {
        super.initializeUI();
        this.configure();
    }

    public void configure() {
        this.setDummyPermissions();
    }

    private void setDummyPermissions() {
        ISubjectHolder subjectHolder = (ISubjectHolder)Service.get(ISubjectHolder.class);
        IPermissionCache pmCache = (IPermissionCache)Service.get(IPermissionCache.class);
        Subject subject = new Subject();
        Principal principal = new Principal(){

            @Override
            public String getName() {
                return "DummyPrincipal";
            }
        };
        subject.getPrincipals().add(principal);
        subjectHolder.setSubject(subject);
        Permissions p = new Permissions();
        p.add(new RuntimePermission("navi", "newx"));
        pmCache.putPermissions(principal, p);
    }

    public IApplicationNode createModel() {
        SubApplicationNode subApplication = null;
        String bundleVersion = (String)Activator.getDefault().getBundle().getHeaders().get("Bundle-Version");
        ApplicationNode applicationNode = new ApplicationNode(new NavigationNodeId("application"), "Example & Playground - " + bundleVersion);
        applicationNode.setIcon("0457_a_a00.png");
        applicationNode.create(new NavigationNodeId("org.eclipse.riena.example.navigation.subapplication"));
        applicationNode.create(new NavigationNodeId("org.eclipse.riena.example.navigate.form"));
        subApplication = new SubApplicationNode(new NavigationNodeId("playground"), "Pla&yground");
        subApplication.setIcon("sample.gif");
        subApplication.setToolTipText("Tool Tip of\nPlayground");
        WorkareaManager.getInstance().registerDefinition((INavigationNode)subApplication, (Object)"subapplication.2", false);
        applicationNode.addChild((INavigationNode)subApplication);
        applicationNode.create(new NavigationNodeId("org.eclipse.riena.example.sharedViews"));
        applicationNode.create(new NavigationNodeId("org.eclipse.riena.example.uiProcesses"));
        applicationNode.create(new NavigationNodeId("org.eclipse.riena.example.playground"));
        applicationNode.create(new NavigationNodeId("org.eclipse.riena.example.filters"));
        applicationNode.create(new NavigationNodeId("org.eclipse.riena.example.logcollector"));
        NavigationTreeObserver navigationTreeObserver = new NavigationTreeObserver();
        navigationTreeObserver.addListener((ISubModuleNodeListener)new SubModuleListener());
        navigationTreeObserver.addListenerTo((IApplicationNode)applicationNode);
        return applicationNode;
    }

    protected String getKeyScheme() {
        return "org.eclipse.riena.example.client.scheme";
    }

    private static final class SubModuleListener
    extends SubModuleNodeListener {
        private SubModuleListener() {
        }

        public void activated(ISubModuleNode source) {
            ApplicationNode appNode = (ApplicationNode)source.getParentOfType(ApplicationNode.class);
            ApplicationController controller = (ApplicationController)appNode.getNavigationNodeController();
            IStatuslineRidget statusline = controller.getStatusline();
            if (statusline != null) {
                statusline.getStatuslineNumberRidget().setNumberString(source.getLabel());
            }
        }
    }
}

