/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.application;

import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.navigation.ui.marker.UIProcessFinishedObserver;
import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeController;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ui.controllers.ApplicationController;
import org.eclipse.riena.navigation.ui.controllers.SubApplicationController;
import org.eclipse.riena.ui.core.uiprocess.IProgressVisualizer;
import org.eclipse.riena.ui.core.uiprocess.IProgressVisualizerLocator;
import org.eclipse.riena.ui.core.uiprocess.IProgressVisualizerObserver;
import org.eclipse.riena.ui.core.uiprocess.ProgressVisualizer;
import org.eclipse.riena.ui.ridgets.IStatuslineUIProcessRidget;

public class ProgressVisualizerLocator
implements IProgressVisualizerLocator {
    private static final Logger LOGGER = Log4r.getLogger(ProgressVisualizerLocator.class);

    public IProgressVisualizer getProgressVisualizer(Object context) {
        ProgressVisualizer aVisualizer = new ProgressVisualizer();
        if (context != null && INavigationNode.class.isAssignableFrom(context.getClass())) {
            ISubApplicationNode subApp;
            INavigationNode node = (INavigationNode)INavigationNode.class.cast(context);
            IStatuslineUIProcessRidget statuslineUIProcessRidget = this.getStatuslineUIProcessRidget();
            if (statuslineUIProcessRidget != null) {
                aVisualizer.addObserver((IProgressVisualizerObserver)statuslineUIProcessRidget);
            }
            if ((subApp = (ISubApplicationNode)node.getParentOfType(ISubApplicationNode.class)) == null && context instanceof ISubApplicationNode) {
                subApp = (ISubApplicationNode)context;
            }
            if (subApp != null) {
                aVisualizer.addObserver(this.getUIProcessRidget(subApp));
                aVisualizer.addObserver((IProgressVisualizerObserver)this.createObserver(node));
            }
        }
        return aVisualizer;
    }

    private IStatuslineUIProcessRidget getStatuslineUIProcessRidget() {
        IApplicationNode appNode = ApplicationNodeManager.getApplicationNode();
        if (appNode != null) {
            INavigationNodeController navigationNodeController = appNode.getNavigationNodeController();
            if (navigationNodeController != null && navigationNodeController instanceof ApplicationController) {
                return ((ApplicationController)navigationNodeController).getStatusline().getStatuslineUIProcessRidget();
            }
            LOGGER.log(1, "Unexpected: navigation node controller == null");
        } else {
            LOGGER.log(1, "Unexpected: appNode == null");
        }
        return null;
    }

    private UIProcessFinishedObserver createObserver(INavigationNode<?> node) {
        return new UIProcessFinishedObserver(node);
    }

    private IProgressVisualizerObserver getUIProcessRidget(ISubApplicationNode subApp) {
        return ((SubApplicationController)subApp.getNavigationNodeController()).getUiProcessRidget();
    }
}

