/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.objecttransaction;

import org.eclipse.riena.objecttransaction.IObjectId;
import org.eclipse.riena.objecttransaction.IObjectTransaction;
import org.eclipse.riena.objecttransaction.IObjectTransactionManager;
import org.eclipse.riena.objecttransaction.ITransactedObject;
import org.eclipse.riena.objecttransaction.ObjectTransactionManager;

public abstract class AbstractTransactedObject
implements ITransactedObject {
    private IObjectId objectId;
    private String version;
    private final IObjectTransactionManager objectTransactionManager = ObjectTransactionManager.getInstance();

    protected AbstractTransactedObject() {
    }

    protected AbstractTransactedObject(IObjectId objectId, String version) {
        this();
        this.setObjectId(objectId);
        this.setVersion(version);
    }

    @Override
    public IObjectId getObjectId() {
        return this.objectId;
    }

    @Override
    public void setObjectId(IObjectId objectId) {
        this.objectId = objectId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String versionString) {
        this.version = versionString;
    }

    public String toString() {
        return "TransactedObject: objectId='" + this.objectId + "', version='" + this.version + "'";
    }

    public boolean equals(Object object) {
        if (object instanceof ITransactedObject) {
            return this.objectId.equals(((ITransactedObject)object).getObjectId());
        }
        return false;
    }

    public int hashCode() {
        return this.getObjectId().hashCode();
    }

    protected IObjectTransaction getCurrentObjectTransaction() {
        return this.objectTransactionManager.getCurrent();
    }
}

