/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.ping;

import org.eclipse.riena.core.ping.DefaultPingable;
import org.eclipse.riena.core.ping.IPingable;
import org.eclipse.riena.core.ping.PingFingerprint;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;

@NonUITestCase
public class PingFingerprintTest
extends RienaTestCase {
    public void testPingFingerprintIPingable() {
        try {
            new PingFingerprint(null);
            PingFingerprintTest.fail((String)"Expected precondition violation");
        }
        catch (Exception exception) {
            this.ok();
        }
        DefaultPingable pingable = new DefaultPingable(){};
        PingFingerprint fingerprint = new PingFingerprint((IPingable)pingable);
        PingFingerprintTest.assertEquals((Object)new PingFingerprint((IPingable)pingable, true), (Object)fingerprint);
    }

    public void testPingFingerprintIPingableBoolean() {
        try {
            new PingFingerprint(null, true);
            PingFingerprintTest.fail((String)"Expected precondition violation");
        }
        catch (Exception exception) {
            this.ok();
        }
        DefaultPingable pingable = new DefaultPingable(){};
        PingFingerprintTest.assertEquals((String)("PingFingerprint[" + pingable.getClass().getName() + "]"), (String)new PingFingerprint((IPingable)pingable, true).toString());
        PingFingerprintTest.assertEquals((String)("PingFingerprint[" + pingable.getClass().getName() + "#" + System.identityHashCode(pingable) + "]"), (String)new PingFingerprint((IPingable)pingable, false).toString());
    }

    public void testEqualsAndHash() {
        DefaultPingable pingable = new DefaultPingable(){};
        PingFingerprint fingerprintA = new PingFingerprint((IPingable)pingable, "a");
        PingFingerprint fingerprintB = new PingFingerprint((IPingable)pingable, "b");
        PingFingerprint fingerprintAOtherPingable = new PingFingerprint((IPingable)new DefaultPingable(){}, "a");
        this.checkEqualsAndHashCode(true, fingerprintA, fingerprintA);
        this.checkEqualsAndHashCode(true, fingerprintA, new PingFingerprint((IPingable)pingable, "a"));
        this.checkEqualsAndHashCode(false, fingerprintA, fingerprintB);
        this.checkEqualsAndHashCode(false, fingerprintA, fingerprintAOtherPingable);
        this.checkEqualsAndHashCode(false, fingerprintA, new Integer(3));
        this.checkEqualsAndHashCode(false, fingerprintA, null);
    }

    private void checkEqualsAndHashCode(boolean equalityExpected, Object first, Object second) {
        if (first == null) {
            PingFingerprintTest.assertEquals((boolean)equalityExpected, (first == second ? 1 : 0) != 0);
            return;
        }
        PingFingerprintTest.assertEquals((boolean)equalityExpected, (boolean)first.equals(second));
        if (second != null) {
            PingFingerprintTest.assertEquals((boolean)equalityExpected, (first.hashCode() == second.hashCode() ? 1 : 0) != 0);
        }
    }
}

